@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.inputs

import com.pulumi.aws.emr.inputs.ClusterPlacementGroupConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property instanceRole Role of the instance in the cluster. Valid Values: `MASTER`, `CORE`, `TASK`.
 * @property placementStrategy EC2 Placement Group strategy associated with instance role. Valid Values: `SPREAD`, `PARTITION`, `CLUSTER`, `NONE`.
 */
public data class ClusterPlacementGroupConfigArgs(
    public val instanceRole: Output<String>,
    public val placementStrategy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.emr.inputs.ClusterPlacementGroupConfigArgs> {
    override fun toJava(): com.pulumi.aws.emr.inputs.ClusterPlacementGroupConfigArgs =
        com.pulumi.aws.emr.inputs.ClusterPlacementGroupConfigArgs.builder()
            .instanceRole(instanceRole.applyValue({ args0 -> args0 }))
            .placementStrategy(placementStrategy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterPlacementGroupConfigArgs].
 */
@PulumiTagMarker
public class ClusterPlacementGroupConfigArgsBuilder internal constructor() {
    private var instanceRole: Output<String>? = null

    private var placementStrategy: Output<String>? = null

    /**
     * @param value Role of the instance in the cluster. Valid Values: `MASTER`, `CORE`, `TASK`.
     */
    @JvmName("mjckhdlyllkourlt")
    public suspend fun instanceRole(`value`: Output<String>) {
        this.instanceRole = value
    }

    /**
     * @param value EC2 Placement Group strategy associated with instance role. Valid Values: `SPREAD`, `PARTITION`, `CLUSTER`, `NONE`.
     */
    @JvmName("pqlgsqrmrwglminb")
    public suspend fun placementStrategy(`value`: Output<String>) {
        this.placementStrategy = value
    }

    /**
     * @param value Role of the instance in the cluster. Valid Values: `MASTER`, `CORE`, `TASK`.
     */
    @JvmName("osbgvcbhkicqkhpu")
    public suspend fun instanceRole(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceRole = mapped
    }

    /**
     * @param value EC2 Placement Group strategy associated with instance role. Valid Values: `SPREAD`, `PARTITION`, `CLUSTER`, `NONE`.
     */
    @JvmName("nlhjuovapplodngk")
    public suspend fun placementStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.placementStrategy = mapped
    }

    internal fun build(): ClusterPlacementGroupConfigArgs = ClusterPlacementGroupConfigArgs(
        instanceRole = instanceRole ?: throw PulumiNullFieldException("instanceRole"),
        placementStrategy = placementStrategy,
    )
}
