@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.inputs

import com.pulumi.aws.emr.inputs.ClusterStepArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property actionOnFailure Action to take if the step fails. Valid values: `TERMINATE_JOB_FLOW`, `TERMINATE_CLUSTER`, `CANCEL_AND_WAIT`, and `CONTINUE`
 * @property hadoopJarStep JAR file used for the step. See below.
 * @property name Name of the step.
 */
public data class ClusterStepArgs(
    public val actionOnFailure: Output<String>,
    public val hadoopJarStep: Output<ClusterStepHadoopJarStepArgs>,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.emr.inputs.ClusterStepArgs> {
    override fun toJava(): com.pulumi.aws.emr.inputs.ClusterStepArgs =
        com.pulumi.aws.emr.inputs.ClusterStepArgs.builder()
            .actionOnFailure(actionOnFailure.applyValue({ args0 -> args0 }))
            .hadoopJarStep(hadoopJarStep.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterStepArgs].
 */
@PulumiTagMarker
public class ClusterStepArgsBuilder internal constructor() {
    private var actionOnFailure: Output<String>? = null

    private var hadoopJarStep: Output<ClusterStepHadoopJarStepArgs>? = null

    private var name: Output<String>? = null

    /**
     * @param value Action to take if the step fails. Valid values: `TERMINATE_JOB_FLOW`, `TERMINATE_CLUSTER`, `CANCEL_AND_WAIT`, and `CONTINUE`
     */
    @JvmName("aqskpfhmkqjbtjlv")
    public suspend fun actionOnFailure(`value`: Output<String>) {
        this.actionOnFailure = value
    }

    /**
     * @param value JAR file used for the step. See below.
     */
    @JvmName("twwsilxneysyodgr")
    public suspend fun hadoopJarStep(`value`: Output<ClusterStepHadoopJarStepArgs>) {
        this.hadoopJarStep = value
    }

    /**
     * @param value Name of the step.
     */
    @JvmName("heotddyywceqsdal")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Action to take if the step fails. Valid values: `TERMINATE_JOB_FLOW`, `TERMINATE_CLUSTER`, `CANCEL_AND_WAIT`, and `CONTINUE`
     */
    @JvmName("fpkshsvruuvrdqfr")
    public suspend fun actionOnFailure(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionOnFailure = mapped
    }

    /**
     * @param value JAR file used for the step. See below.
     */
    @JvmName("qruokjoxrtherblo")
    public suspend fun hadoopJarStep(`value`: ClusterStepHadoopJarStepArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hadoopJarStep = mapped
    }

    /**
     * @param argument JAR file used for the step. See below.
     */
    @JvmName("gdtyuxsxdvrwtlwl")
    public suspend fun hadoopJarStep(argument: suspend ClusterStepHadoopJarStepArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterStepHadoopJarStepArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hadoopJarStep = mapped
    }

    /**
     * @param value Name of the step.
     */
    @JvmName("nleefubomloqpsep")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ClusterStepArgs = ClusterStepArgs(
        actionOnFailure = actionOnFailure ?: throw PulumiNullFieldException("actionOnFailure"),
        hadoopJarStep = hadoopJarStep ?: throw PulumiNullFieldException("hadoopJarStep"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
