@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.inputs

import com.pulumi.aws.emr.inputs.GetReleaseLabelsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getReleaseLabels.
 * @property filters Filters the results of the request. Prefix specifies the prefix of release labels to return. Application specifies the application (with/without version) of release labels to return. See Filters.
 */
public data class GetReleaseLabelsPlainArgs(
    public val filters: GetReleaseLabelsFilters? = null,
) : ConvertibleToJava<com.pulumi.aws.emr.inputs.GetReleaseLabelsPlainArgs> {
    override fun toJava(): com.pulumi.aws.emr.inputs.GetReleaseLabelsPlainArgs =
        com.pulumi.aws.emr.inputs.GetReleaseLabelsPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GetReleaseLabelsPlainArgs].
 */
@PulumiTagMarker
public class GetReleaseLabelsPlainArgsBuilder internal constructor() {
    private var filters: GetReleaseLabelsFilters? = null

    /**
     * @param value Filters the results of the request. Prefix specifies the prefix of release labels to return. Application specifies the application (with/without version) of release labels to return. See Filters.
     */
    @JvmName("txtvcdqbhdkojrak")
    public suspend fun filters(`value`: GetReleaseLabelsFilters?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Filters the results of the request. Prefix specifies the prefix of release labels to return. Application specifies the application (with/without version) of release labels to return. See Filters.
     */
    @JvmName("incltnsjmfexuems")
    public suspend fun filters(argument: suspend GetReleaseLabelsFiltersBuilder.() -> Unit) {
        val toBeMapped = GetReleaseLabelsFiltersBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.filters = mapped
    }

    internal fun build(): GetReleaseLabelsPlainArgs = GetReleaseLabelsPlainArgs(
        filters = filters,
    )
}
