@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.inputs

import com.pulumi.aws.emr.inputs.GetSupportedInstanceTypesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSupportedInstanceTypes.
 * @property releaseLabel Amazon EMR release label. For more information about Amazon EMR releases and their included application versions and features, see the [Amazon EMR Release Guide](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-release-components.html).
 * @property supportedInstanceTypes List of supported instance types. See `supported_instance_types` below.
 */
public data class GetSupportedInstanceTypesPlainArgs(
    public val releaseLabel: String,
    public val supportedInstanceTypes: List<GetSupportedInstanceTypesSupportedInstanceType>? = null,
) : ConvertibleToJava<com.pulumi.aws.emr.inputs.GetSupportedInstanceTypesPlainArgs> {
    override fun toJava(): com.pulumi.aws.emr.inputs.GetSupportedInstanceTypesPlainArgs =
        com.pulumi.aws.emr.inputs.GetSupportedInstanceTypesPlainArgs.builder()
            .releaseLabel(releaseLabel.let({ args0 -> args0 }))
            .supportedInstanceTypes(
                supportedInstanceTypes?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetSupportedInstanceTypesPlainArgs].
 */
@PulumiTagMarker
public class GetSupportedInstanceTypesPlainArgsBuilder internal constructor() {
    private var releaseLabel: String? = null

    private var supportedInstanceTypes: List<GetSupportedInstanceTypesSupportedInstanceType>? = null

    /**
     * @param value Amazon EMR release label. For more information about Amazon EMR releases and their included application versions and features, see the [Amazon EMR Release Guide](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-release-components.html).
     */
    @JvmName("ycdmghvufdvnfpsc")
    public suspend fun releaseLabel(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.releaseLabel = mapped
    }

    /**
     * @param value List of supported instance types. See `supported_instance_types` below.
     */
    @JvmName("vaapwgvogmisuxvv")
    public suspend fun supportedInstanceTypes(`value`: List<GetSupportedInstanceTypesSupportedInstanceType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.supportedInstanceTypes = mapped
    }

    /**
     * @param argument List of supported instance types. See `supported_instance_types` below.
     */
    @JvmName("mpawkcvidoqbmunk")
    public suspend fun supportedInstanceTypes(argument: List<suspend GetSupportedInstanceTypesSupportedInstanceTypeBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetSupportedInstanceTypesSupportedInstanceTypeBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.supportedInstanceTypes = mapped
    }

    /**
     * @param argument List of supported instance types. See `supported_instance_types` below.
     */
    @JvmName("yjpysjoohxewgjam")
    public suspend fun supportedInstanceTypes(vararg argument: suspend GetSupportedInstanceTypesSupportedInstanceTypeBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetSupportedInstanceTypesSupportedInstanceTypeBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.supportedInstanceTypes = mapped
    }

    /**
     * @param argument List of supported instance types. See `supported_instance_types` below.
     */
    @JvmName("ujyrfolgkwwlwish")
    public suspend fun supportedInstanceTypes(argument: suspend GetSupportedInstanceTypesSupportedInstanceTypeBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetSupportedInstanceTypesSupportedInstanceTypeBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.supportedInstanceTypes = mapped
    }

    /**
     * @param values List of supported instance types. See `supported_instance_types` below.
     */
    @JvmName("olcjojjhvlaiobna")
    public suspend fun supportedInstanceTypes(vararg values: GetSupportedInstanceTypesSupportedInstanceType) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.supportedInstanceTypes = mapped
    }

    internal fun build(): GetSupportedInstanceTypesPlainArgs = GetSupportedInstanceTypesPlainArgs(
        releaseLabel = releaseLabel ?: throw PulumiNullFieldException("releaseLabel"),
        supportedInstanceTypes = supportedInstanceTypes,
    )
}
