@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.inputs

import com.pulumi.aws.emr.inputs.InstanceFleetInstanceTypeConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property bidPrice The bid price for each EC2 Spot instance type as defined by `instance_type`. Expressed in USD. If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
 * @property bidPriceAsPercentageOfOnDemandPrice The bid price, as a percentage of On-Demand price, for each EC2 Spot instance as defined by `instance_type`. Expressed as a number (for example, 20 specifies 20%). If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
 * @property configurations A configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
 * @property ebsConfigs Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
 * @property instanceType An EC2 instance type, such as m4.xlarge.
 * @property weightedCapacity The number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in `aws.emr.InstanceFleet`.
 */
public data class InstanceFleetInstanceTypeConfigArgs(
    public val bidPrice: Output<String>? = null,
    public val bidPriceAsPercentageOfOnDemandPrice: Output<Double>? = null,
    public val configurations: Output<List<InstanceFleetInstanceTypeConfigConfigurationArgs>>? = null,
    public val ebsConfigs: Output<List<InstanceFleetInstanceTypeConfigEbsConfigArgs>>? = null,
    public val instanceType: Output<String>,
    public val weightedCapacity: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.emr.inputs.InstanceFleetInstanceTypeConfigArgs> {
    override fun toJava(): com.pulumi.aws.emr.inputs.InstanceFleetInstanceTypeConfigArgs =
        com.pulumi.aws.emr.inputs.InstanceFleetInstanceTypeConfigArgs.builder()
            .bidPrice(bidPrice?.applyValue({ args0 -> args0 }))
            .bidPriceAsPercentageOfOnDemandPrice(
                bidPriceAsPercentageOfOnDemandPrice?.applyValue({ args0 ->
                    args0
                }),
            )
            .configurations(
                configurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ebsConfigs(
                ebsConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .weightedCapacity(weightedCapacity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceFleetInstanceTypeConfigArgs].
 */
@PulumiTagMarker
public class InstanceFleetInstanceTypeConfigArgsBuilder internal constructor() {
    private var bidPrice: Output<String>? = null

    private var bidPriceAsPercentageOfOnDemandPrice: Output<Double>? = null

    private var configurations: Output<List<InstanceFleetInstanceTypeConfigConfigurationArgs>>? = null

    private var ebsConfigs: Output<List<InstanceFleetInstanceTypeConfigEbsConfigArgs>>? = null

    private var instanceType: Output<String>? = null

    private var weightedCapacity: Output<Int>? = null

    /**
     * @param value The bid price for each EC2 Spot instance type as defined by `instance_type`. Expressed in USD. If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
     */
    @JvmName("qakydorqoeimriga")
    public suspend fun bidPrice(`value`: Output<String>) {
        this.bidPrice = value
    }

    /**
     * @param value The bid price, as a percentage of On-Demand price, for each EC2 Spot instance as defined by `instance_type`. Expressed as a number (for example, 20 specifies 20%). If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
     */
    @JvmName("rtetshjhplieqxlj")
    public suspend fun bidPriceAsPercentageOfOnDemandPrice(`value`: Output<Double>) {
        this.bidPriceAsPercentageOfOnDemandPrice = value
    }

    /**
     * @param value A configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
     */
    @JvmName("uodyijresufvjdab")
    public suspend fun configurations(`value`: Output<List<InstanceFleetInstanceTypeConfigConfigurationArgs>>) {
        this.configurations = value
    }

    @JvmName("pakajbfladavwmql")
    public suspend fun configurations(vararg values: Output<InstanceFleetInstanceTypeConfigConfigurationArgs>) {
        this.configurations = Output.all(values.asList())
    }

    /**
     * @param values A configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
     */
    @JvmName("qrgclxbspxvseyab")
    public suspend fun configurations(values: List<Output<InstanceFleetInstanceTypeConfigConfigurationArgs>>) {
        this.configurations = Output.all(values)
    }

    /**
     * @param value Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
     */
    @JvmName("tboswfqmatsgmjjk")
    public suspend fun ebsConfigs(`value`: Output<List<InstanceFleetInstanceTypeConfigEbsConfigArgs>>) {
        this.ebsConfigs = value
    }

    @JvmName("bsfhbtrxcrehmmir")
    public suspend fun ebsConfigs(vararg values: Output<InstanceFleetInstanceTypeConfigEbsConfigArgs>) {
        this.ebsConfigs = Output.all(values.asList())
    }

    /**
     * @param values Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
     */
    @JvmName("pdnnqfioekpoicjk")
    public suspend fun ebsConfigs(values: List<Output<InstanceFleetInstanceTypeConfigEbsConfigArgs>>) {
        this.ebsConfigs = Output.all(values)
    }

    /**
     * @param value An EC2 instance type, such as m4.xlarge.
     */
    @JvmName("isqyoyctplkjlfkn")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in `aws.emr.InstanceFleet`.
     */
    @JvmName("wdwqvrkfahctfvwe")
    public suspend fun weightedCapacity(`value`: Output<Int>) {
        this.weightedCapacity = value
    }

    /**
     * @param value The bid price for each EC2 Spot instance type as defined by `instance_type`. Expressed in USD. If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
     */
    @JvmName("mfivlgfhxyvnpsvy")
    public suspend fun bidPrice(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bidPrice = mapped
    }

    /**
     * @param value The bid price, as a percentage of On-Demand price, for each EC2 Spot instance as defined by `instance_type`. Expressed as a number (for example, 20 specifies 20%). If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
     */
    @JvmName("sahvkrefnithcxiy")
    public suspend fun bidPriceAsPercentageOfOnDemandPrice(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bidPriceAsPercentageOfOnDemandPrice = mapped
    }

    /**
     * @param value A configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
     */
    @JvmName("hcecluqlfjkmtiht")
    public suspend fun configurations(`value`: List<InstanceFleetInstanceTypeConfigConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurations = mapped
    }

    /**
     * @param argument A configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
     */
    @JvmName("mkgyonyrqcabshde")
    public suspend fun configurations(argument: List<suspend InstanceFleetInstanceTypeConfigConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstanceFleetInstanceTypeConfigConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param argument A configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
     */
    @JvmName("rbtmobxgpyrygwqq")
    public suspend fun configurations(vararg argument: suspend InstanceFleetInstanceTypeConfigConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InstanceFleetInstanceTypeConfigConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param argument A configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
     */
    @JvmName("nrobfbogbvrxohdk")
    public suspend fun configurations(argument: suspend InstanceFleetInstanceTypeConfigConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InstanceFleetInstanceTypeConfigConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param values A configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
     */
    @JvmName("nociahquncnqjwjw")
    public suspend fun configurations(vararg values: InstanceFleetInstanceTypeConfigConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurations = mapped
    }

    /**
     * @param value Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
     */
    @JvmName("pjdcfddtcswaslbw")
    public suspend fun ebsConfigs(`value`: List<InstanceFleetInstanceTypeConfigEbsConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebsConfigs = mapped
    }

    /**
     * @param argument Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
     */
    @JvmName("nvcdyerhcphyncek")
    public suspend fun ebsConfigs(argument: List<suspend InstanceFleetInstanceTypeConfigEbsConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstanceFleetInstanceTypeConfigEbsConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsConfigs = mapped
    }

    /**
     * @param argument Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
     */
    @JvmName("qkvvviuotircduxt")
    public suspend fun ebsConfigs(vararg argument: suspend InstanceFleetInstanceTypeConfigEbsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InstanceFleetInstanceTypeConfigEbsConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsConfigs = mapped
    }

    /**
     * @param argument Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
     */
    @JvmName("eacnkripnvxayljk")
    public suspend fun ebsConfigs(argument: suspend InstanceFleetInstanceTypeConfigEbsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InstanceFleetInstanceTypeConfigEbsConfigArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ebsConfigs = mapped
    }

    /**
     * @param values Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
     */
    @JvmName("xljigrvvlpguxihq")
    public suspend fun ebsConfigs(vararg values: InstanceFleetInstanceTypeConfigEbsConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ebsConfigs = mapped
    }

    /**
     * @param value An EC2 instance type, such as m4.xlarge.
     */
    @JvmName("ofkwjfopqeviibpx")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in `aws.emr.InstanceFleet`.
     */
    @JvmName("mnqgetjhsomawerk")
    public suspend fun weightedCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weightedCapacity = mapped
    }

    internal fun build(): InstanceFleetInstanceTypeConfigArgs = InstanceFleetInstanceTypeConfigArgs(
        bidPrice = bidPrice,
        bidPriceAsPercentageOfOnDemandPrice = bidPriceAsPercentageOfOnDemandPrice,
        configurations = configurations,
        ebsConfigs = ebsConfigs,
        instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
        weightedCapacity = weightedCapacity,
    )
}
