@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.inputs

import com.pulumi.aws.emr.inputs.InstanceFleetInstanceTypeConfigEbsConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property iops The number of I/O operations per second (IOPS) that the volume supports
 * @property size The volume size, in gibibytes (GiB).
 * @property type The volume type. Valid options are `gp2`, `io1`, `standard` and `st1`. See [EBS Volume Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
 * @property volumesPerInstance The number of EBS volumes with this configuration to attach to each EC2 instance in the instance group (default is 1)
 */
public data class InstanceFleetInstanceTypeConfigEbsConfigArgs(
    public val iops: Output<Int>? = null,
    public val size: Output<Int>,
    public val type: Output<String>,
    public val volumesPerInstance: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.emr.inputs.InstanceFleetInstanceTypeConfigEbsConfigArgs> {
    override fun toJava(): com.pulumi.aws.emr.inputs.InstanceFleetInstanceTypeConfigEbsConfigArgs =
        com.pulumi.aws.emr.inputs.InstanceFleetInstanceTypeConfigEbsConfigArgs.builder()
            .iops(iops?.applyValue({ args0 -> args0 }))
            .size(size.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .volumesPerInstance(volumesPerInstance?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceFleetInstanceTypeConfigEbsConfigArgs].
 */
@PulumiTagMarker
public class InstanceFleetInstanceTypeConfigEbsConfigArgsBuilder internal constructor() {
    private var iops: Output<Int>? = null

    private var size: Output<Int>? = null

    private var type: Output<String>? = null

    private var volumesPerInstance: Output<Int>? = null

    /**
     * @param value The number of I/O operations per second (IOPS) that the volume supports
     */
    @JvmName("wvdlfpsmvdoqarfo")
    public suspend fun iops(`value`: Output<Int>) {
        this.iops = value
    }

    /**
     * @param value The volume size, in gibibytes (GiB).
     */
    @JvmName("uwxmbhiqwrhxejdx")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value The volume type. Valid options are `gp2`, `io1`, `standard` and `st1`. See [EBS Volume Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
     */
    @JvmName("uebwrhlbuacpmmhy")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The number of EBS volumes with this configuration to attach to each EC2 instance in the instance group (default is 1)
     */
    @JvmName("vhnicdgkqetapmxf")
    public suspend fun volumesPerInstance(`value`: Output<Int>) {
        this.volumesPerInstance = value
    }

    /**
     * @param value The number of I/O operations per second (IOPS) that the volume supports
     */
    @JvmName("kawxhuobllbihpbk")
    public suspend fun iops(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iops = mapped
    }

    /**
     * @param value The volume size, in gibibytes (GiB).
     */
    @JvmName("yiacpvfpxxpcarig")
    public suspend fun size(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value The volume type. Valid options are `gp2`, `io1`, `standard` and `st1`. See [EBS Volume Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
     */
    @JvmName("hlppopbumajwjtma")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The number of EBS volumes with this configuration to attach to each EC2 instance in the instance group (default is 1)
     */
    @JvmName("idbpcwmbfxtgcduk")
    public suspend fun volumesPerInstance(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumesPerInstance = mapped
    }

    internal fun build(): InstanceFleetInstanceTypeConfigEbsConfigArgs =
        InstanceFleetInstanceTypeConfigEbsConfigArgs(
            iops = iops,
            size = size ?: throw PulumiNullFieldException("size"),
            type = type ?: throw PulumiNullFieldException("type"),
            volumesPerInstance = volumesPerInstance,
        )
}
