@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.inputs

import com.pulumi.aws.emr.inputs.InstanceFleetLaunchSpecificationsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property onDemandSpecifications Configuration block for on demand instances launch specifications
 * @property spotSpecifications Configuration block for spot instances launch specifications
 */
public data class InstanceFleetLaunchSpecificationsArgs(
    public val onDemandSpecifications: Output<List<InstanceFleetLaunchSpecificationsOnDemandSpecificationArgs>>? = null,
    public val spotSpecifications: Output<List<InstanceFleetLaunchSpecificationsSpotSpecificationArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.emr.inputs.InstanceFleetLaunchSpecificationsArgs> {
    override fun toJava(): com.pulumi.aws.emr.inputs.InstanceFleetLaunchSpecificationsArgs =
        com.pulumi.aws.emr.inputs.InstanceFleetLaunchSpecificationsArgs.builder()
            .onDemandSpecifications(
                onDemandSpecifications?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .spotSpecifications(
                spotSpecifications?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [InstanceFleetLaunchSpecificationsArgs].
 */
@PulumiTagMarker
public class InstanceFleetLaunchSpecificationsArgsBuilder internal constructor() {
    private var onDemandSpecifications:
        Output<List<InstanceFleetLaunchSpecificationsOnDemandSpecificationArgs>>? = null

    private var spotSpecifications:
        Output<List<InstanceFleetLaunchSpecificationsSpotSpecificationArgs>>? = null

    /**
     * @param value Configuration block for on demand instances launch specifications
     */
    @JvmName("yfwuhrgmhayiyqpy")
    public suspend fun onDemandSpecifications(`value`: Output<List<InstanceFleetLaunchSpecificationsOnDemandSpecificationArgs>>) {
        this.onDemandSpecifications = value
    }

    @JvmName("tjymtkbovioimxut")
    public suspend fun onDemandSpecifications(vararg values: Output<InstanceFleetLaunchSpecificationsOnDemandSpecificationArgs>) {
        this.onDemandSpecifications = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for on demand instances launch specifications
     */
    @JvmName("pjfvkfciyivcnmjp")
    public suspend fun onDemandSpecifications(values: List<Output<InstanceFleetLaunchSpecificationsOnDemandSpecificationArgs>>) {
        this.onDemandSpecifications = Output.all(values)
    }

    /**
     * @param value Configuration block for spot instances launch specifications
     */
    @JvmName("snkrmacyyitjckpd")
    public suspend fun spotSpecifications(`value`: Output<List<InstanceFleetLaunchSpecificationsSpotSpecificationArgs>>) {
        this.spotSpecifications = value
    }

    @JvmName("tchrpgoaihnvuwyj")
    public suspend fun spotSpecifications(vararg values: Output<InstanceFleetLaunchSpecificationsSpotSpecificationArgs>) {
        this.spotSpecifications = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for spot instances launch specifications
     */
    @JvmName("bnpwextspdximtjk")
    public suspend fun spotSpecifications(values: List<Output<InstanceFleetLaunchSpecificationsSpotSpecificationArgs>>) {
        this.spotSpecifications = Output.all(values)
    }

    /**
     * @param value Configuration block for on demand instances launch specifications
     */
    @JvmName("djkuytfmrvouflqk")
    public suspend fun onDemandSpecifications(`value`: List<InstanceFleetLaunchSpecificationsOnDemandSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onDemandSpecifications = mapped
    }

    /**
     * @param argument Configuration block for on demand instances launch specifications
     */
    @JvmName("wajtagmuoyxpgrsy")
    public suspend fun onDemandSpecifications(argument: List<suspend InstanceFleetLaunchSpecificationsOnDemandSpecificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstanceFleetLaunchSpecificationsOnDemandSpecificationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.onDemandSpecifications = mapped
    }

    /**
     * @param argument Configuration block for on demand instances launch specifications
     */
    @JvmName("dbtwgtsgvvysksup")
    public suspend fun onDemandSpecifications(vararg argument: suspend InstanceFleetLaunchSpecificationsOnDemandSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InstanceFleetLaunchSpecificationsOnDemandSpecificationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.onDemandSpecifications = mapped
    }

    /**
     * @param argument Configuration block for on demand instances launch specifications
     */
    @JvmName("mtptmvunxftviffg")
    public suspend fun onDemandSpecifications(argument: suspend InstanceFleetLaunchSpecificationsOnDemandSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                InstanceFleetLaunchSpecificationsOnDemandSpecificationArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.onDemandSpecifications = mapped
    }

    /**
     * @param values Configuration block for on demand instances launch specifications
     */
    @JvmName("fsuqbixmkxaknkon")
    public suspend fun onDemandSpecifications(vararg values: InstanceFleetLaunchSpecificationsOnDemandSpecificationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onDemandSpecifications = mapped
    }

    /**
     * @param value Configuration block for spot instances launch specifications
     */
    @JvmName("ulmfawfqbfkwluly")
    public suspend fun spotSpecifications(`value`: List<InstanceFleetLaunchSpecificationsSpotSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotSpecifications = mapped
    }

    /**
     * @param argument Configuration block for spot instances launch specifications
     */
    @JvmName("ohetrnckhkekecvt")
    public suspend fun spotSpecifications(argument: List<suspend InstanceFleetLaunchSpecificationsSpotSpecificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstanceFleetLaunchSpecificationsSpotSpecificationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.spotSpecifications = mapped
    }

    /**
     * @param argument Configuration block for spot instances launch specifications
     */
    @JvmName("tffnetfdsfokxhuq")
    public suspend fun spotSpecifications(vararg argument: suspend InstanceFleetLaunchSpecificationsSpotSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InstanceFleetLaunchSpecificationsSpotSpecificationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.spotSpecifications = mapped
    }

    /**
     * @param argument Configuration block for spot instances launch specifications
     */
    @JvmName("khhwybydgadyyyyb")
    public suspend fun spotSpecifications(argument: suspend InstanceFleetLaunchSpecificationsSpotSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                InstanceFleetLaunchSpecificationsSpotSpecificationArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.spotSpecifications = mapped
    }

    /**
     * @param values Configuration block for spot instances launch specifications
     */
    @JvmName("gdlyuwfcnmybcssn")
    public suspend fun spotSpecifications(vararg values: InstanceFleetLaunchSpecificationsSpotSpecificationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.spotSpecifications = mapped
    }

    internal fun build(): InstanceFleetLaunchSpecificationsArgs =
        InstanceFleetLaunchSpecificationsArgs(
            onDemandSpecifications = onDemandSpecifications,
            spotSpecifications = spotSpecifications,
        )
}
