@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property idleTimeout Specifies the amount of idle time in seconds after which the cluster automatically terminates. You can specify a minimum of `60` seconds and a maximum of `604800` seconds (seven days).
 */
public data class ClusterAutoTerminationPolicy(
    public val idleTimeout: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.emr.outputs.ClusterAutoTerminationPolicy): ClusterAutoTerminationPolicy = ClusterAutoTerminationPolicy(
            idleTimeout = javaType.idleTimeout().map({ args0 -> args0 }).orElse(null),
        )
    }
}
