@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property allocationStrategy Specifies the strategy to use in launching Spot instance fleets. Valid values include `capacity-optimized`, `diversified`, `lowest-price`, `price-capacity-optimized`. See the [AWS documentation](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html#emr-instance-fleet-allocation-strategy) for details on each strategy type.
 * @property blockDurationMinutes Defined duration for Spot instances (also known as Spot blocks) in minutes. When specified, the Spot instance does not terminate before the defined duration expires, and defined duration pricing for Spot instances applies. Valid values are 60, 120, 180, 240, 300, or 360. The duration period starts as soon as a Spot instance receives its instance ID. At the end of the duration, Amazon EC2 marks the Spot instance for termination and provides a Spot instance termination notice, which gives the instance a two-minute warning before it terminates.
 * @property timeoutAction Action to take when TargetSpotCapacity has not been fulfilled when the TimeoutDurationMinutes has expired; that is, when all Spot instances could not be provisioned within the Spot provisioning timeout. Valid values are `TERMINATE_CLUSTER` and `SWITCH_TO_ON_DEMAND`. SWITCH_TO_ON_DEMAND specifies that if no Spot instances are available, On-Demand Instances should be provisioned to fulfill any remaining Spot capacity.
 * @property timeoutDurationMinutes Spot provisioning timeout period in minutes. If Spot instances are not provisioned within this time period, the TimeOutAction is taken. Minimum value is 5 and maximum value is 1440. The timeout applies only during initial provisioning, when the cluster is first created.
 */
public data class ClusterCoreInstanceFleetLaunchSpecificationsSpotSpecification(
    public val allocationStrategy: String,
    public val blockDurationMinutes: Int? = null,
    public val timeoutAction: String,
    public val timeoutDurationMinutes: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.emr.outputs.ClusterCoreInstanceFleetLaunchSpecificationsSpotSpecification): ClusterCoreInstanceFleetLaunchSpecificationsSpotSpecification =
            ClusterCoreInstanceFleetLaunchSpecificationsSpotSpecification(
                allocationStrategy = javaType.allocationStrategy(),
                blockDurationMinutes = javaType.blockDurationMinutes().map({ args0 -> args0 }).orElse(null),
                timeoutAction = javaType.timeoutAction(),
                timeoutDurationMinutes = javaType.timeoutDurationMinutes(),
            )
    }
}
