@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property additionalMasterSecurityGroups String containing a comma separated list of additional Amazon EC2 security group IDs for the master node.
 * @property additionalSlaveSecurityGroups String containing a comma separated list of additional Amazon EC2 security group IDs for the slave nodes as a comma separated string.
 * @property emrManagedMasterSecurityGroup Identifier of the Amazon EC2 EMR-Managed security group for the master node.
 * @property emrManagedSlaveSecurityGroup Identifier of the Amazon EC2 EMR-Managed security group for the slave nodes.
 * @property instanceProfile Instance Profile for EC2 instances of the cluster assume this role.
 * @property keyName Amazon EC2 key pair that can be used to ssh to the master node as the user called `hadoop`.
 * @property serviceAccessSecurityGroup Identifier of the Amazon EC2 service-access security group - required when the cluster runs on a private subnet.
 * @property subnetId VPC subnet id where you want the job flow to launch. Cannot specify the `cc1.4xlarge` instance type for nodes of a job flow launched in an Amazon VPC.
 * @property subnetIds List of VPC subnet id-s where you want the job flow to launch.  Amazon EMR identifies the best Availability Zone to launch instances according to your fleet specifications.
 * > **NOTE on EMR-Managed security groups:** These security groups will have any missing inbound or outbound access rules added and maintained by AWS, to ensure proper communication between instances in a cluster. The EMR service will maintain these rules for groups provided in `emr_managed_master_security_group` and `emr_managed_slave_security_group`; attempts to remove the required rules may succeed, only for the EMR service to re-add them in a matter of minutes. This may cause this provider to fail to destroy an environment that contains an EMR cluster, because the EMR service does not revoke rules added on deletion, leaving a cyclic dependency between the security groups that prevents their deletion. To avoid this, use the `revoke_rules_on_delete` optional attribute for any Security Group used in `emr_managed_master_security_group` and `emr_managed_slave_security_group`. See [Amazon EMR-Managed Security Groups](http://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-man-sec-groups.html) for more information about the EMR-managed security group rules.
 */
public data class ClusterEc2Attributes(
    public val additionalMasterSecurityGroups: String? = null,
    public val additionalSlaveSecurityGroups: String? = null,
    public val emrManagedMasterSecurityGroup: String? = null,
    public val emrManagedSlaveSecurityGroup: String? = null,
    public val instanceProfile: String,
    public val keyName: String? = null,
    public val serviceAccessSecurityGroup: String? = null,
    public val subnetId: String? = null,
    public val subnetIds: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.emr.outputs.ClusterEc2Attributes): ClusterEc2Attributes = ClusterEc2Attributes(
            additionalMasterSecurityGroups = javaType.additionalMasterSecurityGroups().map({ args0 ->
                args0
            }).orElse(null),
            additionalSlaveSecurityGroups = javaType.additionalSlaveSecurityGroups().map({ args0 ->
                args0
            }).orElse(null),
            emrManagedMasterSecurityGroup = javaType.emrManagedMasterSecurityGroup().map({ args0 ->
                args0
            }).orElse(null),
            emrManagedSlaveSecurityGroup = javaType.emrManagedSlaveSecurityGroup().map({ args0 ->
                args0
            }).orElse(null),
            instanceProfile = javaType.instanceProfile(),
            keyName = javaType.keyName().map({ args0 -> args0 }).orElse(null),
            serviceAccessSecurityGroup = javaType.serviceAccessSecurityGroup().map({ args0 ->
                args0
            }).orElse(null),
            subnetId = javaType.subnetId().map({ args0 -> args0 }).orElse(null),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
        )
    }
}
