@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property adDomainJoinPassword Active Directory password for `ad_domain_join_user`. This provider cannot perform drift detection of this configuration.
 * @property adDomainJoinUser Required only when establishing a cross-realm trust with an Active Directory domain. A user with sufficient privileges to join resources to the domain. This provider cannot perform drift detection of this configuration.
 * @property crossRealmTrustPrincipalPassword Required only when establishing a cross-realm trust with a KDC in a different realm. The cross-realm principal password, which must be identical across realms. This provider cannot perform drift detection of this configuration.
 * @property kdcAdminPassword Password used within the cluster for the kadmin service on the cluster-dedicated KDC, which maintains Kerberos principals, password policies, and keytabs for the cluster. This provider cannot perform drift detection of this configuration.
 * @property realm Name of the Kerberos realm to which all nodes in a cluster belong. For example, `EC2.INTERNAL`
 */
public data class ClusterKerberosAttributes(
    public val adDomainJoinPassword: String? = null,
    public val adDomainJoinUser: String? = null,
    public val crossRealmTrustPrincipalPassword: String? = null,
    public val kdcAdminPassword: String,
    public val realm: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.emr.outputs.ClusterKerberosAttributes): ClusterKerberosAttributes = ClusterKerberosAttributes(
            adDomainJoinPassword = javaType.adDomainJoinPassword().map({ args0 -> args0 }).orElse(null),
            adDomainJoinUser = javaType.adDomainJoinUser().map({ args0 -> args0 }).orElse(null),
            crossRealmTrustPrincipalPassword = javaType.crossRealmTrustPrincipalPassword().map({ args0 ->
                args0
            }).orElse(null),
            kdcAdminPassword = javaType.kdcAdminPassword(),
            realm = javaType.realm(),
        )
    }
}
