@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property classification Classification within a configuration.
 * @property properties Map of properties specified within a configuration classification.
 */
public data class ClusterMasterInstanceFleetInstanceTypeConfigConfiguration(
    public val classification: String? = null,
    public val properties: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.emr.outputs.ClusterMasterInstanceFleetInstanceTypeConfigConfiguration): ClusterMasterInstanceFleetInstanceTypeConfigConfiguration =
            ClusterMasterInstanceFleetInstanceTypeConfigConfiguration(
                classification = javaType.classification().map({ args0 -> args0 }).orElse(null),
                properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            )
    }
}
