@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property args List of command line arguments passed to the JAR file's main function when executed.
 * @property jar Path to a JAR file run during the step.
 * @property mainClass Name of the main class in the specified Java file. If not specified, the JAR file should specify a Main-Class in its manifest file.
 * @property properties Key-Value map of Java properties that are set when the step runs. You can use these properties to pass key value pairs to your main function.
 */
public data class ClusterStepHadoopJarStep(
    public val args: List<String>? = null,
    public val jar: String,
    public val mainClass: String? = null,
    public val properties: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.emr.outputs.ClusterStepHadoopJarStep): ClusterStepHadoopJarStep = ClusterStepHadoopJarStep(
            args = javaType.args().map({ args0 -> args0 }),
            jar = javaType.jar(),
            mainClass = javaType.mainClass().map({ args0 -> args0 }).orElse(null),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
