@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getReleaseLabels.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property releaseLabels Returned release labels.
 */
public data class GetReleaseLabelsResult(
    public val filters: GetReleaseLabelsFilters? = null,
    public val id: String,
    public val releaseLabels: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.emr.outputs.GetReleaseLabelsResult): GetReleaseLabelsResult = GetReleaseLabelsResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.emr.kotlin.outputs.GetReleaseLabelsFilters.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            releaseLabels = javaType.releaseLabels().map({ args0 -> args0 }),
        )
    }
}
