@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getSupportedInstanceTypes.
 * @property id
 * @property releaseLabel
 * @property supportedInstanceTypes List of supported instance types. See `supported_instance_types` below.
 */
public data class GetSupportedInstanceTypesResult(
    public val id: String,
    public val releaseLabel: String,
    public val supportedInstanceTypes: List<GetSupportedInstanceTypesSupportedInstanceType>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.emr.outputs.GetSupportedInstanceTypesResult): GetSupportedInstanceTypesResult = GetSupportedInstanceTypesResult(
            id = javaType.id(),
            releaseLabel = javaType.releaseLabel(),
            supportedInstanceTypes = javaType.supportedInstanceTypes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.emr.kotlin.outputs.GetSupportedInstanceTypesSupportedInstanceType.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
