@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property architecture CPU architecture.
 * @property ebsOptimizedAvailable Indicates whether the instance type supports Amazon EBS optimization.
 * @property ebsOptimizedByDefault Indicates whether the instance type uses Amazon EBS optimization by default.
 * @property ebsStorageOnly Indicates whether the instance type only supports Amazon EBS.
 * @property instanceFamilyId The Amazon EC2 family and generation for the instance type.
 * @property is64BitsOnly Indicates whether the instance type only supports 64-bit architecture.
 * @property memoryGb Memory that is available to Amazon EMR from the instance type.
 * @property numberOfDisks Number of disks for the instance type.
 * @property storageGb Storage capacity of the instance type.
 * @property type Amazon EC2 instance type. For example, `m5.xlarge`.
 * @property vcpu The number of vCPUs available for the instance type.
 */
public data class GetSupportedInstanceTypesSupportedInstanceType(
    public val architecture: String,
    public val ebsOptimizedAvailable: Boolean,
    public val ebsOptimizedByDefault: Boolean,
    public val ebsStorageOnly: Boolean,
    public val instanceFamilyId: String,
    public val is64BitsOnly: Boolean,
    public val memoryGb: Double,
    public val numberOfDisks: Int,
    public val storageGb: Int,
    public val type: String,
    public val vcpu: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.emr.outputs.GetSupportedInstanceTypesSupportedInstanceType): GetSupportedInstanceTypesSupportedInstanceType =
            GetSupportedInstanceTypesSupportedInstanceType(
                architecture = javaType.architecture(),
                ebsOptimizedAvailable = javaType.ebsOptimizedAvailable(),
                ebsOptimizedByDefault = javaType.ebsOptimizedByDefault(),
                ebsStorageOnly = javaType.ebsStorageOnly(),
                instanceFamilyId = javaType.instanceFamilyId(),
                is64BitsOnly = javaType.is64BitsOnly(),
                memoryGb = javaType.memoryGb(),
                numberOfDisks = javaType.numberOfDisks(),
                storageGb = javaType.storageGb(),
                type = javaType.type(),
                vcpu = javaType.vcpu(),
            )
    }
}
