@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property allocationStrategy Specifies one of the following strategies to launch Spot Instance fleets: `price-capacity-optimized`, `capacity-optimized`, `lowest-price`, or `diversified`. For more information on the provisioning strategies, see [Allocation strategies for Spot Instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-allocation-strategy.html).
 */
public data class InstanceFleetLaunchSpecificationsOnDemandSpecification(
    public val allocationStrategy: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.emr.outputs.InstanceFleetLaunchSpecificationsOnDemandSpecification): InstanceFleetLaunchSpecificationsOnDemandSpecification =
            InstanceFleetLaunchSpecificationsOnDemandSpecification(
                allocationStrategy = javaType.allocationStrategy(),
            )
    }
}
