@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property iops The number of I/O operations per second (IOPS) that the volume supports.
 * @property size The volume size, in gibibytes (GiB). This can be a number from 1 - 1024. If the volume type is EBS-optimized, the minimum value is 10.
 * @property type The volume type. Valid options are 'gp2', 'io1' and 'standard'.
 * @property volumesPerInstance The number of EBS Volumes to attach per instance.
 */
public data class InstanceGroupEbsConfig(
    public val iops: Int? = null,
    public val size: Int,
    public val type: String,
    public val volumesPerInstance: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.emr.outputs.InstanceGroupEbsConfig): InstanceGroupEbsConfig = InstanceGroupEbsConfig(
            iops = javaType.iops().map({ args0 -> args0 }).orElse(null),
            size = javaType.size(),
            type = javaType.type(),
            volumesPerInstance = javaType.volumesPerInstance().map({ args0 -> args0 }).orElse(null),
        )
    }
}
