@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrcontainers.kotlin

import com.pulumi.aws.emrcontainers.kotlin.outputs.JobTemplateJobTemplateData
import com.pulumi.aws.emrcontainers.kotlin.outputs.JobTemplateJobTemplateData.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [JobTemplate].
 */
@PulumiTagMarker
public class JobTemplateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: JobTemplateArgs = JobTemplateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend JobTemplateArgsBuilder.() -> Unit) {
        val builder = JobTemplateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): JobTemplate {
        val builtJavaResource = com.pulumi.aws.emrcontainers.JobTemplate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return JobTemplate(builtJavaResource)
    }
}

/**
 * Manages an EMR Containers (EMR on EKS) Job Template.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.emrcontainers.JobTemplate("example", {
 *     jobTemplateData: {
 *         executionRoleArn: exampleAwsIamRole.arn,
 *         releaseLabel: "emr-6.10.0-latest",
 *         jobDriver: {
 *             sparkSqlJobDriver: {
 *                 entryPoint: "default",
 *             },
 *         },
 *     },
 *     name: "example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.emrcontainers.JobTemplate("example",
 *     job_template_data={
 *         "execution_role_arn": example_aws_iam_role["arn"],
 *         "release_label": "emr-6.10.0-latest",
 *         "job_driver": {
 *             "spark_sql_job_driver": {
 *                 "entry_point": "default",
 *             },
 *         },
 *     },
 *     name="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.EmrContainers.JobTemplate("example", new()
 *     {
 *         JobTemplateData = new Aws.EmrContainers.Inputs.JobTemplateJobTemplateDataArgs
 *         {
 *             ExecutionRoleArn = exampleAwsIamRole.Arn,
 *             ReleaseLabel = "emr-6.10.0-latest",
 *             JobDriver = new Aws.EmrContainers.Inputs.JobTemplateJobTemplateDataJobDriverArgs
 *             {
 *                 SparkSqlJobDriver = new Aws.EmrContainers.Inputs.JobTemplateJobTemplateDataJobDriverSparkSqlJobDriverArgs
 *                 {
 *                     EntryPoint = "default",
 *                 },
 *             },
 *         },
 *         Name = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/emrcontainers"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := emrcontainers.NewJobTemplate(ctx, "example", &emrcontainers.JobTemplateArgs{
 * 			JobTemplateData: &emrcontainers.JobTemplateJobTemplateDataArgs{
 * 				ExecutionRoleArn: pulumi.Any(exampleAwsIamRole.Arn),
 * 				ReleaseLabel:     pulumi.String("emr-6.10.0-latest"),
 * 				JobDriver: &emrcontainers.JobTemplateJobTemplateDataJobDriverArgs{
 * 					SparkSqlJobDriver: &emrcontainers.JobTemplateJobTemplateDataJobDriverSparkSqlJobDriverArgs{
 * 						EntryPoint: pulumi.String("default"),
 * 					},
 * 				},
 * 			},
 * 			Name: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emrcontainers.JobTemplate;
 * import com.pulumi.aws.emrcontainers.JobTemplateArgs;
 * import com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataArgs;
 * import com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataJobDriverArgs;
 * import com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataJobDriverSparkSqlJobDriverArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new JobTemplate("example", JobTemplateArgs.builder()
 *             .jobTemplateData(JobTemplateJobTemplateDataArgs.builder()
 *                 .executionRoleArn(exampleAwsIamRole.arn())
 *                 .releaseLabel("emr-6.10.0-latest")
 *                 .jobDriver(JobTemplateJobTemplateDataJobDriverArgs.builder()
 *                     .sparkSqlJobDriver(JobTemplateJobTemplateDataJobDriverSparkSqlJobDriverArgs.builder()
 *                         .entryPoint("default")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .name("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:emrcontainers:JobTemplate
 *     properties:
 *       jobTemplateData:
 *         executionRoleArn: ${exampleAwsIamRole.arn}
 *         releaseLabel: emr-6.10.0-latest
 *         jobDriver:
 *           sparkSqlJobDriver:
 *             entryPoint: default
 *       name: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EKS job templates using the `id`. For example:
 * ```sh
 * $ pulumi import aws:emrcontainers/jobTemplate:JobTemplate example a1b2c3d4e5f6g7h8i9j10k11l
 * ```
 */
public class JobTemplate internal constructor(
    override val javaResource: com.pulumi.aws.emrcontainers.JobTemplate,
) : KotlinCustomResource(javaResource, JobTemplateMapper) {
    /**
     * ARN of the job template.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The job template data which holds values of StartJobRun API request.
     */
    public val jobTemplateData: Output<JobTemplateJobTemplateData>
        get() = javaResource.jobTemplateData().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * The KMS key ARN used to encrypt the job template.
     */
    public val kmsKeyArn: Output<String>?
        get() = javaResource.kmsKeyArn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The specified name of the job template.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object JobTemplateMapper : ResourceMapper<JobTemplate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.emrcontainers.JobTemplate::class == javaResource::class

    override fun map(javaResource: Resource): JobTemplate = JobTemplate(
        javaResource as
            com.pulumi.aws.emrcontainers.JobTemplate,
    )
}

/**
 * @see [JobTemplate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [JobTemplate].
 */
public suspend fun jobTemplate(name: String, block: suspend JobTemplateResourceBuilder.() -> Unit): JobTemplate {
    val builder = JobTemplateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [JobTemplate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun jobTemplate(name: String): JobTemplate {
    val builder = JobTemplateResourceBuilder()
    builder.name(name)
    return builder.build()
}
