@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrcontainers.kotlin

import com.pulumi.aws.emrcontainers.JobTemplateArgs.builder
import com.pulumi.aws.emrcontainers.kotlin.inputs.JobTemplateJobTemplateDataArgs
import com.pulumi.aws.emrcontainers.kotlin.inputs.JobTemplateJobTemplateDataArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an EMR Containers (EMR on EKS) Job Template.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.emrcontainers.JobTemplate("example", {
 *     jobTemplateData: {
 *         executionRoleArn: exampleAwsIamRole.arn,
 *         releaseLabel: "emr-6.10.0-latest",
 *         jobDriver: {
 *             sparkSqlJobDriver: {
 *                 entryPoint: "default",
 *             },
 *         },
 *     },
 *     name: "example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.emrcontainers.JobTemplate("example",
 *     job_template_data={
 *         "execution_role_arn": example_aws_iam_role["arn"],
 *         "release_label": "emr-6.10.0-latest",
 *         "job_driver": {
 *             "spark_sql_job_driver": {
 *                 "entry_point": "default",
 *             },
 *         },
 *     },
 *     name="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.EmrContainers.JobTemplate("example", new()
 *     {
 *         JobTemplateData = new Aws.EmrContainers.Inputs.JobTemplateJobTemplateDataArgs
 *         {
 *             ExecutionRoleArn = exampleAwsIamRole.Arn,
 *             ReleaseLabel = "emr-6.10.0-latest",
 *             JobDriver = new Aws.EmrContainers.Inputs.JobTemplateJobTemplateDataJobDriverArgs
 *             {
 *                 SparkSqlJobDriver = new Aws.EmrContainers.Inputs.JobTemplateJobTemplateDataJobDriverSparkSqlJobDriverArgs
 *                 {
 *                     EntryPoint = "default",
 *                 },
 *             },
 *         },
 *         Name = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/emrcontainers"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := emrcontainers.NewJobTemplate(ctx, "example", &emrcontainers.JobTemplateArgs{
 * 			JobTemplateData: &emrcontainers.JobTemplateJobTemplateDataArgs{
 * 				ExecutionRoleArn: pulumi.Any(exampleAwsIamRole.Arn),
 * 				ReleaseLabel:     pulumi.String("emr-6.10.0-latest"),
 * 				JobDriver: &emrcontainers.JobTemplateJobTemplateDataJobDriverArgs{
 * 					SparkSqlJobDriver: &emrcontainers.JobTemplateJobTemplateDataJobDriverSparkSqlJobDriverArgs{
 * 						EntryPoint: pulumi.String("default"),
 * 					},
 * 				},
 * 			},
 * 			Name: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emrcontainers.JobTemplate;
 * import com.pulumi.aws.emrcontainers.JobTemplateArgs;
 * import com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataArgs;
 * import com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataJobDriverArgs;
 * import com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataJobDriverSparkSqlJobDriverArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new JobTemplate("example", JobTemplateArgs.builder()
 *             .jobTemplateData(JobTemplateJobTemplateDataArgs.builder()
 *                 .executionRoleArn(exampleAwsIamRole.arn())
 *                 .releaseLabel("emr-6.10.0-latest")
 *                 .jobDriver(JobTemplateJobTemplateDataJobDriverArgs.builder()
 *                     .sparkSqlJobDriver(JobTemplateJobTemplateDataJobDriverSparkSqlJobDriverArgs.builder()
 *                         .entryPoint("default")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .name("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:emrcontainers:JobTemplate
 *     properties:
 *       jobTemplateData:
 *         executionRoleArn: ${exampleAwsIamRole.arn}
 *         releaseLabel: emr-6.10.0-latest
 *         jobDriver:
 *           sparkSqlJobDriver:
 *             entryPoint: default
 *       name: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EKS job templates using the `id`. For example:
 * ```sh
 * $ pulumi import aws:emrcontainers/jobTemplate:JobTemplate example a1b2c3d4e5f6g7h8i9j10k11l
 * ```
 * @property jobTemplateData The job template data which holds values of StartJobRun API request.
 * @property kmsKeyArn The KMS key ARN used to encrypt the job template.
 * @property name The specified name of the job template.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class JobTemplateArgs(
    public val jobTemplateData: Output<JobTemplateJobTemplateDataArgs>? = null,
    public val kmsKeyArn: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.emrcontainers.JobTemplateArgs> {
    override fun toJava(): com.pulumi.aws.emrcontainers.JobTemplateArgs =
        com.pulumi.aws.emrcontainers.JobTemplateArgs.builder()
            .jobTemplateData(jobTemplateData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kmsKeyArn(kmsKeyArn?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [JobTemplateArgs].
 */
@PulumiTagMarker
public class JobTemplateArgsBuilder internal constructor() {
    private var jobTemplateData: Output<JobTemplateJobTemplateDataArgs>? = null

    private var kmsKeyArn: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The job template data which holds values of StartJobRun API request.
     */
    @JvmName("itbfcgtpijhedoyy")
    public suspend fun jobTemplateData(`value`: Output<JobTemplateJobTemplateDataArgs>) {
        this.jobTemplateData = value
    }

    /**
     * @param value The KMS key ARN used to encrypt the job template.
     */
    @JvmName("xojpiofkjwjuutca")
    public suspend fun kmsKeyArn(`value`: Output<String>) {
        this.kmsKeyArn = value
    }

    /**
     * @param value The specified name of the job template.
     */
    @JvmName("mbflcqaiieifmjht")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("irtnhpmfnpcijbmu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The job template data which holds values of StartJobRun API request.
     */
    @JvmName("chdevlnllrowsama")
    public suspend fun jobTemplateData(`value`: JobTemplateJobTemplateDataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobTemplateData = mapped
    }

    /**
     * @param argument The job template data which holds values of StartJobRun API request.
     */
    @JvmName("diwvvchpltuaxlkj")
    public suspend fun jobTemplateData(argument: suspend JobTemplateJobTemplateDataArgsBuilder.() -> Unit) {
        val toBeMapped = JobTemplateJobTemplateDataArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.jobTemplateData = mapped
    }

    /**
     * @param value The KMS key ARN used to encrypt the job template.
     */
    @JvmName("paltcvpetmpvotxl")
    public suspend fun kmsKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyArn = mapped
    }

    /**
     * @param value The specified name of the job template.
     */
    @JvmName("vticytqopncfsrol")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lftvajcdgeecaguc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rlsxorquxlubgcqd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): JobTemplateArgs = JobTemplateArgs(
        jobTemplateData = jobTemplateData,
        kmsKeyArn = kmsKeyArn,
        name = name,
        tags = tags,
    )
}
