@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrcontainers.kotlin

import com.pulumi.aws.emrcontainers.kotlin.outputs.VirtualClusterContainerProvider
import com.pulumi.aws.emrcontainers.kotlin.outputs.VirtualClusterContainerProvider.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [VirtualCluster].
 */
@PulumiTagMarker
public class VirtualClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualClusterArgs = VirtualClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualClusterArgsBuilder.() -> Unit) {
        val builder = VirtualClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VirtualCluster {
        val builtJavaResource = com.pulumi.aws.emrcontainers.VirtualCluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VirtualCluster(builtJavaResource)
    }
}

/**
 * Manages an EMR Containers (EMR on EKS) Virtual Cluster.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.emrcontainers.VirtualCluster("example", {
 *     containerProvider: {
 *         id: exampleAwsEksCluster.name,
 *         type: "EKS",
 *         info: {
 *             eksInfo: {
 *                 namespace: "default",
 *             },
 *         },
 *     },
 *     name: "example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.emrcontainers.VirtualCluster("example",
 *     container_provider={
 *         "id": example_aws_eks_cluster["name"],
 *         "type": "EKS",
 *         "info": {
 *             "eks_info": {
 *                 "namespace": "default",
 *             },
 *         },
 *     },
 *     name="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.EmrContainers.VirtualCluster("example", new()
 *     {
 *         ContainerProvider = new Aws.EmrContainers.Inputs.VirtualClusterContainerProviderArgs
 *         {
 *             Id = exampleAwsEksCluster.Name,
 *             Type = "EKS",
 *             Info = new Aws.EmrContainers.Inputs.VirtualClusterContainerProviderInfoArgs
 *             {
 *                 EksInfo = new Aws.EmrContainers.Inputs.VirtualClusterContainerProviderInfoEksInfoArgs
 *                 {
 *                     Namespace = "default",
 *                 },
 *             },
 *         },
 *         Name = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/emrcontainers"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := emrcontainers.NewVirtualCluster(ctx, "example", &emrcontainers.VirtualClusterArgs{
 * 			ContainerProvider: &emrcontainers.VirtualClusterContainerProviderArgs{
 * 				Id:   pulumi.Any(exampleAwsEksCluster.Name),
 * 				Type: pulumi.String("EKS"),
 * 				Info: &emrcontainers.VirtualClusterContainerProviderInfoArgs{
 * 					EksInfo: &emrcontainers.VirtualClusterContainerProviderInfoEksInfoArgs{
 * 						Namespace: pulumi.String("default"),
 * 					},
 * 				},
 * 			},
 * 			Name: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emrcontainers.VirtualCluster;
 * import com.pulumi.aws.emrcontainers.VirtualClusterArgs;
 * import com.pulumi.aws.emrcontainers.inputs.VirtualClusterContainerProviderArgs;
 * import com.pulumi.aws.emrcontainers.inputs.VirtualClusterContainerProviderInfoArgs;
 * import com.pulumi.aws.emrcontainers.inputs.VirtualClusterContainerProviderInfoEksInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VirtualCluster("example", VirtualClusterArgs.builder()
 *             .containerProvider(VirtualClusterContainerProviderArgs.builder()
 *                 .id(exampleAwsEksCluster.name())
 *                 .type("EKS")
 *                 .info(VirtualClusterContainerProviderInfoArgs.builder()
 *                     .eksInfo(VirtualClusterContainerProviderInfoEksInfoArgs.builder()
 *                         .namespace("default")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .name("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:emrcontainers:VirtualCluster
 *     properties:
 *       containerProvider:
 *         id: ${exampleAwsEksCluster.name}
 *         type: EKS
 *         info:
 *           eksInfo:
 *             namespace: default
 *       name: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EKS Clusters using the `id`. For example:
 * ```sh
 * $ pulumi import aws:emrcontainers/virtualCluster:VirtualCluster example a1b2c3d4e5f6g7h8i9j10k11l
 * ```
 */
public class VirtualCluster internal constructor(
    override val javaResource: com.pulumi.aws.emrcontainers.VirtualCluster,
) : KotlinCustomResource(javaResource, VirtualClusterMapper) {
    /**
     * ARN of the cluster.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Configuration block for the container provider associated with your cluster.
     */
    public val containerProvider: Output<VirtualClusterContainerProvider>
        get() = javaResource.containerProvider().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * Name of the virtual cluster.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object VirtualClusterMapper : ResourceMapper<VirtualCluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.emrcontainers.VirtualCluster::class == javaResource::class

    override fun map(javaResource: Resource): VirtualCluster = VirtualCluster(
        javaResource as
            com.pulumi.aws.emrcontainers.VirtualCluster,
    )
}

/**
 * @see [VirtualCluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualCluster].
 */
public suspend fun virtualCluster(
    name: String,
    block: suspend VirtualClusterResourceBuilder.() -> Unit,
): VirtualCluster {
    val builder = VirtualClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualCluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualCluster(name: String): VirtualCluster {
    val builder = VirtualClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
