@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrcontainers.kotlin.inputs

import com.pulumi.aws.emrcontainers.inputs.GetVirtualClusterPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVirtualCluster.
 * @property tags Key-value mapping of resource tags.
 * @property virtualClusterId ID of the cluster.
 */
public data class GetVirtualClusterPlainArgs(
    public val tags: Map<String, String>? = null,
    public val virtualClusterId: String,
) : ConvertibleToJava<com.pulumi.aws.emrcontainers.inputs.GetVirtualClusterPlainArgs> {
    override fun toJava(): com.pulumi.aws.emrcontainers.inputs.GetVirtualClusterPlainArgs =
        com.pulumi.aws.emrcontainers.inputs.GetVirtualClusterPlainArgs.builder()
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .virtualClusterId(virtualClusterId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualClusterPlainArgs].
 */
@PulumiTagMarker
public class GetVirtualClusterPlainArgsBuilder internal constructor() {
    private var tags: Map<String, String>? = null

    private var virtualClusterId: String? = null

    /**
     * @param value Key-value mapping of resource tags.
     */
    @JvmName("svwmrlyckmqoclmd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags.
     */
    @JvmName("fklgydlbpxhauudd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value ID of the cluster.
     */
    @JvmName("mdirtoxbpnmeamit")
    public suspend fun virtualClusterId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualClusterId = mapped
    }

    internal fun build(): GetVirtualClusterPlainArgs = GetVirtualClusterPlainArgs(
        tags = tags,
        virtualClusterId = virtualClusterId ?: throw PulumiNullFieldException("virtualClusterId"),
    )
}
