@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrcontainers.kotlin.inputs

import com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property classification The classification within a configuration.
 * @property configurations A list of additional configurations to apply within a configuration object.
 * @property properties A set of properties specified within a configuration classification.
 */
public data class JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationArgs(
    public val classification: Output<String>,
    public val configurations: Output<List<JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationConfigurationArgs>>? =
        null,
    public val properties: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationArgs =
        com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationArgs.builder()
            .classification(classification.applyValue({ args0 -> args0 }))
            .configurations(
                configurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationArgs].
 */
@PulumiTagMarker
public class JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationArgsBuilder
internal constructor() {
    private var classification: Output<String>? = null

    private var configurations:
        Output<List<JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationConfigurationArgs>>? =
        null

    private var properties: Output<Map<String, String>>? = null

    /**
     * @param value The classification within a configuration.
     */
    @JvmName("qlpxoyypeiyedffy")
    public suspend fun classification(`value`: Output<String>) {
        this.classification = value
    }

    /**
     * @param value A list of additional configurations to apply within a configuration object.
     */
    @JvmName("jfmwfiktymiaksql")
    public suspend fun configurations(`value`: Output<List<JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationConfigurationArgs>>) {
        this.configurations = value
    }

    @JvmName("fokrusgrashgrrmi")
    public suspend fun configurations(vararg values: Output<JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationConfigurationArgs>) {
        this.configurations = Output.all(values.asList())
    }

    /**
     * @param values A list of additional configurations to apply within a configuration object.
     */
    @JvmName("saykcvyuyfgitxuh")
    public suspend fun configurations(values: List<Output<JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationConfigurationArgs>>) {
        this.configurations = Output.all(values)
    }

    /**
     * @param value A set of properties specified within a configuration classification.
     */
    @JvmName("fmonttcorjfyhphl")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value The classification within a configuration.
     */
    @JvmName("mfbandywkqrmbsse")
    public suspend fun classification(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.classification = mapped
    }

    /**
     * @param value A list of additional configurations to apply within a configuration object.
     */
    @JvmName("kkohtraburysgvww")
    public suspend fun configurations(`value`: List<JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurations = mapped
    }

    /**
     * @param argument A list of additional configurations to apply within a configuration object.
     */
    @JvmName("menhwbiflgcoitay")
    public suspend fun configurations(argument: List<suspend JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param argument A list of additional configurations to apply within a configuration object.
     */
    @JvmName("thqumxxxdxxhwpns")
    public suspend fun configurations(vararg argument: suspend JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param argument A list of additional configurations to apply within a configuration object.
     */
    @JvmName("ehlskmemuyvpekgt")
    public suspend fun configurations(argument: suspend JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationConfigurationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param values A list of additional configurations to apply within a configuration object.
     */
    @JvmName("grwpkgsejmtakydc")
    public suspend fun configurations(vararg values: JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurations = mapped
    }

    /**
     * @param value A set of properties specified within a configuration classification.
     */
    @JvmName("cxhtqfdlijcqsduy")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values A set of properties specified within a configuration classification.
     */
    @JvmName("dknubtsjlmfjenkm")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    internal fun build(): JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationArgs = JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationArgs(
        classification = classification ?: throw PulumiNullFieldException("classification"),
        configurations = configurations,
        properties = properties,
    )
}
