@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrcontainers.kotlin.inputs

import com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property classification The classification within a configuration.
 * @property properties A set of properties specified within a configuration classification.
 */
public data class
JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationConfigurationArgs(
    public val classification: Output<String>? = null,
    public val properties: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationConfigurationArgs =
        com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationConfigurationArgs.builder()
            .classification(classification?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationConfigurationArgs].
 */
@PulumiTagMarker
public class
JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationConfigurationArgsBuilder
internal constructor() {
    private var classification: Output<String>? = null

    private var properties: Output<Map<String, String>>? = null

    /**
     * @param value The classification within a configuration.
     */
    @JvmName("kevouaadblutbufy")
    public suspend fun classification(`value`: Output<String>) {
        this.classification = value
    }

    /**
     * @param value A set of properties specified within a configuration classification.
     */
    @JvmName("xempqrkinidpwtwd")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value The classification within a configuration.
     */
    @JvmName("rdynvitkqppynffp")
    public suspend fun classification(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.classification = mapped
    }

    /**
     * @param value A set of properties specified within a configuration classification.
     */
    @JvmName("dfrhocwnmbfjahyc")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values A set of properties specified within a configuration classification.
     */
    @JvmName("jmswjgjxndbxlpba")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    internal fun build(): JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationConfigurationArgs =
        JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationConfigurationArgs(
            classification = classification,
            properties = properties,
        )
}
