@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrcontainers.kotlin.inputs

import com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationCloudWatchMonitoringConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property logGroupName The name of the log group for log publishing.
 * @property logStreamNamePrefix The specified name prefix for log streams.
 */
public data class
JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationCloudWatchMonitoringConfigurationArgs(
    public val logGroupName: Output<String>,
    public val logStreamNamePrefix: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationCloudWatchMonitoringConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationCloudWatchMonitoringConfigurationArgs =
        com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationCloudWatchMonitoringConfigurationArgs.builder()
            .logGroupName(logGroupName.applyValue({ args0 -> args0 }))
            .logStreamNamePrefix(logStreamNamePrefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationCloudWatchMonitoringConfigurationArgs].
 */
@PulumiTagMarker
public class
JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationCloudWatchMonitoringConfigurationArgsBuilder
internal constructor() {
    private var logGroupName: Output<String>? = null

    private var logStreamNamePrefix: Output<String>? = null

    /**
     * @param value The name of the log group for log publishing.
     */
    @JvmName("fidssenwatsepsaw")
    public suspend fun logGroupName(`value`: Output<String>) {
        this.logGroupName = value
    }

    /**
     * @param value The specified name prefix for log streams.
     */
    @JvmName("nokbwoqdllcdcvsy")
    public suspend fun logStreamNamePrefix(`value`: Output<String>) {
        this.logStreamNamePrefix = value
    }

    /**
     * @param value The name of the log group for log publishing.
     */
    @JvmName("rbonoqwuwgbjadsq")
    public suspend fun logGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logGroupName = mapped
    }

    /**
     * @param value The specified name prefix for log streams.
     */
    @JvmName("xliqybgciqxjdfaq")
    public suspend fun logStreamNamePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logStreamNamePrefix = mapped
    }

    internal fun build(): JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationCloudWatchMonitoringConfigurationArgs =
        JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationCloudWatchMonitoringConfigurationArgs(
            logGroupName = logGroupName ?: throw PulumiNullFieldException("logGroupName"),
            logStreamNamePrefix = logStreamNamePrefix,
        )
}
