@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrcontainers.kotlin.inputs

import com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataJobDriverArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property sparkSqlJobDriver The job driver for job type.
 * @property sparkSubmitJobDriver The job driver parameters specified for spark submit.
 */
public data class JobTemplateJobTemplateDataJobDriverArgs(
    public val sparkSqlJobDriver: Output<JobTemplateJobTemplateDataJobDriverSparkSqlJobDriverArgs>? =
        null,
    public val sparkSubmitJobDriver: Output<JobTemplateJobTemplateDataJobDriverSparkSubmitJobDriverArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataJobDriverArgs> {
    override fun toJava(): com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataJobDriverArgs = com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataJobDriverArgs.builder()
        .sparkSqlJobDriver(sparkSqlJobDriver?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .sparkSubmitJobDriver(
            sparkSubmitJobDriver?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        ).build()
}

/**
 * Builder for [JobTemplateJobTemplateDataJobDriverArgs].
 */
@PulumiTagMarker
public class JobTemplateJobTemplateDataJobDriverArgsBuilder internal constructor() {
    private var sparkSqlJobDriver: Output<JobTemplateJobTemplateDataJobDriverSparkSqlJobDriverArgs>? =
        null

    private var sparkSubmitJobDriver:
        Output<JobTemplateJobTemplateDataJobDriverSparkSubmitJobDriverArgs>? = null

    /**
     * @param value The job driver for job type.
     */
    @JvmName("tkrivychmpjfrgef")
    public suspend fun sparkSqlJobDriver(`value`: Output<JobTemplateJobTemplateDataJobDriverSparkSqlJobDriverArgs>) {
        this.sparkSqlJobDriver = value
    }

    /**
     * @param value The job driver parameters specified for spark submit.
     */
    @JvmName("tvkexnvookymmqrd")
    public suspend fun sparkSubmitJobDriver(`value`: Output<JobTemplateJobTemplateDataJobDriverSparkSubmitJobDriverArgs>) {
        this.sparkSubmitJobDriver = value
    }

    /**
     * @param value The job driver for job type.
     */
    @JvmName("endtrgjbuagmhevf")
    public suspend fun sparkSqlJobDriver(`value`: JobTemplateJobTemplateDataJobDriverSparkSqlJobDriverArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sparkSqlJobDriver = mapped
    }

    /**
     * @param argument The job driver for job type.
     */
    @JvmName("rvppqklcotdmxpvb")
    public suspend fun sparkSqlJobDriver(argument: suspend JobTemplateJobTemplateDataJobDriverSparkSqlJobDriverArgsBuilder.() -> Unit) {
        val toBeMapped = JobTemplateJobTemplateDataJobDriverSparkSqlJobDriverArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sparkSqlJobDriver = mapped
    }

    /**
     * @param value The job driver parameters specified for spark submit.
     */
    @JvmName("rkhfjwvokhtrblph")
    public suspend fun sparkSubmitJobDriver(`value`: JobTemplateJobTemplateDataJobDriverSparkSubmitJobDriverArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sparkSubmitJobDriver = mapped
    }

    /**
     * @param argument The job driver parameters specified for spark submit.
     */
    @JvmName("prmvkxfrlrldhfcs")
    public suspend fun sparkSubmitJobDriver(argument: suspend JobTemplateJobTemplateDataJobDriverSparkSubmitJobDriverArgsBuilder.() -> Unit) {
        val toBeMapped =
            JobTemplateJobTemplateDataJobDriverSparkSubmitJobDriverArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.sparkSubmitJobDriver = mapped
    }

    internal fun build(): JobTemplateJobTemplateDataJobDriverArgs =
        JobTemplateJobTemplateDataJobDriverArgs(
            sparkSqlJobDriver = sparkSqlJobDriver,
            sparkSubmitJobDriver = sparkSubmitJobDriver,
        )
}
