@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrcontainers.kotlin.inputs

import com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataJobDriverSparkSubmitJobDriverArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property entryPoint The entry point of job application.
 * @property entryPointArguments The arguments for job application.
 * @property sparkSubmitParameters The Spark submit parameters that are used for job runs.
 */
public data class JobTemplateJobTemplateDataJobDriverSparkSubmitJobDriverArgs(
    public val entryPoint: Output<String>,
    public val entryPointArguments: Output<List<String>>? = null,
    public val sparkSubmitParameters: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataJobDriverSparkSubmitJobDriverArgs> {
    override fun toJava(): com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataJobDriverSparkSubmitJobDriverArgs =
        com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataJobDriverSparkSubmitJobDriverArgs.builder()
            .entryPoint(entryPoint.applyValue({ args0 -> args0 }))
            .entryPointArguments(entryPointArguments?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sparkSubmitParameters(sparkSubmitParameters?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobTemplateJobTemplateDataJobDriverSparkSubmitJobDriverArgs].
 */
@PulumiTagMarker
public class JobTemplateJobTemplateDataJobDriverSparkSubmitJobDriverArgsBuilder internal constructor() {
    private var entryPoint: Output<String>? = null

    private var entryPointArguments: Output<List<String>>? = null

    private var sparkSubmitParameters: Output<String>? = null

    /**
     * @param value The entry point of job application.
     */
    @JvmName("fcuybbvdtvlttifn")
    public suspend fun entryPoint(`value`: Output<String>) {
        this.entryPoint = value
    }

    /**
     * @param value The arguments for job application.
     */
    @JvmName("ssiwbilywivjmles")
    public suspend fun entryPointArguments(`value`: Output<List<String>>) {
        this.entryPointArguments = value
    }

    @JvmName("bxyshktrcycukkmq")
    public suspend fun entryPointArguments(vararg values: Output<String>) {
        this.entryPointArguments = Output.all(values.asList())
    }

    /**
     * @param values The arguments for job application.
     */
    @JvmName("fkusniwvfvhhqkbc")
    public suspend fun entryPointArguments(values: List<Output<String>>) {
        this.entryPointArguments = Output.all(values)
    }

    /**
     * @param value The Spark submit parameters that are used for job runs.
     */
    @JvmName("kyyvhqsvxiuroehb")
    public suspend fun sparkSubmitParameters(`value`: Output<String>) {
        this.sparkSubmitParameters = value
    }

    /**
     * @param value The entry point of job application.
     */
    @JvmName("avevlvypltmlavxl")
    public suspend fun entryPoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.entryPoint = mapped
    }

    /**
     * @param value The arguments for job application.
     */
    @JvmName("hikytvckvhcehmgk")
    public suspend fun entryPointArguments(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entryPointArguments = mapped
    }

    /**
     * @param values The arguments for job application.
     */
    @JvmName("rbgklnmyjbidwavc")
    public suspend fun entryPointArguments(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.entryPointArguments = mapped
    }

    /**
     * @param value The Spark submit parameters that are used for job runs.
     */
    @JvmName("fgueqxuodtttoqdd")
    public suspend fun sparkSubmitParameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sparkSubmitParameters = mapped
    }

    internal fun build(): JobTemplateJobTemplateDataJobDriverSparkSubmitJobDriverArgs =
        JobTemplateJobTemplateDataJobDriverSparkSubmitJobDriverArgs(
            entryPoint = entryPoint ?: throw PulumiNullFieldException("entryPoint"),
            entryPointArguments = entryPointArguments,
            sparkSubmitParameters = sparkSubmitParameters,
        )
}
