@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrcontainers.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property classification The classification within a configuration.
 * @property configurations A list of additional configurations to apply within a configuration object.
 * @property properties A set of properties specified within a configuration classification.
 */
public data class JobTemplateJobTemplateDataConfigurationOverridesApplicationConfiguration(
    public val classification: String,
    public val configurations: List<JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationConfiguration>? =
        null,
    public val properties: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.emrcontainers.outputs.JobTemplateJobTemplateDataConfigurationOverridesApplicationConfiguration): JobTemplateJobTemplateDataConfigurationOverridesApplicationConfiguration =
            JobTemplateJobTemplateDataConfigurationOverridesApplicationConfiguration(
                classification = javaType.classification(),
                configurations = javaType.configurations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.emrcontainers.kotlin.outputs.JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationConfiguration.Companion.toKotlin(args0)
                    })
                }),
                properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            )
    }
}
