@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrcontainers.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property entryPoint The entry point of job application.
 * @property entryPointArguments The arguments for job application.
 * @property sparkSubmitParameters The Spark submit parameters that are used for job runs.
 */
public data class JobTemplateJobTemplateDataJobDriverSparkSubmitJobDriver(
    public val entryPoint: String,
    public val entryPointArguments: List<String>? = null,
    public val sparkSubmitParameters: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.emrcontainers.outputs.JobTemplateJobTemplateDataJobDriverSparkSubmitJobDriver): JobTemplateJobTemplateDataJobDriverSparkSubmitJobDriver =
            JobTemplateJobTemplateDataJobDriverSparkSubmitJobDriver(
                entryPoint = javaType.entryPoint(),
                entryPointArguments = javaType.entryPointArguments().map({ args0 -> args0 }),
                sparkSubmitParameters = javaType.sparkSubmitParameters().map({ args0 -> args0 }).orElse(null),
            )
    }
}
