@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrserverless.kotlin

import com.pulumi.aws.emrserverless.kotlin.outputs.ApplicationAutoStartConfiguration
import com.pulumi.aws.emrserverless.kotlin.outputs.ApplicationAutoStopConfiguration
import com.pulumi.aws.emrserverless.kotlin.outputs.ApplicationImageConfiguration
import com.pulumi.aws.emrserverless.kotlin.outputs.ApplicationInitialCapacity
import com.pulumi.aws.emrserverless.kotlin.outputs.ApplicationInteractiveConfiguration
import com.pulumi.aws.emrserverless.kotlin.outputs.ApplicationMaximumCapacity
import com.pulumi.aws.emrserverless.kotlin.outputs.ApplicationNetworkConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.emrserverless.kotlin.outputs.ApplicationAutoStartConfiguration.Companion.toKotlin as applicationAutoStartConfigurationToKotlin
import com.pulumi.aws.emrserverless.kotlin.outputs.ApplicationAutoStopConfiguration.Companion.toKotlin as applicationAutoStopConfigurationToKotlin
import com.pulumi.aws.emrserverless.kotlin.outputs.ApplicationImageConfiguration.Companion.toKotlin as applicationImageConfigurationToKotlin
import com.pulumi.aws.emrserverless.kotlin.outputs.ApplicationInitialCapacity.Companion.toKotlin as applicationInitialCapacityToKotlin
import com.pulumi.aws.emrserverless.kotlin.outputs.ApplicationInteractiveConfiguration.Companion.toKotlin as applicationInteractiveConfigurationToKotlin
import com.pulumi.aws.emrserverless.kotlin.outputs.ApplicationMaximumCapacity.Companion.toKotlin as applicationMaximumCapacityToKotlin
import com.pulumi.aws.emrserverless.kotlin.outputs.ApplicationNetworkConfiguration.Companion.toKotlin as applicationNetworkConfigurationToKotlin

/**
 * Builder for [Application].
 */
@PulumiTagMarker
public class ApplicationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplicationArgs = ApplicationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApplicationArgsBuilder.() -> Unit) {
        val builder = ApplicationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Application {
        val builtJavaResource = com.pulumi.aws.emrserverless.Application(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Application(builtJavaResource)
    }
}

/**
 * Manages an EMR Serverless Application.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.emrserverless.Application("example", {
 *     name: "example",
 *     releaseLabel: "emr-6.6.0",
 *     type: "hive",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.emrserverless.Application("example",
 *     name="example",
 *     release_label="emr-6.6.0",
 *     type="hive")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.EmrServerless.Application("example", new()
 *     {
 *         Name = "example",
 *         ReleaseLabel = "emr-6.6.0",
 *         Type = "hive",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/emrserverless"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := emrserverless.NewApplication(ctx, "example", &emrserverless.ApplicationArgs{
 * 			Name:         pulumi.String("example"),
 * 			ReleaseLabel: pulumi.String("emr-6.6.0"),
 * 			Type:         pulumi.String("hive"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emrserverless.Application;
 * import com.pulumi.aws.emrserverless.ApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Application("example", ApplicationArgs.builder()
 *             .name("example")
 *             .releaseLabel("emr-6.6.0")
 *             .type("hive")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:emrserverless:Application
 *     properties:
 *       name: example
 *       releaseLabel: emr-6.6.0
 *       type: hive
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Initial Capacity Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.emrserverless.Application("example", {
 *     name: "example",
 *     releaseLabel: "emr-6.6.0",
 *     type: "hive",
 *     initialCapacities: [{
 *         initialCapacityType: "HiveDriver",
 *         initialCapacityConfig: {
 *             workerCount: 1,
 *             workerConfiguration: {
 *                 cpu: "2 vCPU",
 *                 memory: "10 GB",
 *             },
 *         },
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.emrserverless.Application("example",
 *     name="example",
 *     release_label="emr-6.6.0",
 *     type="hive",
 *     initial_capacities=[{
 *         "initial_capacity_type": "HiveDriver",
 *         "initial_capacity_config": {
 *             "worker_count": 1,
 *             "worker_configuration": {
 *                 "cpu": "2 vCPU",
 *                 "memory": "10 GB",
 *             },
 *         },
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.EmrServerless.Application("example", new()
 *     {
 *         Name = "example",
 *         ReleaseLabel = "emr-6.6.0",
 *         Type = "hive",
 *         InitialCapacities = new[]
 *         {
 *             new Aws.EmrServerless.Inputs.ApplicationInitialCapacityArgs
 *             {
 *                 InitialCapacityType = "HiveDriver",
 *                 InitialCapacityConfig = new Aws.EmrServerless.Inputs.ApplicationInitialCapacityInitialCapacityConfigArgs
 *                 {
 *                     WorkerCount = 1,
 *                     WorkerConfiguration = new Aws.EmrServerless.Inputs.ApplicationInitialCapacityInitialCapacityConfigWorkerConfigurationArgs
 *                     {
 *                         Cpu = "2 vCPU",
 *                         Memory = "10 GB",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/emrserverless"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := emrserverless.NewApplication(ctx, "example", &emrserverless.ApplicationArgs{
 * 			Name:         pulumi.String("example"),
 * 			ReleaseLabel: pulumi.String("emr-6.6.0"),
 * 			Type:         pulumi.String("hive"),
 * 			InitialCapacities: emrserverless.ApplicationInitialCapacityArray{
 * 				&emrserverless.ApplicationInitialCapacityArgs{
 * 					InitialCapacityType: pulumi.String("HiveDriver"),
 * 					InitialCapacityConfig: &emrserverless.ApplicationInitialCapacityInitialCapacityConfigArgs{
 * 						WorkerCount: pulumi.Int(1),
 * 						WorkerConfiguration: &emrserverless.ApplicationInitialCapacityInitialCapacityConfigWorkerConfigurationArgs{
 * 							Cpu:    pulumi.String("2 vCPU"),
 * 							Memory: pulumi.String("10 GB"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emrserverless.Application;
 * import com.pulumi.aws.emrserverless.ApplicationArgs;
 * import com.pulumi.aws.emrserverless.inputs.ApplicationInitialCapacityArgs;
 * import com.pulumi.aws.emrserverless.inputs.ApplicationInitialCapacityInitialCapacityConfigArgs;
 * import com.pulumi.aws.emrserverless.inputs.ApplicationInitialCapacityInitialCapacityConfigWorkerConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Application("example", ApplicationArgs.builder()
 *             .name("example")
 *             .releaseLabel("emr-6.6.0")
 *             .type("hive")
 *             .initialCapacities(ApplicationInitialCapacityArgs.builder()
 *                 .initialCapacityType("HiveDriver")
 *                 .initialCapacityConfig(ApplicationInitialCapacityInitialCapacityConfigArgs.builder()
 *                     .workerCount(1)
 *                     .workerConfiguration(ApplicationInitialCapacityInitialCapacityConfigWorkerConfigurationArgs.builder()
 *                         .cpu("2 vCPU")
 *                         .memory("10 GB")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:emrserverless:Application
 *     properties:
 *       name: example
 *       releaseLabel: emr-6.6.0
 *       type: hive
 *       initialCapacities:
 *         - initialCapacityType: HiveDriver
 *           initialCapacityConfig:
 *             workerCount: 1
 *             workerConfiguration:
 *               cpu: 2 vCPU
 *               memory: 10 GB
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Maximum Capacity Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.emrserverless.Application("example", {
 *     name: "example",
 *     releaseLabel: "emr-6.6.0",
 *     type: "hive",
 *     maximumCapacity: {
 *         cpu: "2 vCPU",
 *         memory: "10 GB",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.emrserverless.Application("example",
 *     name="example",
 *     release_label="emr-6.6.0",
 *     type="hive",
 *     maximum_capacity={
 *         "cpu": "2 vCPU",
 *         "memory": "10 GB",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.EmrServerless.Application("example", new()
 *     {
 *         Name = "example",
 *         ReleaseLabel = "emr-6.6.0",
 *         Type = "hive",
 *         MaximumCapacity = new Aws.EmrServerless.Inputs.ApplicationMaximumCapacityArgs
 *         {
 *             Cpu = "2 vCPU",
 *             Memory = "10 GB",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/emrserverless"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := emrserverless.NewApplication(ctx, "example", &emrserverless.ApplicationArgs{
 * 			Name:         pulumi.String("example"),
 * 			ReleaseLabel: pulumi.String("emr-6.6.0"),
 * 			Type:         pulumi.String("hive"),
 * 			MaximumCapacity: &emrserverless.ApplicationMaximumCapacityArgs{
 * 				Cpu:    pulumi.String("2 vCPU"),
 * 				Memory: pulumi.String("10 GB"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emrserverless.Application;
 * import com.pulumi.aws.emrserverless.ApplicationArgs;
 * import com.pulumi.aws.emrserverless.inputs.ApplicationMaximumCapacityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Application("example", ApplicationArgs.builder()
 *             .name("example")
 *             .releaseLabel("emr-6.6.0")
 *             .type("hive")
 *             .maximumCapacity(ApplicationMaximumCapacityArgs.builder()
 *                 .cpu("2 vCPU")
 *                 .memory("10 GB")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:emrserverless:Application
 *     properties:
 *       name: example
 *       releaseLabel: emr-6.6.0
 *       type: hive
 *       maximumCapacity:
 *         cpu: 2 vCPU
 *         memory: 10 GB
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EMR Severless applications using the `id`. For example:
 * ```sh
 * $ pulumi import aws:emrserverless/application:Application example id
 * ```
 */
public class Application internal constructor(
    override val javaResource: com.pulumi.aws.emrserverless.Application,
) : KotlinCustomResource(javaResource, ApplicationMapper) {
    /**
     * The CPU architecture of an application. Valid values are `ARM64` or `X86_64`. Default value is `X86_64`.
     */
    public val architecture: Output<String>?
        get() = javaResource.architecture().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of the cluster.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The configuration for an application to automatically start on job submission.
     */
    public val autoStartConfiguration: Output<ApplicationAutoStartConfiguration>
        get() = javaResource.autoStartConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                applicationAutoStartConfigurationToKotlin(args0)
            })
        })

    /**
     * The configuration for an application to automatically stop after a certain amount of time being idle.
     */
    public val autoStopConfiguration: Output<ApplicationAutoStopConfiguration>
        get() = javaResource.autoStopConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                applicationAutoStopConfigurationToKotlin(args0)
            })
        })

    /**
     * The image configuration applied to all worker types.
     */
    public val imageConfiguration: Output<ApplicationImageConfiguration>
        get() = javaResource.imageConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                applicationImageConfigurationToKotlin(args0)
            })
        })

    /**
     * The capacity to initialize when the application is created.
     */
    public val initialCapacities: Output<List<ApplicationInitialCapacity>>?
        get() = javaResource.initialCapacities().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        applicationInitialCapacityToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Enables the interactive use cases to use when running an application.
     */
    public val interactiveConfiguration: Output<ApplicationInteractiveConfiguration>
        get() = javaResource.interactiveConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                applicationInteractiveConfigurationToKotlin(args0)
            })
        })

    /**
     * The maximum capacity to allocate when the application is created. This is cumulative across all workers at any given point in time, not just when an application is created. No new resources will be created once any one of the defined limits is hit.
     */
    public val maximumCapacity: Output<ApplicationMaximumCapacity>
        get() = javaResource.maximumCapacity().applyValue({ args0 ->
            args0.let({ args0 ->
                applicationMaximumCapacityToKotlin(args0)
            })
        })

    /**
     * The name of the application.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The network configuration for customer VPC connectivity.
     */
    public val networkConfiguration: Output<ApplicationNetworkConfiguration>?
        get() = javaResource.networkConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> applicationNetworkConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The EMR release version associated with the application.
     */
    public val releaseLabel: Output<String>
        get() = javaResource.releaseLabel().applyValue({ args0 -> args0 })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The type of application you want to start, such as `spark` or `hive`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ApplicationMapper : ResourceMapper<Application> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.emrserverless.Application::class == javaResource::class

    override fun map(javaResource: Resource): Application = Application(
        javaResource as
            com.pulumi.aws.emrserverless.Application,
    )
}

/**
 * @see [Application].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Application].
 */
public suspend fun application(name: String, block: suspend ApplicationResourceBuilder.() -> Unit): Application {
    val builder = ApplicationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Application].
 * @param name The _unique_ name of the resulting resource.
 */
public fun application(name: String): Application {
    val builder = ApplicationResourceBuilder()
    builder.name(name)
    return builder.build()
}
