@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrserverless.kotlin

import com.pulumi.aws.emrserverless.ApplicationArgs.builder
import com.pulumi.aws.emrserverless.kotlin.inputs.ApplicationAutoStartConfigurationArgs
import com.pulumi.aws.emrserverless.kotlin.inputs.ApplicationAutoStartConfigurationArgsBuilder
import com.pulumi.aws.emrserverless.kotlin.inputs.ApplicationAutoStopConfigurationArgs
import com.pulumi.aws.emrserverless.kotlin.inputs.ApplicationAutoStopConfigurationArgsBuilder
import com.pulumi.aws.emrserverless.kotlin.inputs.ApplicationImageConfigurationArgs
import com.pulumi.aws.emrserverless.kotlin.inputs.ApplicationImageConfigurationArgsBuilder
import com.pulumi.aws.emrserverless.kotlin.inputs.ApplicationInitialCapacityArgs
import com.pulumi.aws.emrserverless.kotlin.inputs.ApplicationInitialCapacityArgsBuilder
import com.pulumi.aws.emrserverless.kotlin.inputs.ApplicationInteractiveConfigurationArgs
import com.pulumi.aws.emrserverless.kotlin.inputs.ApplicationInteractiveConfigurationArgsBuilder
import com.pulumi.aws.emrserverless.kotlin.inputs.ApplicationMaximumCapacityArgs
import com.pulumi.aws.emrserverless.kotlin.inputs.ApplicationMaximumCapacityArgsBuilder
import com.pulumi.aws.emrserverless.kotlin.inputs.ApplicationNetworkConfigurationArgs
import com.pulumi.aws.emrserverless.kotlin.inputs.ApplicationNetworkConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an EMR Serverless Application.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.emrserverless.Application("example", {
 *     name: "example",
 *     releaseLabel: "emr-6.6.0",
 *     type: "hive",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.emrserverless.Application("example",
 *     name="example",
 *     release_label="emr-6.6.0",
 *     type="hive")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.EmrServerless.Application("example", new()
 *     {
 *         Name = "example",
 *         ReleaseLabel = "emr-6.6.0",
 *         Type = "hive",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/emrserverless"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := emrserverless.NewApplication(ctx, "example", &emrserverless.ApplicationArgs{
 * 			Name:         pulumi.String("example"),
 * 			ReleaseLabel: pulumi.String("emr-6.6.0"),
 * 			Type:         pulumi.String("hive"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emrserverless.Application;
 * import com.pulumi.aws.emrserverless.ApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Application("example", ApplicationArgs.builder()
 *             .name("example")
 *             .releaseLabel("emr-6.6.0")
 *             .type("hive")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:emrserverless:Application
 *     properties:
 *       name: example
 *       releaseLabel: emr-6.6.0
 *       type: hive
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Initial Capacity Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.emrserverless.Application("example", {
 *     name: "example",
 *     releaseLabel: "emr-6.6.0",
 *     type: "hive",
 *     initialCapacities: [{
 *         initialCapacityType: "HiveDriver",
 *         initialCapacityConfig: {
 *             workerCount: 1,
 *             workerConfiguration: {
 *                 cpu: "2 vCPU",
 *                 memory: "10 GB",
 *             },
 *         },
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.emrserverless.Application("example",
 *     name="example",
 *     release_label="emr-6.6.0",
 *     type="hive",
 *     initial_capacities=[{
 *         "initial_capacity_type": "HiveDriver",
 *         "initial_capacity_config": {
 *             "worker_count": 1,
 *             "worker_configuration": {
 *                 "cpu": "2 vCPU",
 *                 "memory": "10 GB",
 *             },
 *         },
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.EmrServerless.Application("example", new()
 *     {
 *         Name = "example",
 *         ReleaseLabel = "emr-6.6.0",
 *         Type = "hive",
 *         InitialCapacities = new[]
 *         {
 *             new Aws.EmrServerless.Inputs.ApplicationInitialCapacityArgs
 *             {
 *                 InitialCapacityType = "HiveDriver",
 *                 InitialCapacityConfig = new Aws.EmrServerless.Inputs.ApplicationInitialCapacityInitialCapacityConfigArgs
 *                 {
 *                     WorkerCount = 1,
 *                     WorkerConfiguration = new Aws.EmrServerless.Inputs.ApplicationInitialCapacityInitialCapacityConfigWorkerConfigurationArgs
 *                     {
 *                         Cpu = "2 vCPU",
 *                         Memory = "10 GB",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/emrserverless"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := emrserverless.NewApplication(ctx, "example", &emrserverless.ApplicationArgs{
 * 			Name:         pulumi.String("example"),
 * 			ReleaseLabel: pulumi.String("emr-6.6.0"),
 * 			Type:         pulumi.String("hive"),
 * 			InitialCapacities: emrserverless.ApplicationInitialCapacityArray{
 * 				&emrserverless.ApplicationInitialCapacityArgs{
 * 					InitialCapacityType: pulumi.String("HiveDriver"),
 * 					InitialCapacityConfig: &emrserverless.ApplicationInitialCapacityInitialCapacityConfigArgs{
 * 						WorkerCount: pulumi.Int(1),
 * 						WorkerConfiguration: &emrserverless.ApplicationInitialCapacityInitialCapacityConfigWorkerConfigurationArgs{
 * 							Cpu:    pulumi.String("2 vCPU"),
 * 							Memory: pulumi.String("10 GB"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emrserverless.Application;
 * import com.pulumi.aws.emrserverless.ApplicationArgs;
 * import com.pulumi.aws.emrserverless.inputs.ApplicationInitialCapacityArgs;
 * import com.pulumi.aws.emrserverless.inputs.ApplicationInitialCapacityInitialCapacityConfigArgs;
 * import com.pulumi.aws.emrserverless.inputs.ApplicationInitialCapacityInitialCapacityConfigWorkerConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Application("example", ApplicationArgs.builder()
 *             .name("example")
 *             .releaseLabel("emr-6.6.0")
 *             .type("hive")
 *             .initialCapacities(ApplicationInitialCapacityArgs.builder()
 *                 .initialCapacityType("HiveDriver")
 *                 .initialCapacityConfig(ApplicationInitialCapacityInitialCapacityConfigArgs.builder()
 *                     .workerCount(1)
 *                     .workerConfiguration(ApplicationInitialCapacityInitialCapacityConfigWorkerConfigurationArgs.builder()
 *                         .cpu("2 vCPU")
 *                         .memory("10 GB")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:emrserverless:Application
 *     properties:
 *       name: example
 *       releaseLabel: emr-6.6.0
 *       type: hive
 *       initialCapacities:
 *         - initialCapacityType: HiveDriver
 *           initialCapacityConfig:
 *             workerCount: 1
 *             workerConfiguration:
 *               cpu: 2 vCPU
 *               memory: 10 GB
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Maximum Capacity Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.emrserverless.Application("example", {
 *     name: "example",
 *     releaseLabel: "emr-6.6.0",
 *     type: "hive",
 *     maximumCapacity: {
 *         cpu: "2 vCPU",
 *         memory: "10 GB",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.emrserverless.Application("example",
 *     name="example",
 *     release_label="emr-6.6.0",
 *     type="hive",
 *     maximum_capacity={
 *         "cpu": "2 vCPU",
 *         "memory": "10 GB",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.EmrServerless.Application("example", new()
 *     {
 *         Name = "example",
 *         ReleaseLabel = "emr-6.6.0",
 *         Type = "hive",
 *         MaximumCapacity = new Aws.EmrServerless.Inputs.ApplicationMaximumCapacityArgs
 *         {
 *             Cpu = "2 vCPU",
 *             Memory = "10 GB",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/emrserverless"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := emrserverless.NewApplication(ctx, "example", &emrserverless.ApplicationArgs{
 * 			Name:         pulumi.String("example"),
 * 			ReleaseLabel: pulumi.String("emr-6.6.0"),
 * 			Type:         pulumi.String("hive"),
 * 			MaximumCapacity: &emrserverless.ApplicationMaximumCapacityArgs{
 * 				Cpu:    pulumi.String("2 vCPU"),
 * 				Memory: pulumi.String("10 GB"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emrserverless.Application;
 * import com.pulumi.aws.emrserverless.ApplicationArgs;
 * import com.pulumi.aws.emrserverless.inputs.ApplicationMaximumCapacityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Application("example", ApplicationArgs.builder()
 *             .name("example")
 *             .releaseLabel("emr-6.6.0")
 *             .type("hive")
 *             .maximumCapacity(ApplicationMaximumCapacityArgs.builder()
 *                 .cpu("2 vCPU")
 *                 .memory("10 GB")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:emrserverless:Application
 *     properties:
 *       name: example
 *       releaseLabel: emr-6.6.0
 *       type: hive
 *       maximumCapacity:
 *         cpu: 2 vCPU
 *         memory: 10 GB
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EMR Severless applications using the `id`. For example:
 * ```sh
 * $ pulumi import aws:emrserverless/application:Application example id
 * ```
 * @property architecture The CPU architecture of an application. Valid values are `ARM64` or `X86_64`. Default value is `X86_64`.
 * @property autoStartConfiguration The configuration for an application to automatically start on job submission.
 * @property autoStopConfiguration The configuration for an application to automatically stop after a certain amount of time being idle.
 * @property imageConfiguration The image configuration applied to all worker types.
 * @property initialCapacities The capacity to initialize when the application is created.
 * @property interactiveConfiguration Enables the interactive use cases to use when running an application.
 * @property maximumCapacity The maximum capacity to allocate when the application is created. This is cumulative across all workers at any given point in time, not just when an application is created. No new resources will be created once any one of the defined limits is hit.
 * @property name The name of the application.
 * @property networkConfiguration The network configuration for customer VPC connectivity.
 * @property releaseLabel The EMR release version associated with the application.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property type The type of application you want to start, such as `spark` or `hive`.
 */
public data class ApplicationArgs(
    public val architecture: Output<String>? = null,
    public val autoStartConfiguration: Output<ApplicationAutoStartConfigurationArgs>? = null,
    public val autoStopConfiguration: Output<ApplicationAutoStopConfigurationArgs>? = null,
    public val imageConfiguration: Output<ApplicationImageConfigurationArgs>? = null,
    public val initialCapacities: Output<List<ApplicationInitialCapacityArgs>>? = null,
    public val interactiveConfiguration: Output<ApplicationInteractiveConfigurationArgs>? = null,
    public val maximumCapacity: Output<ApplicationMaximumCapacityArgs>? = null,
    public val name: Output<String>? = null,
    public val networkConfiguration: Output<ApplicationNetworkConfigurationArgs>? = null,
    public val releaseLabel: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.emrserverless.ApplicationArgs> {
    override fun toJava(): com.pulumi.aws.emrserverless.ApplicationArgs =
        com.pulumi.aws.emrserverless.ApplicationArgs.builder()
            .architecture(architecture?.applyValue({ args0 -> args0 }))
            .autoStartConfiguration(
                autoStartConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .autoStopConfiguration(
                autoStopConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .imageConfiguration(
                imageConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .initialCapacities(
                initialCapacities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .interactiveConfiguration(
                interactiveConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .maximumCapacity(maximumCapacity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .networkConfiguration(
                networkConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .releaseLabel(releaseLabel?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationArgs].
 */
@PulumiTagMarker
public class ApplicationArgsBuilder internal constructor() {
    private var architecture: Output<String>? = null

    private var autoStartConfiguration: Output<ApplicationAutoStartConfigurationArgs>? = null

    private var autoStopConfiguration: Output<ApplicationAutoStopConfigurationArgs>? = null

    private var imageConfiguration: Output<ApplicationImageConfigurationArgs>? = null

    private var initialCapacities: Output<List<ApplicationInitialCapacityArgs>>? = null

    private var interactiveConfiguration: Output<ApplicationInteractiveConfigurationArgs>? = null

    private var maximumCapacity: Output<ApplicationMaximumCapacityArgs>? = null

    private var name: Output<String>? = null

    private var networkConfiguration: Output<ApplicationNetworkConfigurationArgs>? = null

    private var releaseLabel: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value The CPU architecture of an application. Valid values are `ARM64` or `X86_64`. Default value is `X86_64`.
     */
    @JvmName("iuyuwvrfwhkxmbsg")
    public suspend fun architecture(`value`: Output<String>) {
        this.architecture = value
    }

    /**
     * @param value The configuration for an application to automatically start on job submission.
     */
    @JvmName("aaivnsernxxwvrrh")
    public suspend fun autoStartConfiguration(`value`: Output<ApplicationAutoStartConfigurationArgs>) {
        this.autoStartConfiguration = value
    }

    /**
     * @param value The configuration for an application to automatically stop after a certain amount of time being idle.
     */
    @JvmName("tfymcxnwowltmbil")
    public suspend fun autoStopConfiguration(`value`: Output<ApplicationAutoStopConfigurationArgs>) {
        this.autoStopConfiguration = value
    }

    /**
     * @param value The image configuration applied to all worker types.
     */
    @JvmName("cbeavnatdpmnrmkg")
    public suspend fun imageConfiguration(`value`: Output<ApplicationImageConfigurationArgs>) {
        this.imageConfiguration = value
    }

    /**
     * @param value The capacity to initialize when the application is created.
     */
    @JvmName("nirmheyjcpnndyen")
    public suspend fun initialCapacities(`value`: Output<List<ApplicationInitialCapacityArgs>>) {
        this.initialCapacities = value
    }

    @JvmName("kdbmaocsvmoolwuv")
    public suspend fun initialCapacities(vararg values: Output<ApplicationInitialCapacityArgs>) {
        this.initialCapacities = Output.all(values.asList())
    }

    /**
     * @param values The capacity to initialize when the application is created.
     */
    @JvmName("vqrhqnunopjcalra")
    public suspend fun initialCapacities(values: List<Output<ApplicationInitialCapacityArgs>>) {
        this.initialCapacities = Output.all(values)
    }

    /**
     * @param value Enables the interactive use cases to use when running an application.
     */
    @JvmName("vcnnomnpvntpslye")
    public suspend fun interactiveConfiguration(`value`: Output<ApplicationInteractiveConfigurationArgs>) {
        this.interactiveConfiguration = value
    }

    /**
     * @param value The maximum capacity to allocate when the application is created. This is cumulative across all workers at any given point in time, not just when an application is created. No new resources will be created once any one of the defined limits is hit.
     */
    @JvmName("capwhwkbhvcvclwe")
    public suspend fun maximumCapacity(`value`: Output<ApplicationMaximumCapacityArgs>) {
        this.maximumCapacity = value
    }

    /**
     * @param value The name of the application.
     */
    @JvmName("wdbsusnodmrifmvp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The network configuration for customer VPC connectivity.
     */
    @JvmName("bpxjktkrnowsyffy")
    public suspend fun networkConfiguration(`value`: Output<ApplicationNetworkConfigurationArgs>) {
        this.networkConfiguration = value
    }

    /**
     * @param value The EMR release version associated with the application.
     */
    @JvmName("bejnltjcekjrvmea")
    public suspend fun releaseLabel(`value`: Output<String>) {
        this.releaseLabel = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ldkgghmtlgbdvtqc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The type of application you want to start, such as `spark` or `hive`.
     */
    @JvmName("aqshubrsthdlqxvx")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The CPU architecture of an application. Valid values are `ARM64` or `X86_64`. Default value is `X86_64`.
     */
    @JvmName("xvmqmurugscqevom")
    public suspend fun architecture(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.architecture = mapped
    }

    /**
     * @param value The configuration for an application to automatically start on job submission.
     */
    @JvmName("cxngvfaytirletmk")
    public suspend fun autoStartConfiguration(`value`: ApplicationAutoStartConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoStartConfiguration = mapped
    }

    /**
     * @param argument The configuration for an application to automatically start on job submission.
     */
    @JvmName("qokrnyedrddqighd")
    public suspend fun autoStartConfiguration(argument: suspend ApplicationAutoStartConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationAutoStartConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.autoStartConfiguration = mapped
    }

    /**
     * @param value The configuration for an application to automatically stop after a certain amount of time being idle.
     */
    @JvmName("nsdijrurhmklpifp")
    public suspend fun autoStopConfiguration(`value`: ApplicationAutoStopConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoStopConfiguration = mapped
    }

    /**
     * @param argument The configuration for an application to automatically stop after a certain amount of time being idle.
     */
    @JvmName("xyveipeirfutwnrs")
    public suspend fun autoStopConfiguration(argument: suspend ApplicationAutoStopConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationAutoStopConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.autoStopConfiguration = mapped
    }

    /**
     * @param value The image configuration applied to all worker types.
     */
    @JvmName("vcftboyvfiiysbgq")
    public suspend fun imageConfiguration(`value`: ApplicationImageConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageConfiguration = mapped
    }

    /**
     * @param argument The image configuration applied to all worker types.
     */
    @JvmName("bkaiaromvxvdvxfl")
    public suspend fun imageConfiguration(argument: suspend ApplicationImageConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationImageConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.imageConfiguration = mapped
    }

    /**
     * @param value The capacity to initialize when the application is created.
     */
    @JvmName("fowpbltjxlmfuywk")
    public suspend fun initialCapacities(`value`: List<ApplicationInitialCapacityArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialCapacities = mapped
    }

    /**
     * @param argument The capacity to initialize when the application is created.
     */
    @JvmName("yrcpdhekmlxnheus")
    public suspend fun initialCapacities(argument: List<suspend ApplicationInitialCapacityArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationInitialCapacityArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.initialCapacities = mapped
    }

    /**
     * @param argument The capacity to initialize when the application is created.
     */
    @JvmName("swvawmckxfekljmg")
    public suspend fun initialCapacities(vararg argument: suspend ApplicationInitialCapacityArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ApplicationInitialCapacityArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.initialCapacities = mapped
    }

    /**
     * @param argument The capacity to initialize when the application is created.
     */
    @JvmName("mabdakvaouskhelo")
    public suspend fun initialCapacities(argument: suspend ApplicationInitialCapacityArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationInitialCapacityArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.initialCapacities = mapped
    }

    /**
     * @param values The capacity to initialize when the application is created.
     */
    @JvmName("ktlyttuddgbnwnpg")
    public suspend fun initialCapacities(vararg values: ApplicationInitialCapacityArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.initialCapacities = mapped
    }

    /**
     * @param value Enables the interactive use cases to use when running an application.
     */
    @JvmName("xmgldxctrxlvsaju")
    public suspend fun interactiveConfiguration(`value`: ApplicationInteractiveConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interactiveConfiguration = mapped
    }

    /**
     * @param argument Enables the interactive use cases to use when running an application.
     */
    @JvmName("anevbqgigpyjwoql")
    public suspend fun interactiveConfiguration(argument: suspend ApplicationInteractiveConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationInteractiveConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.interactiveConfiguration = mapped
    }

    /**
     * @param value The maximum capacity to allocate when the application is created. This is cumulative across all workers at any given point in time, not just when an application is created. No new resources will be created once any one of the defined limits is hit.
     */
    @JvmName("bigyvvdlpbvkqpxk")
    public suspend fun maximumCapacity(`value`: ApplicationMaximumCapacityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumCapacity = mapped
    }

    /**
     * @param argument The maximum capacity to allocate when the application is created. This is cumulative across all workers at any given point in time, not just when an application is created. No new resources will be created once any one of the defined limits is hit.
     */
    @JvmName("gvpufwfkkahdylmx")
    public suspend fun maximumCapacity(argument: suspend ApplicationMaximumCapacityArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationMaximumCapacityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.maximumCapacity = mapped
    }

    /**
     * @param value The name of the application.
     */
    @JvmName("muarjvitkyjparfh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The network configuration for customer VPC connectivity.
     */
    @JvmName("spusamoxjkpvvsva")
    public suspend fun networkConfiguration(`value`: ApplicationNetworkConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkConfiguration = mapped
    }

    /**
     * @param argument The network configuration for customer VPC connectivity.
     */
    @JvmName("logskblwuwklmqxe")
    public suspend fun networkConfiguration(argument: suspend ApplicationNetworkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationNetworkConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkConfiguration = mapped
    }

    /**
     * @param value The EMR release version associated with the application.
     */
    @JvmName("vefrecidqiyumoob")
    public suspend fun releaseLabel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.releaseLabel = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("eksnnklsfphqmxpf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wsmbivavcjhnaldf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The type of application you want to start, such as `spark` or `hive`.
     */
    @JvmName("hwmyqnwvabliqrah")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ApplicationArgs = ApplicationArgs(
        architecture = architecture,
        autoStartConfiguration = autoStartConfiguration,
        autoStopConfiguration = autoStopConfiguration,
        imageConfiguration = imageConfiguration,
        initialCapacities = initialCapacities,
        interactiveConfiguration = interactiveConfiguration,
        maximumCapacity = maximumCapacity,
        name = name,
        networkConfiguration = networkConfiguration,
        releaseLabel = releaseLabel,
        tags = tags,
        type = type,
    )
}
