@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrserverless.kotlin.inputs

import com.pulumi.aws.emrserverless.inputs.ApplicationAutoStopConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Enables the application to automatically stop after a certain amount of time being idle. Defaults to `true`.
 * @property idleTimeoutMinutes The amount of idle time in minutes after which your application will automatically stop. Defaults to `15` minutes.
 */
public data class ApplicationAutoStopConfigurationArgs(
    public val enabled: Output<Boolean>? = null,
    public val idleTimeoutMinutes: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.emrserverless.inputs.ApplicationAutoStopConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.emrserverless.inputs.ApplicationAutoStopConfigurationArgs =
        com.pulumi.aws.emrserverless.inputs.ApplicationAutoStopConfigurationArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .idleTimeoutMinutes(idleTimeoutMinutes?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationAutoStopConfigurationArgs].
 */
@PulumiTagMarker
public class ApplicationAutoStopConfigurationArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var idleTimeoutMinutes: Output<Int>? = null

    /**
     * @param value Enables the application to automatically stop after a certain amount of time being idle. Defaults to `true`.
     */
    @JvmName("bdhramheeqdfkpym")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The amount of idle time in minutes after which your application will automatically stop. Defaults to `15` minutes.
     */
    @JvmName("ueltmqktietggbqc")
    public suspend fun idleTimeoutMinutes(`value`: Output<Int>) {
        this.idleTimeoutMinutes = value
    }

    /**
     * @param value Enables the application to automatically stop after a certain amount of time being idle. Defaults to `true`.
     */
    @JvmName("yvkslvgnvguuguia")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The amount of idle time in minutes after which your application will automatically stop. Defaults to `15` minutes.
     */
    @JvmName("vwqdxylpwvgmlwhs")
    public suspend fun idleTimeoutMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idleTimeoutMinutes = mapped
    }

    internal fun build(): ApplicationAutoStopConfigurationArgs = ApplicationAutoStopConfigurationArgs(
        enabled = enabled,
        idleTimeoutMinutes = idleTimeoutMinutes,
    )
}
