@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrserverless.kotlin.inputs

import com.pulumi.aws.emrserverless.inputs.ApplicationImageConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property imageUri The image URI.
 */
public data class ApplicationImageConfigurationArgs(
    public val imageUri: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.emrserverless.inputs.ApplicationImageConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.emrserverless.inputs.ApplicationImageConfigurationArgs =
        com.pulumi.aws.emrserverless.inputs.ApplicationImageConfigurationArgs.builder()
            .imageUri(imageUri.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationImageConfigurationArgs].
 */
@PulumiTagMarker
public class ApplicationImageConfigurationArgsBuilder internal constructor() {
    private var imageUri: Output<String>? = null

    /**
     * @param value The image URI.
     */
    @JvmName("sadbosqkxfuiijyw")
    public suspend fun imageUri(`value`: Output<String>) {
        this.imageUri = value
    }

    /**
     * @param value The image URI.
     */
    @JvmName("fhjxcrikctvjjycw")
    public suspend fun imageUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.imageUri = mapped
    }

    internal fun build(): ApplicationImageConfigurationArgs = ApplicationImageConfigurationArgs(
        imageUri = imageUri ?: throw PulumiNullFieldException("imageUri"),
    )
}
