@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrserverless.kotlin.inputs

import com.pulumi.aws.emrserverless.inputs.ApplicationInitialCapacityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property initialCapacityConfig The initial capacity configuration per worker.
 * @property initialCapacityType The worker type for an analytics framework. For Spark applications, the key can either be set to `Driver` or `Executor`. For Hive applications, it can be set to `HiveDriver` or `TezTask`.
 */
public data class ApplicationInitialCapacityArgs(
    public val initialCapacityConfig: Output<ApplicationInitialCapacityInitialCapacityConfigArgs>? =
        null,
    public val initialCapacityType: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.emrserverless.inputs.ApplicationInitialCapacityArgs> {
    override fun toJava(): com.pulumi.aws.emrserverless.inputs.ApplicationInitialCapacityArgs =
        com.pulumi.aws.emrserverless.inputs.ApplicationInitialCapacityArgs.builder()
            .initialCapacityConfig(
                initialCapacityConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .initialCapacityType(initialCapacityType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationInitialCapacityArgs].
 */
@PulumiTagMarker
public class ApplicationInitialCapacityArgsBuilder internal constructor() {
    private var initialCapacityConfig: Output<ApplicationInitialCapacityInitialCapacityConfigArgs>? =
        null

    private var initialCapacityType: Output<String>? = null

    /**
     * @param value The initial capacity configuration per worker.
     */
    @JvmName("owamrpyomticjnba")
    public suspend fun initialCapacityConfig(`value`: Output<ApplicationInitialCapacityInitialCapacityConfigArgs>) {
        this.initialCapacityConfig = value
    }

    /**
     * @param value The worker type for an analytics framework. For Spark applications, the key can either be set to `Driver` or `Executor`. For Hive applications, it can be set to `HiveDriver` or `TezTask`.
     */
    @JvmName("yjdwulwfgxooijsu")
    public suspend fun initialCapacityType(`value`: Output<String>) {
        this.initialCapacityType = value
    }

    /**
     * @param value The initial capacity configuration per worker.
     */
    @JvmName("oyiultifbspaavtu")
    public suspend fun initialCapacityConfig(`value`: ApplicationInitialCapacityInitialCapacityConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialCapacityConfig = mapped
    }

    /**
     * @param argument The initial capacity configuration per worker.
     */
    @JvmName("kxxnxilihdwwgchw")
    public suspend fun initialCapacityConfig(argument: suspend ApplicationInitialCapacityInitialCapacityConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationInitialCapacityInitialCapacityConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.initialCapacityConfig = mapped
    }

    /**
     * @param value The worker type for an analytics framework. For Spark applications, the key can either be set to `Driver` or `Executor`. For Hive applications, it can be set to `HiveDriver` or `TezTask`.
     */
    @JvmName("nigtbeowprbqcevw")
    public suspend fun initialCapacityType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.initialCapacityType = mapped
    }

    internal fun build(): ApplicationInitialCapacityArgs = ApplicationInitialCapacityArgs(
        initialCapacityConfig = initialCapacityConfig,
        initialCapacityType = initialCapacityType ?: throw PulumiNullFieldException("initialCapacityType"),
    )
}
