@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrserverless.kotlin.inputs

import com.pulumi.aws.emrserverless.inputs.ApplicationInitialCapacityInitialCapacityConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property workerConfiguration The resource configuration of the initial capacity configuration.
 * @property workerCount The number of workers in the initial capacity configuration.
 */
public data class ApplicationInitialCapacityInitialCapacityConfigArgs(
    public val workerConfiguration: Output<ApplicationInitialCapacityInitialCapacityConfigWorkerConfigurationArgs>? = null,
    public val workerCount: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.emrserverless.inputs.ApplicationInitialCapacityInitialCapacityConfigArgs> {
    override fun toJava(): com.pulumi.aws.emrserverless.inputs.ApplicationInitialCapacityInitialCapacityConfigArgs =
        com.pulumi.aws.emrserverless.inputs.ApplicationInitialCapacityInitialCapacityConfigArgs.builder()
            .workerConfiguration(
                workerConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .workerCount(workerCount.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationInitialCapacityInitialCapacityConfigArgs].
 */
@PulumiTagMarker
public class ApplicationInitialCapacityInitialCapacityConfigArgsBuilder internal constructor() {
    private var workerConfiguration:
        Output<ApplicationInitialCapacityInitialCapacityConfigWorkerConfigurationArgs>? = null

    private var workerCount: Output<Int>? = null

    /**
     * @param value The resource configuration of the initial capacity configuration.
     */
    @JvmName("xbicfnsrcvwefiff")
    public suspend fun workerConfiguration(`value`: Output<ApplicationInitialCapacityInitialCapacityConfigWorkerConfigurationArgs>) {
        this.workerConfiguration = value
    }

    /**
     * @param value The number of workers in the initial capacity configuration.
     */
    @JvmName("dewuvupfehpetpvg")
    public suspend fun workerCount(`value`: Output<Int>) {
        this.workerCount = value
    }

    /**
     * @param value The resource configuration of the initial capacity configuration.
     */
    @JvmName("obknnqgeuyukymyl")
    public suspend fun workerConfiguration(`value`: ApplicationInitialCapacityInitialCapacityConfigWorkerConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workerConfiguration = mapped
    }

    /**
     * @param argument The resource configuration of the initial capacity configuration.
     */
    @JvmName("bldgkwhafgafxsjb")
    public suspend fun workerConfiguration(argument: suspend ApplicationInitialCapacityInitialCapacityConfigWorkerConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ApplicationInitialCapacityInitialCapacityConfigWorkerConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.workerConfiguration = mapped
    }

    /**
     * @param value The number of workers in the initial capacity configuration.
     */
    @JvmName("orxcgaroophabkcm")
    public suspend fun workerCount(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workerCount = mapped
    }

    internal fun build(): ApplicationInitialCapacityInitialCapacityConfigArgs =
        ApplicationInitialCapacityInitialCapacityConfigArgs(
            workerConfiguration = workerConfiguration,
            workerCount = workerCount ?: throw PulumiNullFieldException("workerCount"),
        )
}
