@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrserverless.kotlin.inputs

import com.pulumi.aws.emrserverless.inputs.ApplicationInteractiveConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property livyEndpointEnabled Enables an Apache Livy endpoint that you can connect to and run interactive jobs.
 * @property studioEnabled Enables you to connect an application to Amazon EMR Studio to run interactive workloads in a notebook.
 */
public data class ApplicationInteractiveConfigurationArgs(
    public val livyEndpointEnabled: Output<Boolean>? = null,
    public val studioEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.emrserverless.inputs.ApplicationInteractiveConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.emrserverless.inputs.ApplicationInteractiveConfigurationArgs = com.pulumi.aws.emrserverless.inputs.ApplicationInteractiveConfigurationArgs.builder()
        .livyEndpointEnabled(livyEndpointEnabled?.applyValue({ args0 -> args0 }))
        .studioEnabled(studioEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationInteractiveConfigurationArgs].
 */
@PulumiTagMarker
public class ApplicationInteractiveConfigurationArgsBuilder internal constructor() {
    private var livyEndpointEnabled: Output<Boolean>? = null

    private var studioEnabled: Output<Boolean>? = null

    /**
     * @param value Enables an Apache Livy endpoint that you can connect to and run interactive jobs.
     */
    @JvmName("snpknauhqdsojopw")
    public suspend fun livyEndpointEnabled(`value`: Output<Boolean>) {
        this.livyEndpointEnabled = value
    }

    /**
     * @param value Enables you to connect an application to Amazon EMR Studio to run interactive workloads in a notebook.
     */
    @JvmName("tweljdkwatrshemn")
    public suspend fun studioEnabled(`value`: Output<Boolean>) {
        this.studioEnabled = value
    }

    /**
     * @param value Enables an Apache Livy endpoint that you can connect to and run interactive jobs.
     */
    @JvmName("nteymfgjfojiicud")
    public suspend fun livyEndpointEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.livyEndpointEnabled = mapped
    }

    /**
     * @param value Enables you to connect an application to Amazon EMR Studio to run interactive workloads in a notebook.
     */
    @JvmName("ifguipihgfuyqpuk")
    public suspend fun studioEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.studioEnabled = mapped
    }

    internal fun build(): ApplicationInteractiveConfigurationArgs =
        ApplicationInteractiveConfigurationArgs(
            livyEndpointEnabled = livyEndpointEnabled,
            studioEnabled = studioEnabled,
        )
}
