@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrserverless.kotlin.inputs

import com.pulumi.aws.emrserverless.inputs.ApplicationNetworkConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property securityGroupIds The array of security group Ids for customer VPC connectivity.
 * @property subnetIds The array of subnet Ids for customer VPC connectivity.
 */
public data class ApplicationNetworkConfigurationArgs(
    public val securityGroupIds: Output<List<String>>? = null,
    public val subnetIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.emrserverless.inputs.ApplicationNetworkConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.emrserverless.inputs.ApplicationNetworkConfigurationArgs =
        com.pulumi.aws.emrserverless.inputs.ApplicationNetworkConfigurationArgs.builder()
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ApplicationNetworkConfigurationArgs].
 */
@PulumiTagMarker
public class ApplicationNetworkConfigurationArgsBuilder internal constructor() {
    private var securityGroupIds: Output<List<String>>? = null

    private var subnetIds: Output<List<String>>? = null

    /**
     * @param value The array of security group Ids for customer VPC connectivity.
     */
    @JvmName("ypyqsyrhamengatd")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("rujjemhlxhnjpesa")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values The array of security group Ids for customer VPC connectivity.
     */
    @JvmName("ewgtlqnprqhnwuhc")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value The array of subnet Ids for customer VPC connectivity.
     */
    @JvmName("barxjwchxhctvdjn")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("xopnuitgfljbvlfc")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values The array of subnet Ids for customer VPC connectivity.
     */
    @JvmName("tohyxhdpveiiwlfy")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value The array of security group Ids for customer VPC connectivity.
     */
    @JvmName("trcelbppnqdtstfd")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values The array of security group Ids for customer VPC connectivity.
     */
    @JvmName("vdjalhkpkxrqhufo")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value The array of subnet Ids for customer VPC connectivity.
     */
    @JvmName("dcsuigiyeuqfyorb")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values The array of subnet Ids for customer VPC connectivity.
     */
    @JvmName("lemadqtibopjeoib")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    internal fun build(): ApplicationNetworkConfigurationArgs = ApplicationNetworkConfigurationArgs(
        securityGroupIds = securityGroupIds,
        subnetIds = subnetIds,
    )
}
