@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrserverless.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cpu The CPU requirements for every worker instance of the worker type.
 * @property disk The disk requirements for every worker instance of the worker type.
 * @property memory The memory requirements for every worker instance of the worker type.
 */
public data class ApplicationInitialCapacityInitialCapacityConfigWorkerConfiguration(
    public val cpu: String,
    public val disk: String? = null,
    public val memory: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.emrserverless.outputs.ApplicationInitialCapacityInitialCapacityConfigWorkerConfiguration): ApplicationInitialCapacityInitialCapacityConfigWorkerConfiguration =
            ApplicationInitialCapacityInitialCapacityConfigWorkerConfiguration(
                cpu = javaType.cpu(),
                disk = javaType.disk().map({ args0 -> args0 }).orElse(null),
                memory = javaType.memory(),
            )
    }
}
