@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrserverless.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property livyEndpointEnabled Enables an Apache Livy endpoint that you can connect to and run interactive jobs.
 * @property studioEnabled Enables you to connect an application to Amazon EMR Studio to run interactive workloads in a notebook.
 */
public data class ApplicationInteractiveConfiguration(
    public val livyEndpointEnabled: Boolean? = null,
    public val studioEnabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.emrserverless.outputs.ApplicationInteractiveConfiguration): ApplicationInteractiveConfiguration = ApplicationInteractiveConfiguration(
            livyEndpointEnabled = javaType.livyEndpointEnabled().map({ args0 -> args0 }).orElse(null),
            studioEnabled = javaType.studioEnabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
