@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrserverless.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cpu The maximum allowed CPU for an application.
 * @property disk The maximum allowed disk for an application.
 * @property memory The maximum allowed resources for an application.
 */
public data class ApplicationMaximumCapacity(
    public val cpu: String,
    public val disk: String? = null,
    public val memory: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.emrserverless.outputs.ApplicationMaximumCapacity): ApplicationMaximumCapacity = ApplicationMaximumCapacity(
            cpu = javaType.cpu(),
            disk = javaType.disk().map({ args0 -> args0 }).orElse(null),
            memory = javaType.memory(),
        )
    }
}
