@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.evidently.kotlin

import com.pulumi.aws.evidently.kotlin.outputs.FeatureEvaluationRule
import com.pulumi.aws.evidently.kotlin.outputs.FeatureVariation
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.evidently.kotlin.outputs.FeatureEvaluationRule.Companion.toKotlin as featureEvaluationRuleToKotlin
import com.pulumi.aws.evidently.kotlin.outputs.FeatureVariation.Companion.toKotlin as featureVariationToKotlin

/**
 * Builder for [Feature].
 */
@PulumiTagMarker
public class FeatureResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FeatureArgs = FeatureArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FeatureArgsBuilder.() -> Unit) {
        val builder = FeatureArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Feature {
        val builtJavaResource = com.pulumi.aws.evidently.Feature(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Feature(builtJavaResource)
    }
}

/**
 * Provides a CloudWatch Evidently Feature resource.
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.evidently.Feature("example", {
 *     name: "example",
 *     project: exampleAwsEvidentlyProject.name,
 *     description: "example description",
 *     variations: [{
 *         name: "Variation1",
 *         value: {
 *             stringValue: "example",
 *         },
 *     }],
 *     tags: {
 *         Key1: "example Feature",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.evidently.Feature("example",
 *     name="example",
 *     project=example_aws_evidently_project["name"],
 *     description="example description",
 *     variations=[{
 *         "name": "Variation1",
 *         "value": {
 *             "string_value": "example",
 *         },
 *     }],
 *     tags={
 *         "Key1": "example Feature",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Evidently.Feature("example", new()
 *     {
 *         Name = "example",
 *         Project = exampleAwsEvidentlyProject.Name,
 *         Description = "example description",
 *         Variations = new[]
 *         {
 *             new Aws.Evidently.Inputs.FeatureVariationArgs
 *             {
 *                 Name = "Variation1",
 *                 Value = new Aws.Evidently.Inputs.FeatureVariationValueArgs
 *                 {
 *                     StringValue = "example",
 *                 },
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Key1", "example Feature" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/evidently"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := evidently.NewFeature(ctx, "example", &evidently.FeatureArgs{
 * 			Name:        pulumi.String("example"),
 * 			Project:     pulumi.Any(exampleAwsEvidentlyProject.Name),
 * 			Description: pulumi.String("example description"),
 * 			Variations: evidently.FeatureVariationArray{
 * 				&evidently.FeatureVariationArgs{
 * 					Name: pulumi.String("Variation1"),
 * 					Value: &evidently.FeatureVariationValueArgs{
 * 						StringValue: pulumi.String("example"),
 * 					},
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Key1": pulumi.String("example Feature"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Feature;
 * import com.pulumi.aws.evidently.FeatureArgs;
 * import com.pulumi.aws.evidently.inputs.FeatureVariationArgs;
 * import com.pulumi.aws.evidently.inputs.FeatureVariationValueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Feature("example", FeatureArgs.builder()
 *             .name("example")
 *             .project(exampleAwsEvidentlyProject.name())
 *             .description("example description")
 *             .variations(FeatureVariationArgs.builder()
 *                 .name("Variation1")
 *                 .value(FeatureVariationValueArgs.builder()
 *                     .stringValue("example")
 *                     .build())
 *                 .build())
 *             .tags(Map.of("Key1", "example Feature"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:evidently:Feature
 *     properties:
 *       name: example
 *       project: ${exampleAwsEvidentlyProject.name}
 *       description: example description
 *       variations:
 *         - name: Variation1
 *           value:
 *             stringValue: example
 *       tags:
 *         Key1: example Feature
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With default variation
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.evidently.Feature("example", {
 *     name: "example",
 *     project: exampleAwsEvidentlyProject.name,
 *     defaultVariation: "Variation2",
 *     variations: [
 *         {
 *             name: "Variation1",
 *             value: {
 *                 stringValue: "exampleval1",
 *             },
 *         },
 *         {
 *             name: "Variation2",
 *             value: {
 *                 stringValue: "exampleval2",
 *             },
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.evidently.Feature("example",
 *     name="example",
 *     project=example_aws_evidently_project["name"],
 *     default_variation="Variation2",
 *     variations=[
 *         {
 *             "name": "Variation1",
 *             "value": {
 *                 "string_value": "exampleval1",
 *             },
 *         },
 *         {
 *             "name": "Variation2",
 *             "value": {
 *                 "string_value": "exampleval2",
 *             },
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Evidently.Feature("example", new()
 *     {
 *         Name = "example",
 *         Project = exampleAwsEvidentlyProject.Name,
 *         DefaultVariation = "Variation2",
 *         Variations = new[]
 *         {
 *             new Aws.Evidently.Inputs.FeatureVariationArgs
 *             {
 *                 Name = "Variation1",
 *                 Value = new Aws.Evidently.Inputs.FeatureVariationValueArgs
 *                 {
 *                     StringValue = "exampleval1",
 *                 },
 *             },
 *             new Aws.Evidently.Inputs.FeatureVariationArgs
 *             {
 *                 Name = "Variation2",
 *                 Value = new Aws.Evidently.Inputs.FeatureVariationValueArgs
 *                 {
 *                     StringValue = "exampleval2",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/evidently"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := evidently.NewFeature(ctx, "example", &evidently.FeatureArgs{
 * 			Name:             pulumi.String("example"),
 * 			Project:          pulumi.Any(exampleAwsEvidentlyProject.Name),
 * 			DefaultVariation: pulumi.String("Variation2"),
 * 			Variations: evidently.FeatureVariationArray{
 * 				&evidently.FeatureVariationArgs{
 * 					Name: pulumi.String("Variation1"),
 * 					Value: &evidently.FeatureVariationValueArgs{
 * 						StringValue: pulumi.String("exampleval1"),
 * 					},
 * 				},
 * 				&evidently.FeatureVariationArgs{
 * 					Name: pulumi.String("Variation2"),
 * 					Value: &evidently.FeatureVariationValueArgs{
 * 						StringValue: pulumi.String("exampleval2"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Feature;
 * import com.pulumi.aws.evidently.FeatureArgs;
 * import com.pulumi.aws.evidently.inputs.FeatureVariationArgs;
 * import com.pulumi.aws.evidently.inputs.FeatureVariationValueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Feature("example", FeatureArgs.builder()
 *             .name("example")
 *             .project(exampleAwsEvidentlyProject.name())
 *             .defaultVariation("Variation2")
 *             .variations(
 *                 FeatureVariationArgs.builder()
 *                     .name("Variation1")
 *                     .value(FeatureVariationValueArgs.builder()
 *                         .stringValue("exampleval1")
 *                         .build())
 *                     .build(),
 *                 FeatureVariationArgs.builder()
 *                     .name("Variation2")
 *                     .value(FeatureVariationValueArgs.builder()
 *                         .stringValue("exampleval2")
 *                         .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:evidently:Feature
 *     properties:
 *       name: example
 *       project: ${exampleAwsEvidentlyProject.name}
 *       defaultVariation: Variation2
 *       variations:
 *         - name: Variation1
 *           value:
 *             stringValue: exampleval1
 *         - name: Variation2
 *           value:
 *             stringValue: exampleval2
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With entity overrides
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.evidently.Feature("example", {
 *     name: "example",
 *     project: exampleAwsEvidentlyProject.name,
 *     entityOverrides: {
 *         test1: "Variation1",
 *     },
 *     variations: [
 *         {
 *             name: "Variation1",
 *             value: {
 *                 stringValue: "exampleval1",
 *             },
 *         },
 *         {
 *             name: "Variation2",
 *             value: {
 *                 stringValue: "exampleval2",
 *             },
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.evidently.Feature("example",
 *     name="example",
 *     project=example_aws_evidently_project["name"],
 *     entity_overrides={
 *         "test1": "Variation1",
 *     },
 *     variations=[
 *         {
 *             "name": "Variation1",
 *             "value": {
 *                 "string_value": "exampleval1",
 *             },
 *         },
 *         {
 *             "name": "Variation2",
 *             "value": {
 *                 "string_value": "exampleval2",
 *             },
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Evidently.Feature("example", new()
 *     {
 *         Name = "example",
 *         Project = exampleAwsEvidentlyProject.Name,
 *         EntityOverrides =
 *         {
 *             { "test1", "Variation1" },
 *         },
 *         Variations = new[]
 *         {
 *             new Aws.Evidently.Inputs.FeatureVariationArgs
 *             {
 *                 Name = "Variation1",
 *                 Value = new Aws.Evidently.Inputs.FeatureVariationValueArgs
 *                 {
 *                     StringValue = "exampleval1",
 *                 },
 *             },
 *             new Aws.Evidently.Inputs.FeatureVariationArgs
 *             {
 *                 Name = "Variation2",
 *                 Value = new Aws.Evidently.Inputs.FeatureVariationValueArgs
 *                 {
 *                     StringValue = "exampleval2",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/evidently"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := evidently.NewFeature(ctx, "example", &evidently.FeatureArgs{
 * 			Name:    pulumi.String("example"),
 * 			Project: pulumi.Any(exampleAwsEvidentlyProject.Name),
 * 			EntityOverrides: pulumi.StringMap{
 * 				"test1": pulumi.String("Variation1"),
 * 			},
 * 			Variations: evidently.FeatureVariationArray{
 * 				&evidently.FeatureVariationArgs{
 * 					Name: pulumi.String("Variation1"),
 * 					Value: &evidently.FeatureVariationValueArgs{
 * 						StringValue: pulumi.String("exampleval1"),
 * 					},
 * 				},
 * 				&evidently.FeatureVariationArgs{
 * 					Name: pulumi.String("Variation2"),
 * 					Value: &evidently.FeatureVariationValueArgs{
 * 						StringValue: pulumi.String("exampleval2"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Feature;
 * import com.pulumi.aws.evidently.FeatureArgs;
 * import com.pulumi.aws.evidently.inputs.FeatureVariationArgs;
 * import com.pulumi.aws.evidently.inputs.FeatureVariationValueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Feature("example", FeatureArgs.builder()
 *             .name("example")
 *             .project(exampleAwsEvidentlyProject.name())
 *             .entityOverrides(Map.of("test1", "Variation1"))
 *             .variations(
 *                 FeatureVariationArgs.builder()
 *                     .name("Variation1")
 *                     .value(FeatureVariationValueArgs.builder()
 *                         .stringValue("exampleval1")
 *                         .build())
 *                     .build(),
 *                 FeatureVariationArgs.builder()
 *                     .name("Variation2")
 *                     .value(FeatureVariationValueArgs.builder()
 *                         .stringValue("exampleval2")
 *                         .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:evidently:Feature
 *     properties:
 *       name: example
 *       project: ${exampleAwsEvidentlyProject.name}
 *       entityOverrides:
 *         test1: Variation1
 *       variations:
 *         - name: Variation1
 *           value:
 *             stringValue: exampleval1
 *         - name: Variation2
 *           value:
 *             stringValue: exampleval2
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With evaluation strategy
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.evidently.Feature("example", {
 *     name: "example",
 *     project: exampleAwsEvidentlyProject.name,
 *     evaluationStrategy: "ALL_RULES",
 *     entityOverrides: {
 *         test1: "Variation1",
 *     },
 *     variations: [{
 *         name: "Variation1",
 *         value: {
 *             stringValue: "exampleval1",
 *         },
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.evidently.Feature("example",
 *     name="example",
 *     project=example_aws_evidently_project["name"],
 *     evaluation_strategy="ALL_RULES",
 *     entity_overrides={
 *         "test1": "Variation1",
 *     },
 *     variations=[{
 *         "name": "Variation1",
 *         "value": {
 *             "string_value": "exampleval1",
 *         },
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Evidently.Feature("example", new()
 *     {
 *         Name = "example",
 *         Project = exampleAwsEvidentlyProject.Name,
 *         EvaluationStrategy = "ALL_RULES",
 *         EntityOverrides =
 *         {
 *             { "test1", "Variation1" },
 *         },
 *         Variations = new[]
 *         {
 *             new Aws.Evidently.Inputs.FeatureVariationArgs
 *             {
 *                 Name = "Variation1",
 *                 Value = new Aws.Evidently.Inputs.FeatureVariationValueArgs
 *                 {
 *                     StringValue = "exampleval1",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/evidently"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := evidently.NewFeature(ctx, "example", &evidently.FeatureArgs{
 * 			Name:               pulumi.String("example"),
 * 			Project:            pulumi.Any(exampleAwsEvidentlyProject.Name),
 * 			EvaluationStrategy: pulumi.String("ALL_RULES"),
 * 			EntityOverrides: pulumi.StringMap{
 * 				"test1": pulumi.String("Variation1"),
 * 			},
 * 			Variations: evidently.FeatureVariationArray{
 * 				&evidently.FeatureVariationArgs{
 * 					Name: pulumi.String("Variation1"),
 * 					Value: &evidently.FeatureVariationValueArgs{
 * 						StringValue: pulumi.String("exampleval1"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Feature;
 * import com.pulumi.aws.evidently.FeatureArgs;
 * import com.pulumi.aws.evidently.inputs.FeatureVariationArgs;
 * import com.pulumi.aws.evidently.inputs.FeatureVariationValueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Feature("example", FeatureArgs.builder()
 *             .name("example")
 *             .project(exampleAwsEvidentlyProject.name())
 *             .evaluationStrategy("ALL_RULES")
 *             .entityOverrides(Map.of("test1", "Variation1"))
 *             .variations(FeatureVariationArgs.builder()
 *                 .name("Variation1")
 *                 .value(FeatureVariationValueArgs.builder()
 *                     .stringValue("exampleval1")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:evidently:Feature
 *     properties:
 *       name: example
 *       project: ${exampleAwsEvidentlyProject.name}
 *       evaluationStrategy: ALL_RULES
 *       entityOverrides:
 *         test1: Variation1
 *       variations:
 *         - name: Variation1
 *           value:
 *             stringValue: exampleval1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CloudWatch Evidently Feature using the feature `name` and `name` or `arn` of the hosting CloudWatch Evidently Project separated by a `:`. For example:
 * ```sh
 * $ pulumi import aws:evidently/feature:Feature example exampleFeatureName:arn:aws:evidently:us-east-1:123456789012:project/example
 * ```
 */
public class Feature internal constructor(
    override val javaResource: com.pulumi.aws.evidently.Feature,
) : KotlinCustomResource(javaResource, FeatureMapper) {
    /**
     * The ARN of the feature.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The date and time that the feature is created.
     */
    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    /**
     * The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature. This variation must also be listed in the `variations` structure. If you omit `default_variation`, the first variation listed in the `variations` structure is used as the default variation.
     */
    public val defaultVariation: Output<String>
        get() = javaResource.defaultVariation().applyValue({ args0 -> args0 })

    /**
     * Specifies the description of the feature.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specify users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.
     */
    public val entityOverrides: Output<Map<String, String>>?
        get() = javaResource.entityOverrides().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * One or more blocks that define the evaluation rules for the feature. Detailed below
     */
    public val evaluationRules: Output<List<FeatureEvaluationRule>>
        get() = javaResource.evaluationRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> featureEvaluationRuleToKotlin(args0) })
            })
        })

    /**
     * Specify `ALL_RULES` to activate the traffic allocation specified by any ongoing launches or experiments. Specify `DEFAULT_VARIATION` to serve the default variation to all users instead.
     */
    public val evaluationStrategy: Output<String>
        get() = javaResource.evaluationStrategy().applyValue({ args0 -> args0 })

    /**
     * The date and time that the feature was most recently updated.
     */
    public val lastUpdatedTime: Output<String>
        get() = javaResource.lastUpdatedTime().applyValue({ args0 -> args0 })

    /**
     * The name for the new feature. Minimum length of `1`. Maximum length of `127`.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The name or ARN of the project that is to contain the new feature.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * The current state of the feature. Valid values are `AVAILABLE` and `UPDATING`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Tags to apply to the feature. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Defines the type of value used to define the different feature variations. Valid Values: `STRING`, `LONG`, `DOUBLE`, `BOOLEAN`.
     */
    public val valueType: Output<String>
        get() = javaResource.valueType().applyValue({ args0 -> args0 })

    /**
     * One or more blocks that contain the configuration of the feature's different variations. Detailed below
     */
    public val variations: Output<List<FeatureVariation>>
        get() = javaResource.variations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    featureVariationToKotlin(args0)
                })
            })
        })
}

public object FeatureMapper : ResourceMapper<Feature> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.evidently.Feature::class == javaResource::class

    override fun map(javaResource: Resource): Feature = Feature(
        javaResource as
            com.pulumi.aws.evidently.Feature,
    )
}

/**
 * @see [Feature].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Feature].
 */
public suspend fun feature(name: String, block: suspend FeatureResourceBuilder.() -> Unit): Feature {
    val builder = FeatureResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Feature].
 * @param name The _unique_ name of the resulting resource.
 */
public fun feature(name: String): Feature {
    val builder = FeatureResourceBuilder()
    builder.name(name)
    return builder.build()
}
