@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.evidently.kotlin

import com.pulumi.aws.evidently.FeatureArgs.builder
import com.pulumi.aws.evidently.kotlin.inputs.FeatureVariationArgs
import com.pulumi.aws.evidently.kotlin.inputs.FeatureVariationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CloudWatch Evidently Feature resource.
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.evidently.Feature("example", {
 *     name: "example",
 *     project: exampleAwsEvidentlyProject.name,
 *     description: "example description",
 *     variations: [{
 *         name: "Variation1",
 *         value: {
 *             stringValue: "example",
 *         },
 *     }],
 *     tags: {
 *         Key1: "example Feature",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.evidently.Feature("example",
 *     name="example",
 *     project=example_aws_evidently_project["name"],
 *     description="example description",
 *     variations=[{
 *         "name": "Variation1",
 *         "value": {
 *             "string_value": "example",
 *         },
 *     }],
 *     tags={
 *         "Key1": "example Feature",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Evidently.Feature("example", new()
 *     {
 *         Name = "example",
 *         Project = exampleAwsEvidentlyProject.Name,
 *         Description = "example description",
 *         Variations = new[]
 *         {
 *             new Aws.Evidently.Inputs.FeatureVariationArgs
 *             {
 *                 Name = "Variation1",
 *                 Value = new Aws.Evidently.Inputs.FeatureVariationValueArgs
 *                 {
 *                     StringValue = "example",
 *                 },
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Key1", "example Feature" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/evidently"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := evidently.NewFeature(ctx, "example", &evidently.FeatureArgs{
 * 			Name:        pulumi.String("example"),
 * 			Project:     pulumi.Any(exampleAwsEvidentlyProject.Name),
 * 			Description: pulumi.String("example description"),
 * 			Variations: evidently.FeatureVariationArray{
 * 				&evidently.FeatureVariationArgs{
 * 					Name: pulumi.String("Variation1"),
 * 					Value: &evidently.FeatureVariationValueArgs{
 * 						StringValue: pulumi.String("example"),
 * 					},
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Key1": pulumi.String("example Feature"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Feature;
 * import com.pulumi.aws.evidently.FeatureArgs;
 * import com.pulumi.aws.evidently.inputs.FeatureVariationArgs;
 * import com.pulumi.aws.evidently.inputs.FeatureVariationValueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Feature("example", FeatureArgs.builder()
 *             .name("example")
 *             .project(exampleAwsEvidentlyProject.name())
 *             .description("example description")
 *             .variations(FeatureVariationArgs.builder()
 *                 .name("Variation1")
 *                 .value(FeatureVariationValueArgs.builder()
 *                     .stringValue("example")
 *                     .build())
 *                 .build())
 *             .tags(Map.of("Key1", "example Feature"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:evidently:Feature
 *     properties:
 *       name: example
 *       project: ${exampleAwsEvidentlyProject.name}
 *       description: example description
 *       variations:
 *         - name: Variation1
 *           value:
 *             stringValue: example
 *       tags:
 *         Key1: example Feature
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With default variation
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.evidently.Feature("example", {
 *     name: "example",
 *     project: exampleAwsEvidentlyProject.name,
 *     defaultVariation: "Variation2",
 *     variations: [
 *         {
 *             name: "Variation1",
 *             value: {
 *                 stringValue: "exampleval1",
 *             },
 *         },
 *         {
 *             name: "Variation2",
 *             value: {
 *                 stringValue: "exampleval2",
 *             },
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.evidently.Feature("example",
 *     name="example",
 *     project=example_aws_evidently_project["name"],
 *     default_variation="Variation2",
 *     variations=[
 *         {
 *             "name": "Variation1",
 *             "value": {
 *                 "string_value": "exampleval1",
 *             },
 *         },
 *         {
 *             "name": "Variation2",
 *             "value": {
 *                 "string_value": "exampleval2",
 *             },
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Evidently.Feature("example", new()
 *     {
 *         Name = "example",
 *         Project = exampleAwsEvidentlyProject.Name,
 *         DefaultVariation = "Variation2",
 *         Variations = new[]
 *         {
 *             new Aws.Evidently.Inputs.FeatureVariationArgs
 *             {
 *                 Name = "Variation1",
 *                 Value = new Aws.Evidently.Inputs.FeatureVariationValueArgs
 *                 {
 *                     StringValue = "exampleval1",
 *                 },
 *             },
 *             new Aws.Evidently.Inputs.FeatureVariationArgs
 *             {
 *                 Name = "Variation2",
 *                 Value = new Aws.Evidently.Inputs.FeatureVariationValueArgs
 *                 {
 *                     StringValue = "exampleval2",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/evidently"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := evidently.NewFeature(ctx, "example", &evidently.FeatureArgs{
 * 			Name:             pulumi.String("example"),
 * 			Project:          pulumi.Any(exampleAwsEvidentlyProject.Name),
 * 			DefaultVariation: pulumi.String("Variation2"),
 * 			Variations: evidently.FeatureVariationArray{
 * 				&evidently.FeatureVariationArgs{
 * 					Name: pulumi.String("Variation1"),
 * 					Value: &evidently.FeatureVariationValueArgs{
 * 						StringValue: pulumi.String("exampleval1"),
 * 					},
 * 				},
 * 				&evidently.FeatureVariationArgs{
 * 					Name: pulumi.String("Variation2"),
 * 					Value: &evidently.FeatureVariationValueArgs{
 * 						StringValue: pulumi.String("exampleval2"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Feature;
 * import com.pulumi.aws.evidently.FeatureArgs;
 * import com.pulumi.aws.evidently.inputs.FeatureVariationArgs;
 * import com.pulumi.aws.evidently.inputs.FeatureVariationValueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Feature("example", FeatureArgs.builder()
 *             .name("example")
 *             .project(exampleAwsEvidentlyProject.name())
 *             .defaultVariation("Variation2")
 *             .variations(
 *                 FeatureVariationArgs.builder()
 *                     .name("Variation1")
 *                     .value(FeatureVariationValueArgs.builder()
 *                         .stringValue("exampleval1")
 *                         .build())
 *                     .build(),
 *                 FeatureVariationArgs.builder()
 *                     .name("Variation2")
 *                     .value(FeatureVariationValueArgs.builder()
 *                         .stringValue("exampleval2")
 *                         .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:evidently:Feature
 *     properties:
 *       name: example
 *       project: ${exampleAwsEvidentlyProject.name}
 *       defaultVariation: Variation2
 *       variations:
 *         - name: Variation1
 *           value:
 *             stringValue: exampleval1
 *         - name: Variation2
 *           value:
 *             stringValue: exampleval2
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With entity overrides
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.evidently.Feature("example", {
 *     name: "example",
 *     project: exampleAwsEvidentlyProject.name,
 *     entityOverrides: {
 *         test1: "Variation1",
 *     },
 *     variations: [
 *         {
 *             name: "Variation1",
 *             value: {
 *                 stringValue: "exampleval1",
 *             },
 *         },
 *         {
 *             name: "Variation2",
 *             value: {
 *                 stringValue: "exampleval2",
 *             },
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.evidently.Feature("example",
 *     name="example",
 *     project=example_aws_evidently_project["name"],
 *     entity_overrides={
 *         "test1": "Variation1",
 *     },
 *     variations=[
 *         {
 *             "name": "Variation1",
 *             "value": {
 *                 "string_value": "exampleval1",
 *             },
 *         },
 *         {
 *             "name": "Variation2",
 *             "value": {
 *                 "string_value": "exampleval2",
 *             },
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Evidently.Feature("example", new()
 *     {
 *         Name = "example",
 *         Project = exampleAwsEvidentlyProject.Name,
 *         EntityOverrides =
 *         {
 *             { "test1", "Variation1" },
 *         },
 *         Variations = new[]
 *         {
 *             new Aws.Evidently.Inputs.FeatureVariationArgs
 *             {
 *                 Name = "Variation1",
 *                 Value = new Aws.Evidently.Inputs.FeatureVariationValueArgs
 *                 {
 *                     StringValue = "exampleval1",
 *                 },
 *             },
 *             new Aws.Evidently.Inputs.FeatureVariationArgs
 *             {
 *                 Name = "Variation2",
 *                 Value = new Aws.Evidently.Inputs.FeatureVariationValueArgs
 *                 {
 *                     StringValue = "exampleval2",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/evidently"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := evidently.NewFeature(ctx, "example", &evidently.FeatureArgs{
 * 			Name:    pulumi.String("example"),
 * 			Project: pulumi.Any(exampleAwsEvidentlyProject.Name),
 * 			EntityOverrides: pulumi.StringMap{
 * 				"test1": pulumi.String("Variation1"),
 * 			},
 * 			Variations: evidently.FeatureVariationArray{
 * 				&evidently.FeatureVariationArgs{
 * 					Name: pulumi.String("Variation1"),
 * 					Value: &evidently.FeatureVariationValueArgs{
 * 						StringValue: pulumi.String("exampleval1"),
 * 					},
 * 				},
 * 				&evidently.FeatureVariationArgs{
 * 					Name: pulumi.String("Variation2"),
 * 					Value: &evidently.FeatureVariationValueArgs{
 * 						StringValue: pulumi.String("exampleval2"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Feature;
 * import com.pulumi.aws.evidently.FeatureArgs;
 * import com.pulumi.aws.evidently.inputs.FeatureVariationArgs;
 * import com.pulumi.aws.evidently.inputs.FeatureVariationValueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Feature("example", FeatureArgs.builder()
 *             .name("example")
 *             .project(exampleAwsEvidentlyProject.name())
 *             .entityOverrides(Map.of("test1", "Variation1"))
 *             .variations(
 *                 FeatureVariationArgs.builder()
 *                     .name("Variation1")
 *                     .value(FeatureVariationValueArgs.builder()
 *                         .stringValue("exampleval1")
 *                         .build())
 *                     .build(),
 *                 FeatureVariationArgs.builder()
 *                     .name("Variation2")
 *                     .value(FeatureVariationValueArgs.builder()
 *                         .stringValue("exampleval2")
 *                         .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:evidently:Feature
 *     properties:
 *       name: example
 *       project: ${exampleAwsEvidentlyProject.name}
 *       entityOverrides:
 *         test1: Variation1
 *       variations:
 *         - name: Variation1
 *           value:
 *             stringValue: exampleval1
 *         - name: Variation2
 *           value:
 *             stringValue: exampleval2
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With evaluation strategy
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.evidently.Feature("example", {
 *     name: "example",
 *     project: exampleAwsEvidentlyProject.name,
 *     evaluationStrategy: "ALL_RULES",
 *     entityOverrides: {
 *         test1: "Variation1",
 *     },
 *     variations: [{
 *         name: "Variation1",
 *         value: {
 *             stringValue: "exampleval1",
 *         },
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.evidently.Feature("example",
 *     name="example",
 *     project=example_aws_evidently_project["name"],
 *     evaluation_strategy="ALL_RULES",
 *     entity_overrides={
 *         "test1": "Variation1",
 *     },
 *     variations=[{
 *         "name": "Variation1",
 *         "value": {
 *             "string_value": "exampleval1",
 *         },
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Evidently.Feature("example", new()
 *     {
 *         Name = "example",
 *         Project = exampleAwsEvidentlyProject.Name,
 *         EvaluationStrategy = "ALL_RULES",
 *         EntityOverrides =
 *         {
 *             { "test1", "Variation1" },
 *         },
 *         Variations = new[]
 *         {
 *             new Aws.Evidently.Inputs.FeatureVariationArgs
 *             {
 *                 Name = "Variation1",
 *                 Value = new Aws.Evidently.Inputs.FeatureVariationValueArgs
 *                 {
 *                     StringValue = "exampleval1",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/evidently"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := evidently.NewFeature(ctx, "example", &evidently.FeatureArgs{
 * 			Name:               pulumi.String("example"),
 * 			Project:            pulumi.Any(exampleAwsEvidentlyProject.Name),
 * 			EvaluationStrategy: pulumi.String("ALL_RULES"),
 * 			EntityOverrides: pulumi.StringMap{
 * 				"test1": pulumi.String("Variation1"),
 * 			},
 * 			Variations: evidently.FeatureVariationArray{
 * 				&evidently.FeatureVariationArgs{
 * 					Name: pulumi.String("Variation1"),
 * 					Value: &evidently.FeatureVariationValueArgs{
 * 						StringValue: pulumi.String("exampleval1"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Feature;
 * import com.pulumi.aws.evidently.FeatureArgs;
 * import com.pulumi.aws.evidently.inputs.FeatureVariationArgs;
 * import com.pulumi.aws.evidently.inputs.FeatureVariationValueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Feature("example", FeatureArgs.builder()
 *             .name("example")
 *             .project(exampleAwsEvidentlyProject.name())
 *             .evaluationStrategy("ALL_RULES")
 *             .entityOverrides(Map.of("test1", "Variation1"))
 *             .variations(FeatureVariationArgs.builder()
 *                 .name("Variation1")
 *                 .value(FeatureVariationValueArgs.builder()
 *                     .stringValue("exampleval1")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:evidently:Feature
 *     properties:
 *       name: example
 *       project: ${exampleAwsEvidentlyProject.name}
 *       evaluationStrategy: ALL_RULES
 *       entityOverrides:
 *         test1: Variation1
 *       variations:
 *         - name: Variation1
 *           value:
 *             stringValue: exampleval1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CloudWatch Evidently Feature using the feature `name` and `name` or `arn` of the hosting CloudWatch Evidently Project separated by a `:`. For example:
 * ```sh
 * $ pulumi import aws:evidently/feature:Feature example exampleFeatureName:arn:aws:evidently:us-east-1:123456789012:project/example
 * ```
 * @property defaultVariation The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature. This variation must also be listed in the `variations` structure. If you omit `default_variation`, the first variation listed in the `variations` structure is used as the default variation.
 * @property description Specifies the description of the feature.
 * @property entityOverrides Specify users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.
 * @property evaluationStrategy Specify `ALL_RULES` to activate the traffic allocation specified by any ongoing launches or experiments. Specify `DEFAULT_VARIATION` to serve the default variation to all users instead.
 * @property name The name for the new feature. Minimum length of `1`. Maximum length of `127`.
 * @property project The name or ARN of the project that is to contain the new feature.
 * @property tags Tags to apply to the feature. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property variations One or more blocks that contain the configuration of the feature's different variations. Detailed below
 */
public data class FeatureArgs(
    public val defaultVariation: Output<String>? = null,
    public val description: Output<String>? = null,
    public val entityOverrides: Output<Map<String, String>>? = null,
    public val evaluationStrategy: Output<String>? = null,
    public val name: Output<String>? = null,
    public val project: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val variations: Output<List<FeatureVariationArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.evidently.FeatureArgs> {
    override fun toJava(): com.pulumi.aws.evidently.FeatureArgs =
        com.pulumi.aws.evidently.FeatureArgs.builder()
            .defaultVariation(defaultVariation?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .entityOverrides(
                entityOverrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .evaluationStrategy(evaluationStrategy?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .variations(
                variations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [FeatureArgs].
 */
@PulumiTagMarker
public class FeatureArgsBuilder internal constructor() {
    private var defaultVariation: Output<String>? = null

    private var description: Output<String>? = null

    private var entityOverrides: Output<Map<String, String>>? = null

    private var evaluationStrategy: Output<String>? = null

    private var name: Output<String>? = null

    private var project: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var variations: Output<List<FeatureVariationArgs>>? = null

    /**
     * @param value The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature. This variation must also be listed in the `variations` structure. If you omit `default_variation`, the first variation listed in the `variations` structure is used as the default variation.
     */
    @JvmName("remippxrseqkohbk")
    public suspend fun defaultVariation(`value`: Output<String>) {
        this.defaultVariation = value
    }

    /**
     * @param value Specifies the description of the feature.
     */
    @JvmName("ryxrvxdanldnphqr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specify users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.
     */
    @JvmName("plvxwcpygpylblcx")
    public suspend fun entityOverrides(`value`: Output<Map<String, String>>) {
        this.entityOverrides = value
    }

    /**
     * @param value Specify `ALL_RULES` to activate the traffic allocation specified by any ongoing launches or experiments. Specify `DEFAULT_VARIATION` to serve the default variation to all users instead.
     */
    @JvmName("dsgvrurbeacxiihu")
    public suspend fun evaluationStrategy(`value`: Output<String>) {
        this.evaluationStrategy = value
    }

    /**
     * @param value The name for the new feature. Minimum length of `1`. Maximum length of `127`.
     */
    @JvmName("oevwpfyhcykpyhnm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name or ARN of the project that is to contain the new feature.
     */
    @JvmName("gbsfnamqcwjmflxq")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value Tags to apply to the feature. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("upovmiinbsfmbxji")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value One or more blocks that contain the configuration of the feature's different variations. Detailed below
     */
    @JvmName("scdlkpudduyghsmy")
    public suspend fun variations(`value`: Output<List<FeatureVariationArgs>>) {
        this.variations = value
    }

    @JvmName("gnapmpxbpsskrefi")
    public suspend fun variations(vararg values: Output<FeatureVariationArgs>) {
        this.variations = Output.all(values.asList())
    }

    /**
     * @param values One or more blocks that contain the configuration of the feature's different variations. Detailed below
     */
    @JvmName("etogawgiytygyvfy")
    public suspend fun variations(values: List<Output<FeatureVariationArgs>>) {
        this.variations = Output.all(values)
    }

    /**
     * @param value The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature. This variation must also be listed in the `variations` structure. If you omit `default_variation`, the first variation listed in the `variations` structure is used as the default variation.
     */
    @JvmName("lgiqshbfdjqlovqc")
    public suspend fun defaultVariation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultVariation = mapped
    }

    /**
     * @param value Specifies the description of the feature.
     */
    @JvmName("abdlfpmpmwuvgbda")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specify users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.
     */
    @JvmName("fjmevhisxcxrbmdd")
    public suspend fun entityOverrides(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entityOverrides = mapped
    }

    /**
     * @param values Specify users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.
     */
    @JvmName("rpnsmltwlrctnjlt")
    public fun entityOverrides(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.entityOverrides = mapped
    }

    /**
     * @param value Specify `ALL_RULES` to activate the traffic allocation specified by any ongoing launches or experiments. Specify `DEFAULT_VARIATION` to serve the default variation to all users instead.
     */
    @JvmName("ichutfkkceiicujf")
    public suspend fun evaluationStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.evaluationStrategy = mapped
    }

    /**
     * @param value The name for the new feature. Minimum length of `1`. Maximum length of `127`.
     */
    @JvmName("spfplgbuaqywcsux")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name or ARN of the project that is to contain the new feature.
     */
    @JvmName("rxphjvsiatxghebn")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value Tags to apply to the feature. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gvgqwjhrmybjubmp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags to apply to the feature. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wyhwnydxqhptbqho")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value One or more blocks that contain the configuration of the feature's different variations. Detailed below
     */
    @JvmName("uobxbnimnqokaewp")
    public suspend fun variations(`value`: List<FeatureVariationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.variations = mapped
    }

    /**
     * @param argument One or more blocks that contain the configuration of the feature's different variations. Detailed below
     */
    @JvmName("cbywllgpufasvkdf")
    public suspend fun variations(argument: List<suspend FeatureVariationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FeatureVariationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.variations = mapped
    }

    /**
     * @param argument One or more blocks that contain the configuration of the feature's different variations. Detailed below
     */
    @JvmName("eksttaiwimgsyilw")
    public suspend fun variations(vararg argument: suspend FeatureVariationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FeatureVariationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.variations = mapped
    }

    /**
     * @param argument One or more blocks that contain the configuration of the feature's different variations. Detailed below
     */
    @JvmName("wildrfmbxijansfc")
    public suspend fun variations(argument: suspend FeatureVariationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(FeatureVariationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.variations = mapped
    }

    /**
     * @param values One or more blocks that contain the configuration of the feature's different variations. Detailed below
     */
    @JvmName("cmpdsuslqpyxnfpc")
    public suspend fun variations(vararg values: FeatureVariationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.variations = mapped
    }

    internal fun build(): FeatureArgs = FeatureArgs(
        defaultVariation = defaultVariation,
        description = description,
        entityOverrides = entityOverrides,
        evaluationStrategy = evaluationStrategy,
        name = name,
        project = project,
        tags = tags,
        variations = variations,
    )
}
