@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.evidently.kotlin

import com.pulumi.aws.evidently.kotlin.outputs.LaunchExecution
import com.pulumi.aws.evidently.kotlin.outputs.LaunchGroup
import com.pulumi.aws.evidently.kotlin.outputs.LaunchMetricMonitor
import com.pulumi.aws.evidently.kotlin.outputs.LaunchScheduledSplitsConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.evidently.kotlin.outputs.LaunchExecution.Companion.toKotlin as launchExecutionToKotlin
import com.pulumi.aws.evidently.kotlin.outputs.LaunchGroup.Companion.toKotlin as launchGroupToKotlin
import com.pulumi.aws.evidently.kotlin.outputs.LaunchMetricMonitor.Companion.toKotlin as launchMetricMonitorToKotlin
import com.pulumi.aws.evidently.kotlin.outputs.LaunchScheduledSplitsConfig.Companion.toKotlin as launchScheduledSplitsConfigToKotlin

/**
 * Builder for [Launch].
 */
@PulumiTagMarker
public class LaunchResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LaunchArgs = LaunchArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LaunchArgsBuilder.() -> Unit) {
        val builder = LaunchArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Launch {
        val builtJavaResource = com.pulumi.aws.evidently.Launch(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Launch(builtJavaResource)
    }
}

/**
 * Provides a CloudWatch Evidently Launch resource.
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.evidently.Launch("example", {
 *     name: "example",
 *     project: exampleAwsEvidentlyProject.name,
 *     groups: [{
 *         feature: exampleAwsEvidentlyFeature.name,
 *         name: "Variation1",
 *         variation: "Variation1",
 *     }],
 *     scheduledSplitsConfig: {
 *         steps: [{
 *             groupWeights: {
 *                 Variation1: 0,
 *             },
 *             startTime: "2024-01-07 01:43:59+00:00",
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.evidently.Launch("example",
 *     name="example",
 *     project=example_aws_evidently_project["name"],
 *     groups=[{
 *         "feature": example_aws_evidently_feature["name"],
 *         "name": "Variation1",
 *         "variation": "Variation1",
 *     }],
 *     scheduled_splits_config={
 *         "steps": [{
 *             "group_weights": {
 *                 "variation1": 0,
 *             },
 *             "start_time": "2024-01-07 01:43:59+00:00",
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Evidently.Launch("example", new()
 *     {
 *         Name = "example",
 *         Project = exampleAwsEvidentlyProject.Name,
 *         Groups = new[]
 *         {
 *             new Aws.Evidently.Inputs.LaunchGroupArgs
 *             {
 *                 Feature = exampleAwsEvidentlyFeature.Name,
 *                 Name = "Variation1",
 *                 Variation = "Variation1",
 *             },
 *         },
 *         ScheduledSplitsConfig = new Aws.Evidently.Inputs.LaunchScheduledSplitsConfigArgs
 *         {
 *             Steps = new[]
 *             {
 *                 new Aws.Evidently.Inputs.LaunchScheduledSplitsConfigStepArgs
 *                 {
 *                     GroupWeights =
 *                     {
 *                         { "Variation1", 0 },
 *                     },
 *                     StartTime = "2024-01-07 01:43:59+00:00",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/evidently"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := evidently.NewLaunch(ctx, "example", &evidently.LaunchArgs{
 * 			Name:    pulumi.String("example"),
 * 			Project: pulumi.Any(exampleAwsEvidentlyProject.Name),
 * 			Groups: evidently.LaunchGroupArray{
 * 				&evidently.LaunchGroupArgs{
 * 					Feature:   pulumi.Any(exampleAwsEvidentlyFeature.Name),
 * 					Name:      pulumi.String("Variation1"),
 * 					Variation: pulumi.String("Variation1"),
 * 				},
 * 			},
 * 			ScheduledSplitsConfig: &evidently.LaunchScheduledSplitsConfigArgs{
 * 				Steps: evidently.LaunchScheduledSplitsConfigStepArray{
 * 					&evidently.LaunchScheduledSplitsConfigStepArgs{
 * 						GroupWeights: pulumi.IntMap{
 * 							"Variation1": pulumi.Int(0),
 * 						},
 * 						StartTime: pulumi.String("2024-01-07 01:43:59+00:00"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Launch;
 * import com.pulumi.aws.evidently.LaunchArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchGroupArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Launch("example", LaunchArgs.builder()
 *             .name("example")
 *             .project(exampleAwsEvidentlyProject.name())
 *             .groups(LaunchGroupArgs.builder()
 *                 .feature(exampleAwsEvidentlyFeature.name())
 *                 .name("Variation1")
 *                 .variation("Variation1")
 *                 .build())
 *             .scheduledSplitsConfig(LaunchScheduledSplitsConfigArgs.builder()
 *                 .steps(LaunchScheduledSplitsConfigStepArgs.builder()
 *                     .groupWeights(Map.of("Variation1", 0))
 *                     .startTime("2024-01-07 01:43:59+00:00")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:evidently:Launch
 *     properties:
 *       name: example
 *       project: ${exampleAwsEvidentlyProject.name}
 *       groups:
 *         - feature: ${exampleAwsEvidentlyFeature.name}
 *           name: Variation1
 *           variation: Variation1
 *       scheduledSplitsConfig:
 *         steps:
 *           - groupWeights:
 *               Variation1: 0
 *             startTime: 2024-01-07 01:43:59+00:00
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With description
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.evidently.Launch("example", {
 *     name: "example",
 *     project: exampleAwsEvidentlyProject.name,
 *     description: "example description",
 *     groups: [{
 *         feature: exampleAwsEvidentlyFeature.name,
 *         name: "Variation1",
 *         variation: "Variation1",
 *     }],
 *     scheduledSplitsConfig: {
 *         steps: [{
 *             groupWeights: {
 *                 Variation1: 0,
 *             },
 *             startTime: "2024-01-07 01:43:59+00:00",
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.evidently.Launch("example",
 *     name="example",
 *     project=example_aws_evidently_project["name"],
 *     description="example description",
 *     groups=[{
 *         "feature": example_aws_evidently_feature["name"],
 *         "name": "Variation1",
 *         "variation": "Variation1",
 *     }],
 *     scheduled_splits_config={
 *         "steps": [{
 *             "group_weights": {
 *                 "variation1": 0,
 *             },
 *             "start_time": "2024-01-07 01:43:59+00:00",
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Evidently.Launch("example", new()
 *     {
 *         Name = "example",
 *         Project = exampleAwsEvidentlyProject.Name,
 *         Description = "example description",
 *         Groups = new[]
 *         {
 *             new Aws.Evidently.Inputs.LaunchGroupArgs
 *             {
 *                 Feature = exampleAwsEvidentlyFeature.Name,
 *                 Name = "Variation1",
 *                 Variation = "Variation1",
 *             },
 *         },
 *         ScheduledSplitsConfig = new Aws.Evidently.Inputs.LaunchScheduledSplitsConfigArgs
 *         {
 *             Steps = new[]
 *             {
 *                 new Aws.Evidently.Inputs.LaunchScheduledSplitsConfigStepArgs
 *                 {
 *                     GroupWeights =
 *                     {
 *                         { "Variation1", 0 },
 *                     },
 *                     StartTime = "2024-01-07 01:43:59+00:00",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/evidently"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := evidently.NewLaunch(ctx, "example", &evidently.LaunchArgs{
 * 			Name:        pulumi.String("example"),
 * 			Project:     pulumi.Any(exampleAwsEvidentlyProject.Name),
 * 			Description: pulumi.String("example description"),
 * 			Groups: evidently.LaunchGroupArray{
 * 				&evidently.LaunchGroupArgs{
 * 					Feature:   pulumi.Any(exampleAwsEvidentlyFeature.Name),
 * 					Name:      pulumi.String("Variation1"),
 * 					Variation: pulumi.String("Variation1"),
 * 				},
 * 			},
 * 			ScheduledSplitsConfig: &evidently.LaunchScheduledSplitsConfigArgs{
 * 				Steps: evidently.LaunchScheduledSplitsConfigStepArray{
 * 					&evidently.LaunchScheduledSplitsConfigStepArgs{
 * 						GroupWeights: pulumi.IntMap{
 * 							"Variation1": pulumi.Int(0),
 * 						},
 * 						StartTime: pulumi.String("2024-01-07 01:43:59+00:00"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Launch;
 * import com.pulumi.aws.evidently.LaunchArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchGroupArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Launch("example", LaunchArgs.builder()
 *             .name("example")
 *             .project(exampleAwsEvidentlyProject.name())
 *             .description("example description")
 *             .groups(LaunchGroupArgs.builder()
 *                 .feature(exampleAwsEvidentlyFeature.name())
 *                 .name("Variation1")
 *                 .variation("Variation1")
 *                 .build())
 *             .scheduledSplitsConfig(LaunchScheduledSplitsConfigArgs.builder()
 *                 .steps(LaunchScheduledSplitsConfigStepArgs.builder()
 *                     .groupWeights(Map.of("Variation1", 0))
 *                     .startTime("2024-01-07 01:43:59+00:00")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:evidently:Launch
 *     properties:
 *       name: example
 *       project: ${exampleAwsEvidentlyProject.name}
 *       description: example description
 *       groups:
 *         - feature: ${exampleAwsEvidentlyFeature.name}
 *           name: Variation1
 *           variation: Variation1
 *       scheduledSplitsConfig:
 *         steps:
 *           - groupWeights:
 *               Variation1: 0
 *             startTime: 2024-01-07 01:43:59+00:00
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With multiple groups
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.evidently.Launch("example", {
 *     name: "example",
 *     project: exampleAwsEvidentlyProject.name,
 *     groups: [
 *         {
 *             feature: exampleAwsEvidentlyFeature.name,
 *             name: "Variation1",
 *             variation: "Variation1",
 *             description: "first-group",
 *         },
 *         {
 *             feature: exampleAwsEvidentlyFeature.name,
 *             name: "Variation2",
 *             variation: "Variation2",
 *             description: "second-group",
 *         },
 *     ],
 *     scheduledSplitsConfig: {
 *         steps: [{
 *             groupWeights: {
 *                 Variation1: 0,
 *                 Variation2: 0,
 *             },
 *             startTime: "2024-01-07 01:43:59+00:00",
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.evidently.Launch("example",
 *     name="example",
 *     project=example_aws_evidently_project["name"],
 *     groups=[
 *         {
 *             "feature": example_aws_evidently_feature["name"],
 *             "name": "Variation1",
 *             "variation": "Variation1",
 *             "description": "first-group",
 *         },
 *         {
 *             "feature": example_aws_evidently_feature["name"],
 *             "name": "Variation2",
 *             "variation": "Variation2",
 *             "description": "second-group",
 *         },
 *     ],
 *     scheduled_splits_config={
 *         "steps": [{
 *             "group_weights": {
 *                 "variation1": 0,
 *                 "variation2": 0,
 *             },
 *             "start_time": "2024-01-07 01:43:59+00:00",
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Evidently.Launch("example", new()
 *     {
 *         Name = "example",
 *         Project = exampleAwsEvidentlyProject.Name,
 *         Groups = new[]
 *         {
 *             new Aws.Evidently.Inputs.LaunchGroupArgs
 *             {
 *                 Feature = exampleAwsEvidentlyFeature.Name,
 *                 Name = "Variation1",
 *                 Variation = "Variation1",
 *                 Description = "first-group",
 *             },
 *             new Aws.Evidently.Inputs.LaunchGroupArgs
 *             {
 *                 Feature = exampleAwsEvidentlyFeature.Name,
 *                 Name = "Variation2",
 *                 Variation = "Variation2",
 *                 Description = "second-group",
 *             },
 *         },
 *         ScheduledSplitsConfig = new Aws.Evidently.Inputs.LaunchScheduledSplitsConfigArgs
 *         {
 *             Steps = new[]
 *             {
 *                 new Aws.Evidently.Inputs.LaunchScheduledSplitsConfigStepArgs
 *                 {
 *                     GroupWeights =
 *                     {
 *                         { "Variation1", 0 },
 *                         { "Variation2", 0 },
 *                     },
 *                     StartTime = "2024-01-07 01:43:59+00:00",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/evidently"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := evidently.NewLaunch(ctx, "example", &evidently.LaunchArgs{
 * 			Name:    pulumi.String("example"),
 * 			Project: pulumi.Any(exampleAwsEvidentlyProject.Name),
 * 			Groups: evidently.LaunchGroupArray{
 * 				&evidently.LaunchGroupArgs{
 * 					Feature:     pulumi.Any(exampleAwsEvidentlyFeature.Name),
 * 					Name:        pulumi.String("Variation1"),
 * 					Variation:   pulumi.String("Variation1"),
 * 					Description: pulumi.String("first-group"),
 * 				},
 * 				&evidently.LaunchGroupArgs{
 * 					Feature:     pulumi.Any(exampleAwsEvidentlyFeature.Name),
 * 					Name:        pulumi.String("Variation2"),
 * 					Variation:   pulumi.String("Variation2"),
 * 					Description: pulumi.String("second-group"),
 * 				},
 * 			},
 * 			ScheduledSplitsConfig: &evidently.LaunchScheduledSplitsConfigArgs{
 * 				Steps: evidently.LaunchScheduledSplitsConfigStepArray{
 * 					&evidently.LaunchScheduledSplitsConfigStepArgs{
 * 						GroupWeights: pulumi.IntMap{
 * 							"Variation1": pulumi.Int(0),
 * 							"Variation2": pulumi.Int(0),
 * 						},
 * 						StartTime: pulumi.String("2024-01-07 01:43:59+00:00"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Launch;
 * import com.pulumi.aws.evidently.LaunchArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchGroupArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Launch("example", LaunchArgs.builder()
 *             .name("example")
 *             .project(exampleAwsEvidentlyProject.name())
 *             .groups(
 *                 LaunchGroupArgs.builder()
 *                     .feature(exampleAwsEvidentlyFeature.name())
 *                     .name("Variation1")
 *                     .variation("Variation1")
 *                     .description("first-group")
 *                     .build(),
 *                 LaunchGroupArgs.builder()
 *                     .feature(exampleAwsEvidentlyFeature.name())
 *                     .name("Variation2")
 *                     .variation("Variation2")
 *                     .description("second-group")
 *                     .build())
 *             .scheduledSplitsConfig(LaunchScheduledSplitsConfigArgs.builder()
 *                 .steps(LaunchScheduledSplitsConfigStepArgs.builder()
 *                     .groupWeights(Map.ofEntries(
 *                         Map.entry("Variation1", 0),
 *                         Map.entry("Variation2", 0)
 *                     ))
 *                     .startTime("2024-01-07 01:43:59+00:00")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:evidently:Launch
 *     properties:
 *       name: example
 *       project: ${exampleAwsEvidentlyProject.name}
 *       groups:
 *         - feature: ${exampleAwsEvidentlyFeature.name}
 *           name: Variation1
 *           variation: Variation1
 *           description: first-group
 *         - feature: ${exampleAwsEvidentlyFeature.name}
 *           name: Variation2
 *           variation: Variation2
 *           description: second-group
 *       scheduledSplitsConfig:
 *         steps:
 *           - groupWeights:
 *               Variation1: 0
 *               Variation2: 0
 *             startTime: 2024-01-07 01:43:59+00:00
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With metric_monitors
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.evidently.Launch("example", {
 *     name: "example",
 *     project: exampleAwsEvidentlyProject.name,
 *     groups: [{
 *         feature: exampleAwsEvidentlyFeature.name,
 *         name: "Variation1",
 *         variation: "Variation1",
 *     }],
 *     metricMonitors: [
 *         {
 *             metricDefinition: {
 *                 entityIdKey: "entity_id_key1",
 *                 eventPattern: "{\"Price\":[{\"numeric\":[\">\",11,\"<=\",22]}]}",
 *                 name: "name1",
 *                 unitLabel: "unit_label1",
 *                 valueKey: "value_key1",
 *             },
 *         },
 *         {
 *             metricDefinition: {
 *                 entityIdKey: "entity_id_key2",
 *                 eventPattern: "{\"Price\":[{\"numeric\":[\">\",9,\"<=\",19]}]}",
 *                 name: "name2",
 *                 unitLabel: "unit_label2",
 *                 valueKey: "value_key2",
 *             },
 *         },
 *     ],
 *     scheduledSplitsConfig: {
 *         steps: [{
 *             groupWeights: {
 *                 Variation1: 0,
 *             },
 *             startTime: "2024-01-07 01:43:59+00:00",
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.evidently.Launch("example",
 *     name="example",
 *     project=example_aws_evidently_project["name"],
 *     groups=[{
 *         "feature": example_aws_evidently_feature["name"],
 *         "name": "Variation1",
 *         "variation": "Variation1",
 *     }],
 *     metric_monitors=[
 *         {
 *             "metric_definition": {
 *                 "entity_id_key": "entity_id_key1",
 *                 "event_pattern": "{\"Price\":[{\"numeric\":[\">\",11,\"<=\",22]}]}",
 *                 "name": "name1",
 *                 "unit_label": "unit_label1",
 *                 "value_key": "value_key1",
 *             },
 *         },
 *         {
 *             "metric_definition": {
 *                 "entity_id_key": "entity_id_key2",
 *                 "event_pattern": "{\"Price\":[{\"numeric\":[\">\",9,\"<=\",19]}]}",
 *                 "name": "name2",
 *                 "unit_label": "unit_label2",
 *                 "value_key": "value_key2",
 *             },
 *         },
 *     ],
 *     scheduled_splits_config={
 *         "steps": [{
 *             "group_weights": {
 *                 "variation1": 0,
 *             },
 *             "start_time": "2024-01-07 01:43:59+00:00",
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Evidently.Launch("example", new()
 *     {
 *         Name = "example",
 *         Project = exampleAwsEvidentlyProject.Name,
 *         Groups = new[]
 *         {
 *             new Aws.Evidently.Inputs.LaunchGroupArgs
 *             {
 *                 Feature = exampleAwsEvidentlyFeature.Name,
 *                 Name = "Variation1",
 *                 Variation = "Variation1",
 *             },
 *         },
 *         MetricMonitors = new[]
 *         {
 *             new Aws.Evidently.Inputs.LaunchMetricMonitorArgs
 *             {
 *                 MetricDefinition = new Aws.Evidently.Inputs.LaunchMetricMonitorMetricDefinitionArgs
 *                 {
 *                     EntityIdKey = "entity_id_key1",
 *                     EventPattern = "{\"Price\":[{\"numeric\":[\">\",11,\"<=\",22]}]}",
 *                     Name = "name1",
 *                     UnitLabel = "unit_label1",
 *                     ValueKey = "value_key1",
 *                 },
 *             },
 *             new Aws.Evidently.Inputs.LaunchMetricMonitorArgs
 *             {
 *                 MetricDefinition = new Aws.Evidently.Inputs.LaunchMetricMonitorMetricDefinitionArgs
 *                 {
 *                     EntityIdKey = "entity_id_key2",
 *                     EventPattern = "{\"Price\":[{\"numeric\":[\">\",9,\"<=\",19]}]}",
 *                     Name = "name2",
 *                     UnitLabel = "unit_label2",
 *                     ValueKey = "value_key2",
 *                 },
 *             },
 *         },
 *         ScheduledSplitsConfig = new Aws.Evidently.Inputs.LaunchScheduledSplitsConfigArgs
 *         {
 *             Steps = new[]
 *             {
 *                 new Aws.Evidently.Inputs.LaunchScheduledSplitsConfigStepArgs
 *                 {
 *                     GroupWeights =
 *                     {
 *                         { "Variation1", 0 },
 *                     },
 *                     StartTime = "2024-01-07 01:43:59+00:00",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/evidently"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := evidently.NewLaunch(ctx, "example", &evidently.LaunchArgs{
 * 			Name:    pulumi.String("example"),
 * 			Project: pulumi.Any(exampleAwsEvidentlyProject.Name),
 * 			Groups: evidently.LaunchGroupArray{
 * 				&evidently.LaunchGroupArgs{
 * 					Feature:   pulumi.Any(exampleAwsEvidentlyFeature.Name),
 * 					Name:      pulumi.String("Variation1"),
 * 					Variation: pulumi.String("Variation1"),
 * 				},
 * 			},
 * 			MetricMonitors: evidently.LaunchMetricMonitorArray{
 * 				&evidently.LaunchMetricMonitorArgs{
 * 					MetricDefinition: &evidently.LaunchMetricMonitorMetricDefinitionArgs{
 * 						EntityIdKey:  pulumi.String("entity_id_key1"),
 * 						EventPattern: pulumi.String("{\"Price\":[{\"numeric\":[\">\",11,\"<=\",22]}]}"),
 * 						Name:         pulumi.String("name1"),
 * 						UnitLabel:    pulumi.String("unit_label1"),
 * 						ValueKey:     pulumi.String("value_key1"),
 * 					},
 * 				},
 * 				&evidently.LaunchMetricMonitorArgs{
 * 					MetricDefinition: &evidently.LaunchMetricMonitorMetricDefinitionArgs{
 * 						EntityIdKey:  pulumi.String("entity_id_key2"),
 * 						EventPattern: pulumi.String("{\"Price\":[{\"numeric\":[\">\",9,\"<=\",19]}]}"),
 * 						Name:         pulumi.String("name2"),
 * 						UnitLabel:    pulumi.String("unit_label2"),
 * 						ValueKey:     pulumi.String("value_key2"),
 * 					},
 * 				},
 * 			},
 * 			ScheduledSplitsConfig: &evidently.LaunchScheduledSplitsConfigArgs{
 * 				Steps: evidently.LaunchScheduledSplitsConfigStepArray{
 * 					&evidently.LaunchScheduledSplitsConfigStepArgs{
 * 						GroupWeights: pulumi.IntMap{
 * 							"Variation1": pulumi.Int(0),
 * 						},
 * 						StartTime: pulumi.String("2024-01-07 01:43:59+00:00"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Launch;
 * import com.pulumi.aws.evidently.LaunchArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchGroupArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchMetricMonitorArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchMetricMonitorMetricDefinitionArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Launch("example", LaunchArgs.builder()
 *             .name("example")
 *             .project(exampleAwsEvidentlyProject.name())
 *             .groups(LaunchGroupArgs.builder()
 *                 .feature(exampleAwsEvidentlyFeature.name())
 *                 .name("Variation1")
 *                 .variation("Variation1")
 *                 .build())
 *             .metricMonitors(
 *                 LaunchMetricMonitorArgs.builder()
 *                     .metricDefinition(LaunchMetricMonitorMetricDefinitionArgs.builder()
 *                         .entityIdKey("entity_id_key1")
 *                         .eventPattern("{\"Price\":[{\"numeric\":[\">\",11,\"<=\",22]}]}")
 *                         .name("name1")
 *                         .unitLabel("unit_label1")
 *                         .valueKey("value_key1")
 *                         .build())
 *                     .build(),
 *                 LaunchMetricMonitorArgs.builder()
 *                     .metricDefinition(LaunchMetricMonitorMetricDefinitionArgs.builder()
 *                         .entityIdKey("entity_id_key2")
 *                         .eventPattern("{\"Price\":[{\"numeric\":[\">\",9,\"<=\",19]}]}")
 *                         .name("name2")
 *                         .unitLabel("unit_label2")
 *                         .valueKey("value_key2")
 *                         .build())
 *                     .build())
 *             .scheduledSplitsConfig(LaunchScheduledSplitsConfigArgs.builder()
 *                 .steps(LaunchScheduledSplitsConfigStepArgs.builder()
 *                     .groupWeights(Map.of("Variation1", 0))
 *                     .startTime("2024-01-07 01:43:59+00:00")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:evidently:Launch
 *     properties:
 *       name: example
 *       project: ${exampleAwsEvidentlyProject.name}
 *       groups:
 *         - feature: ${exampleAwsEvidentlyFeature.name}
 *           name: Variation1
 *           variation: Variation1
 *       metricMonitors:
 *         - metricDefinition:
 *             entityIdKey: entity_id_key1
 *             eventPattern: '{"Price":[{"numeric":[">",11,"<=",22]}]}'
 *             name: name1
 *             unitLabel: unit_label1
 *             valueKey: value_key1
 *         - metricDefinition:
 *             entityIdKey: entity_id_key2
 *             eventPattern: '{"Price":[{"numeric":[">",9,"<=",19]}]}'
 *             name: name2
 *             unitLabel: unit_label2
 *             valueKey: value_key2
 *       scheduledSplitsConfig:
 *         steps:
 *           - groupWeights:
 *               Variation1: 0
 *             startTime: 2024-01-07 01:43:59+00:00
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With randomization_salt
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.evidently.Launch("example", {
 *     name: "example",
 *     project: exampleAwsEvidentlyProject.name,
 *     randomizationSalt: "example randomization salt",
 *     groups: [{
 *         feature: exampleAwsEvidentlyFeature.name,
 *         name: "Variation1",
 *         variation: "Variation1",
 *     }],
 *     scheduledSplitsConfig: {
 *         steps: [{
 *             groupWeights: {
 *                 Variation1: 0,
 *             },
 *             startTime: "2024-01-07 01:43:59+00:00",
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.evidently.Launch("example",
 *     name="example",
 *     project=example_aws_evidently_project["name"],
 *     randomization_salt="example randomization salt",
 *     groups=[{
 *         "feature": example_aws_evidently_feature["name"],
 *         "name": "Variation1",
 *         "variation": "Variation1",
 *     }],
 *     scheduled_splits_config={
 *         "steps": [{
 *             "group_weights": {
 *                 "variation1": 0,
 *             },
 *             "start_time": "2024-01-07 01:43:59+00:00",
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Evidently.Launch("example", new()
 *     {
 *         Name = "example",
 *         Project = exampleAwsEvidentlyProject.Name,
 *         RandomizationSalt = "example randomization salt",
 *         Groups = new[]
 *         {
 *             new Aws.Evidently.Inputs.LaunchGroupArgs
 *             {
 *                 Feature = exampleAwsEvidentlyFeature.Name,
 *                 Name = "Variation1",
 *                 Variation = "Variation1",
 *             },
 *         },
 *         ScheduledSplitsConfig = new Aws.Evidently.Inputs.LaunchScheduledSplitsConfigArgs
 *         {
 *             Steps = new[]
 *             {
 *                 new Aws.Evidently.Inputs.LaunchScheduledSplitsConfigStepArgs
 *                 {
 *                     GroupWeights =
 *                     {
 *                         { "Variation1", 0 },
 *                     },
 *                     StartTime = "2024-01-07 01:43:59+00:00",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/evidently"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := evidently.NewLaunch(ctx, "example", &evidently.LaunchArgs{
 * 			Name:              pulumi.String("example"),
 * 			Project:           pulumi.Any(exampleAwsEvidentlyProject.Name),
 * 			RandomizationSalt: pulumi.String("example randomization salt"),
 * 			Groups: evidently.LaunchGroupArray{
 * 				&evidently.LaunchGroupArgs{
 * 					Feature:   pulumi.Any(exampleAwsEvidentlyFeature.Name),
 * 					Name:      pulumi.String("Variation1"),
 * 					Variation: pulumi.String("Variation1"),
 * 				},
 * 			},
 * 			ScheduledSplitsConfig: &evidently.LaunchScheduledSplitsConfigArgs{
 * 				Steps: evidently.LaunchScheduledSplitsConfigStepArray{
 * 					&evidently.LaunchScheduledSplitsConfigStepArgs{
 * 						GroupWeights: pulumi.IntMap{
 * 							"Variation1": pulumi.Int(0),
 * 						},
 * 						StartTime: pulumi.String("2024-01-07 01:43:59+00:00"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Launch;
 * import com.pulumi.aws.evidently.LaunchArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchGroupArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Launch("example", LaunchArgs.builder()
 *             .name("example")
 *             .project(exampleAwsEvidentlyProject.name())
 *             .randomizationSalt("example randomization salt")
 *             .groups(LaunchGroupArgs.builder()
 *                 .feature(exampleAwsEvidentlyFeature.name())
 *                 .name("Variation1")
 *                 .variation("Variation1")
 *                 .build())
 *             .scheduledSplitsConfig(LaunchScheduledSplitsConfigArgs.builder()
 *                 .steps(LaunchScheduledSplitsConfigStepArgs.builder()
 *                     .groupWeights(Map.of("Variation1", 0))
 *                     .startTime("2024-01-07 01:43:59+00:00")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:evidently:Launch
 *     properties:
 *       name: example
 *       project: ${exampleAwsEvidentlyProject.name}
 *       randomizationSalt: example randomization salt
 *       groups:
 *         - feature: ${exampleAwsEvidentlyFeature.name}
 *           name: Variation1
 *           variation: Variation1
 *       scheduledSplitsConfig:
 *         steps:
 *           - groupWeights:
 *               Variation1: 0
 *             startTime: 2024-01-07 01:43:59+00:00
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With multiple steps
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.evidently.Launch("example", {
 *     name: "example",
 *     project: exampleAwsEvidentlyProject.name,
 *     groups: [
 *         {
 *             feature: exampleAwsEvidentlyFeature.name,
 *             name: "Variation1",
 *             variation: "Variation1",
 *         },
 *         {
 *             feature: exampleAwsEvidentlyFeature.name,
 *             name: "Variation2",
 *             variation: "Variation2",
 *         },
 *     ],
 *     scheduledSplitsConfig: {
 *         steps: [
 *             {
 *                 groupWeights: {
 *                     Variation1: 15,
 *                     Variation2: 10,
 *                 },
 *                 startTime: "2024-01-07 01:43:59+00:00",
 *             },
 *             {
 *                 groupWeights: {
 *                     Variation1: 20,
 *                     Variation2: 25,
 *                 },
 *                 startTime: "2024-01-08 01:43:59+00:00",
 *             },
 *         ],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.evidently.Launch("example",
 *     name="example",
 *     project=example_aws_evidently_project["name"],
 *     groups=[
 *         {
 *             "feature": example_aws_evidently_feature["name"],
 *             "name": "Variation1",
 *             "variation": "Variation1",
 *         },
 *         {
 *             "feature": example_aws_evidently_feature["name"],
 *             "name": "Variation2",
 *             "variation": "Variation2",
 *         },
 *     ],
 *     scheduled_splits_config={
 *         "steps": [
 *             {
 *                 "group_weights": {
 *                     "variation1": 15,
 *                     "variation2": 10,
 *                 },
 *                 "start_time": "2024-01-07 01:43:59+00:00",
 *             },
 *             {
 *                 "group_weights": {
 *                     "variation1": 20,
 *                     "variation2": 25,
 *                 },
 *                 "start_time": "2024-01-08 01:43:59+00:00",
 *             },
 *         ],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Evidently.Launch("example", new()
 *     {
 *         Name = "example",
 *         Project = exampleAwsEvidentlyProject.Name,
 *         Groups = new[]
 *         {
 *             new Aws.Evidently.Inputs.LaunchGroupArgs
 *             {
 *                 Feature = exampleAwsEvidentlyFeature.Name,
 *                 Name = "Variation1",
 *                 Variation = "Variation1",
 *             },
 *             new Aws.Evidently.Inputs.LaunchGroupArgs
 *             {
 *                 Feature = exampleAwsEvidentlyFeature.Name,
 *                 Name = "Variation2",
 *                 Variation = "Variation2",
 *             },
 *         },
 *         ScheduledSplitsConfig = new Aws.Evidently.Inputs.LaunchScheduledSplitsConfigArgs
 *         {
 *             Steps = new[]
 *             {
 *                 new Aws.Evidently.Inputs.LaunchScheduledSplitsConfigStepArgs
 *                 {
 *                     GroupWeights =
 *                     {
 *                         { "Variation1", 15 },
 *                         { "Variation2", 10 },
 *                     },
 *                     StartTime = "2024-01-07 01:43:59+00:00",
 *                 },
 *                 new Aws.Evidently.Inputs.LaunchScheduledSplitsConfigStepArgs
 *                 {
 *                     GroupWeights =
 *                     {
 *                         { "Variation1", 20 },
 *                         { "Variation2", 25 },
 *                     },
 *                     StartTime = "2024-01-08 01:43:59+00:00",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/evidently"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := evidently.NewLaunch(ctx, "example", &evidently.LaunchArgs{
 * 			Name:    pulumi.String("example"),
 * 			Project: pulumi.Any(exampleAwsEvidentlyProject.Name),
 * 			Groups: evidently.LaunchGroupArray{
 * 				&evidently.LaunchGroupArgs{
 * 					Feature:   pulumi.Any(exampleAwsEvidentlyFeature.Name),
 * 					Name:      pulumi.String("Variation1"),
 * 					Variation: pulumi.String("Variation1"),
 * 				},
 * 				&evidently.LaunchGroupArgs{
 * 					Feature:   pulumi.Any(exampleAwsEvidentlyFeature.Name),
 * 					Name:      pulumi.String("Variation2"),
 * 					Variation: pulumi.String("Variation2"),
 * 				},
 * 			},
 * 			ScheduledSplitsConfig: &evidently.LaunchScheduledSplitsConfigArgs{
 * 				Steps: evidently.LaunchScheduledSplitsConfigStepArray{
 * 					&evidently.LaunchScheduledSplitsConfigStepArgs{
 * 						GroupWeights: pulumi.IntMap{
 * 							"Variation1": pulumi.Int(15),
 * 							"Variation2": pulumi.Int(10),
 * 						},
 * 						StartTime: pulumi.String("2024-01-07 01:43:59+00:00"),
 * 					},
 * 					&evidently.LaunchScheduledSplitsConfigStepArgs{
 * 						GroupWeights: pulumi.IntMap{
 * 							"Variation1": pulumi.Int(20),
 * 							"Variation2": pulumi.Int(25),
 * 						},
 * 						StartTime: pulumi.String("2024-01-08 01:43:59+00:00"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Launch;
 * import com.pulumi.aws.evidently.LaunchArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchGroupArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Launch("example", LaunchArgs.builder()
 *             .name("example")
 *             .project(exampleAwsEvidentlyProject.name())
 *             .groups(
 *                 LaunchGroupArgs.builder()
 *                     .feature(exampleAwsEvidentlyFeature.name())
 *                     .name("Variation1")
 *                     .variation("Variation1")
 *                     .build(),
 *                 LaunchGroupArgs.builder()
 *                     .feature(exampleAwsEvidentlyFeature.name())
 *                     .name("Variation2")
 *                     .variation("Variation2")
 *                     .build())
 *             .scheduledSplitsConfig(LaunchScheduledSplitsConfigArgs.builder()
 *                 .steps(
 *                     LaunchScheduledSplitsConfigStepArgs.builder()
 *                         .groupWeights(Map.ofEntries(
 *                             Map.entry("Variation1", 15),
 *                             Map.entry("Variation2", 10)
 *                         ))
 *                         .startTime("2024-01-07 01:43:59+00:00")
 *                         .build(),
 *                     LaunchScheduledSplitsConfigStepArgs.builder()
 *                         .groupWeights(Map.ofEntries(
 *                             Map.entry("Variation1", 20),
 *                             Map.entry("Variation2", 25)
 *                         ))
 *                         .startTime("2024-01-08 01:43:59+00:00")
 *                         .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:evidently:Launch
 *     properties:
 *       name: example
 *       project: ${exampleAwsEvidentlyProject.name}
 *       groups:
 *         - feature: ${exampleAwsEvidentlyFeature.name}
 *           name: Variation1
 *           variation: Variation1
 *         - feature: ${exampleAwsEvidentlyFeature.name}
 *           name: Variation2
 *           variation: Variation2
 *       scheduledSplitsConfig:
 *         steps:
 *           - groupWeights:
 *               Variation1: 15
 *               Variation2: 10
 *             startTime: 2024-01-07 01:43:59+00:00
 *           - groupWeights:
 *               Variation1: 20
 *               Variation2: 25
 *             startTime: 2024-01-08 01:43:59+00:00
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With segment overrides
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.evidently.Launch("example", {
 *     name: "example",
 *     project: exampleAwsEvidentlyProject.name,
 *     groups: [
 *         {
 *             feature: exampleAwsEvidentlyFeature.name,
 *             name: "Variation1",
 *             variation: "Variation1",
 *         },
 *         {
 *             feature: exampleAwsEvidentlyFeature.name,
 *             name: "Variation2",
 *             variation: "Variation2",
 *         },
 *     ],
 *     scheduledSplitsConfig: {
 *         steps: [{
 *             groupWeights: {
 *                 Variation1: 0,
 *                 Variation2: 0,
 *             },
 *             segmentOverrides: [
 *                 {
 *                     evaluationOrder: 1,
 *                     segment: exampleAwsEvidentlySegment.name,
 *                     weights: {
 *                         Variation2: 10000,
 *                     },
 *                 },
 *                 {
 *                     evaluationOrder: 2,
 *                     segment: exampleAwsEvidentlySegment.name,
 *                     weights: {
 *                         Variation1: 40000,
 *                         Variation2: 30000,
 *                     },
 *                 },
 *             ],
 *             startTime: "2024-01-08 01:43:59+00:00",
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.evidently.Launch("example",
 *     name="example",
 *     project=example_aws_evidently_project["name"],
 *     groups=[
 *         {
 *             "feature": example_aws_evidently_feature["name"],
 *             "name": "Variation1",
 *             "variation": "Variation1",
 *         },
 *         {
 *             "feature": example_aws_evidently_feature["name"],
 *             "name": "Variation2",
 *             "variation": "Variation2",
 *         },
 *     ],
 *     scheduled_splits_config={
 *         "steps": [{
 *             "group_weights": {
 *                 "variation1": 0,
 *                 "variation2": 0,
 *             },
 *             "segment_overrides": [
 *                 {
 *                     "evaluation_order": 1,
 *                     "segment": example_aws_evidently_segment["name"],
 *                     "weights": {
 *                         "variation2": 10000,
 *                     },
 *                 },
 *                 {
 *                     "evaluation_order": 2,
 *                     "segment": example_aws_evidently_segment["name"],
 *                     "weights": {
 *                         "variation1": 40000,
 *                         "variation2": 30000,
 *                     },
 *                 },
 *             ],
 *             "start_time": "2024-01-08 01:43:59+00:00",
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Evidently.Launch("example", new()
 *     {
 *         Name = "example",
 *         Project = exampleAwsEvidentlyProject.Name,
 *         Groups = new[]
 *         {
 *             new Aws.Evidently.Inputs.LaunchGroupArgs
 *             {
 *                 Feature = exampleAwsEvidentlyFeature.Name,
 *                 Name = "Variation1",
 *                 Variation = "Variation1",
 *             },
 *             new Aws.Evidently.Inputs.LaunchGroupArgs
 *             {
 *                 Feature = exampleAwsEvidentlyFeature.Name,
 *                 Name = "Variation2",
 *                 Variation = "Variation2",
 *             },
 *         },
 *         ScheduledSplitsConfig = new Aws.Evidently.Inputs.LaunchScheduledSplitsConfigArgs
 *         {
 *             Steps = new[]
 *             {
 *                 new Aws.Evidently.Inputs.LaunchScheduledSplitsConfigStepArgs
 *                 {
 *                     GroupWeights =
 *                     {
 *                         { "Variation1", 0 },
 *                         { "Variation2", 0 },
 *                     },
 *                     SegmentOverrides = new[]
 *                     {
 *                         new Aws.Evidently.Inputs.LaunchScheduledSplitsConfigStepSegmentOverrideArgs
 *                         {
 *                             EvaluationOrder = 1,
 *                             Segment = exampleAwsEvidentlySegment.Name,
 *                             Weights =
 *                             {
 *                                 { "Variation2", 10000 },
 *                             },
 *                         },
 *                         new Aws.Evidently.Inputs.LaunchScheduledSplitsConfigStepSegmentOverrideArgs
 *                         {
 *                             EvaluationOrder = 2,
 *                             Segment = exampleAwsEvidentlySegment.Name,
 *                             Weights =
 *                             {
 *                                 { "Variation1", 40000 },
 *                                 { "Variation2", 30000 },
 *                             },
 *                         },
 *                     },
 *                     StartTime = "2024-01-08 01:43:59+00:00",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/evidently"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := evidently.NewLaunch(ctx, "example", &evidently.LaunchArgs{
 * 			Name:    pulumi.String("example"),
 * 			Project: pulumi.Any(exampleAwsEvidentlyProject.Name),
 * 			Groups: evidently.LaunchGroupArray{
 * 				&evidently.LaunchGroupArgs{
 * 					Feature:   pulumi.Any(exampleAwsEvidentlyFeature.Name),
 * 					Name:      pulumi.String("Variation1"),
 * 					Variation: pulumi.String("Variation1"),
 * 				},
 * 				&evidently.LaunchGroupArgs{
 * 					Feature:   pulumi.Any(exampleAwsEvidentlyFeature.Name),
 * 					Name:      pulumi.String("Variation2"),
 * 					Variation: pulumi.String("Variation2"),
 * 				},
 * 			},
 * 			ScheduledSplitsConfig: &evidently.LaunchScheduledSplitsConfigArgs{
 * 				Steps: evidently.LaunchScheduledSplitsConfigStepArray{
 * 					&evidently.LaunchScheduledSplitsConfigStepArgs{
 * 						GroupWeights: pulumi.IntMap{
 * 							"Variation1": pulumi.Int(0),
 * 							"Variation2": pulumi.Int(0),
 * 						},
 * 						SegmentOverrides: evidently.LaunchScheduledSplitsConfigStepSegmentOverrideArray{
 * 							&evidently.LaunchScheduledSplitsConfigStepSegmentOverrideArgs{
 * 								EvaluationOrder: pulumi.Int(1),
 * 								Segment:         pulumi.Any(exampleAwsEvidentlySegment.Name),
 * 								Weights: pulumi.IntMap{
 * 									"Variation2": pulumi.Int(10000),
 * 								},
 * 							},
 * 							&evidently.LaunchScheduledSplitsConfigStepSegmentOverrideArgs{
 * 								EvaluationOrder: pulumi.Int(2),
 * 								Segment:         pulumi.Any(exampleAwsEvidentlySegment.Name),
 * 								Weights: pulumi.IntMap{
 * 									"Variation1": pulumi.Int(40000),
 * 									"Variation2": pulumi.Int(30000),
 * 								},
 * 							},
 * 						},
 * 						StartTime: pulumi.String("2024-01-08 01:43:59+00:00"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Launch;
 * import com.pulumi.aws.evidently.LaunchArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchGroupArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Launch("example", LaunchArgs.builder()
 *             .name("example")
 *             .project(exampleAwsEvidentlyProject.name())
 *             .groups(
 *                 LaunchGroupArgs.builder()
 *                     .feature(exampleAwsEvidentlyFeature.name())
 *                     .name("Variation1")
 *                     .variation("Variation1")
 *                     .build(),
 *                 LaunchGroupArgs.builder()
 *                     .feature(exampleAwsEvidentlyFeature.name())
 *                     .name("Variation2")
 *                     .variation("Variation2")
 *                     .build())
 *             .scheduledSplitsConfig(LaunchScheduledSplitsConfigArgs.builder()
 *                 .steps(LaunchScheduledSplitsConfigStepArgs.builder()
 *                     .groupWeights(Map.ofEntries(
 *                         Map.entry("Variation1", 0),
 *                         Map.entry("Variation2", 0)
 *                     ))
 *                     .segmentOverrides(
 *                         LaunchScheduledSplitsConfigStepSegmentOverrideArgs.builder()
 *                             .evaluationOrder(1)
 *                             .segment(exampleAwsEvidentlySegment.name())
 *                             .weights(Map.of("Variation2", 10000))
 *                             .build(),
 *                         LaunchScheduledSplitsConfigStepSegmentOverrideArgs.builder()
 *                             .evaluationOrder(2)
 *                             .segment(exampleAwsEvidentlySegment.name())
 *                             .weights(Map.ofEntries(
 *                                 Map.entry("Variation1", 40000),
 *                                 Map.entry("Variation2", 30000)
 *                             ))
 *                             .build())
 *                     .startTime("2024-01-08 01:43:59+00:00")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:evidently:Launch
 *     properties:
 *       name: example
 *       project: ${exampleAwsEvidentlyProject.name}
 *       groups:
 *         - feature: ${exampleAwsEvidentlyFeature.name}
 *           name: Variation1
 *           variation: Variation1
 *         - feature: ${exampleAwsEvidentlyFeature.name}
 *           name: Variation2
 *           variation: Variation2
 *       scheduledSplitsConfig:
 *         steps:
 *           - groupWeights:
 *               Variation1: 0
 *               Variation2: 0
 *             segmentOverrides:
 *               - evaluationOrder: 1
 *                 segment: ${exampleAwsEvidentlySegment.name}
 *                 weights:
 *                   Variation2: 10000
 *               - evaluationOrder: 2
 *                 segment: ${exampleAwsEvidentlySegment.name}
 *                 weights:
 *                   Variation1: 40000
 *                   Variation2: 30000
 *             startTime: 2024-01-08 01:43:59+00:00
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Import using the `name` of the launch and `arn` of the project separated by a `:`:
 * __Using `pulumi import` to import__ CloudWatch Evidently Launch using the `name` of the launch and `name` of the project or `arn` of the hosting CloudWatch Evidently Project separated by a `:`. For example:
 * Import using the `name` of the launch and `name` of the project separated by a `:`:
 * ```sh
 * $ pulumi import aws:evidently/launch:Launch example exampleLaunchName:exampleProjectName
 * ```
 * Import using the `name` of the launch and `arn` of the project separated by a `:`:
 * ```sh
 * $ pulumi import aws:evidently/launch:Launch example exampleLaunchName:arn:aws:evidently:us-east-1:123456789012:project/exampleProjectName
 * ```
 */
public class Launch internal constructor(
    override val javaResource: com.pulumi.aws.evidently.Launch,
) : KotlinCustomResource(javaResource, LaunchMapper) {
    /**
     * The ARN of the launch.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The date and time that the launch is created.
     */
    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    /**
     * Specifies the description of the launch.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A block that contains information about the start and end times of the launch. Detailed below
     */
    public val executions: Output<List<LaunchExecution>>
        get() = javaResource.executions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    launchExecutionToKotlin(args0)
                })
            })
        })

    /**
     * One or up to five blocks that contain the feature and variations that are to be used for the launch. Detailed below.
     */
    public val groups: Output<List<LaunchGroup>>
        get() = javaResource.groups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    launchGroupToKotlin(args0)
                })
            })
        })

    /**
     * The date and time that the launch was most recently updated.
     */
    public val lastUpdatedTime: Output<String>
        get() = javaResource.lastUpdatedTime().applyValue({ args0 -> args0 })

    /**
     * One or up to three blocks that define the metrics that will be used to monitor the launch performance. Detailed below.
     */
    public val metricMonitors: Output<List<LaunchMetricMonitor>>?
        get() = javaResource.metricMonitors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        launchMetricMonitorToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The name for the new launch. Minimum length of `1`. Maximum length of `127`.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The name or ARN of the project that is to contain the new launch.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and randomizationSalt. If you omit randomizationSalt, Evidently uses the launch name as the randomizationSalt.
     */
    public val randomizationSalt: Output<String>?
        get() = javaResource.randomizationSalt().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A block that defines the traffic allocation percentages among the feature variations during each step of the launch. Detailed below.
     */
    public val scheduledSplitsConfig: Output<LaunchScheduledSplitsConfig>?
        get() = javaResource.scheduledSplitsConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> launchScheduledSplitsConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The current state of the launch. Valid values are `CREATED`, `UPDATING`, `RUNNING`, `COMPLETED`, and `CANCELLED`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * If the launch was stopped, this is the string that was entered by the person who stopped the launch, to explain why it was stopped.
     */
    public val statusReason: Output<String>
        get() = javaResource.statusReason().applyValue({ args0 -> args0 })

    /**
     * Tags to apply to the launch. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The type of launch.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object LaunchMapper : ResourceMapper<Launch> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.evidently.Launch::class == javaResource::class

    override fun map(javaResource: Resource): Launch = Launch(
        javaResource as
            com.pulumi.aws.evidently.Launch,
    )
}

/**
 * @see [Launch].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Launch].
 */
public suspend fun launch(name: String, block: suspend LaunchResourceBuilder.() -> Unit): Launch {
    val builder = LaunchResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Launch].
 * @param name The _unique_ name of the resulting resource.
 */
public fun launch(name: String): Launch {
    val builder = LaunchResourceBuilder()
    builder.name(name)
    return builder.build()
}
