@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.evidently.kotlin

import com.pulumi.aws.evidently.LaunchArgs.builder
import com.pulumi.aws.evidently.kotlin.inputs.LaunchGroupArgs
import com.pulumi.aws.evidently.kotlin.inputs.LaunchGroupArgsBuilder
import com.pulumi.aws.evidently.kotlin.inputs.LaunchMetricMonitorArgs
import com.pulumi.aws.evidently.kotlin.inputs.LaunchMetricMonitorArgsBuilder
import com.pulumi.aws.evidently.kotlin.inputs.LaunchScheduledSplitsConfigArgs
import com.pulumi.aws.evidently.kotlin.inputs.LaunchScheduledSplitsConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CloudWatch Evidently Launch resource.
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.evidently.Launch("example", {
 *     name: "example",
 *     project: exampleAwsEvidentlyProject.name,
 *     groups: [{
 *         feature: exampleAwsEvidentlyFeature.name,
 *         name: "Variation1",
 *         variation: "Variation1",
 *     }],
 *     scheduledSplitsConfig: {
 *         steps: [{
 *             groupWeights: {
 *                 Variation1: 0,
 *             },
 *             startTime: "2024-01-07 01:43:59+00:00",
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.evidently.Launch("example",
 *     name="example",
 *     project=example_aws_evidently_project["name"],
 *     groups=[{
 *         "feature": example_aws_evidently_feature["name"],
 *         "name": "Variation1",
 *         "variation": "Variation1",
 *     }],
 *     scheduled_splits_config={
 *         "steps": [{
 *             "group_weights": {
 *                 "variation1": 0,
 *             },
 *             "start_time": "2024-01-07 01:43:59+00:00",
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Evidently.Launch("example", new()
 *     {
 *         Name = "example",
 *         Project = exampleAwsEvidentlyProject.Name,
 *         Groups = new[]
 *         {
 *             new Aws.Evidently.Inputs.LaunchGroupArgs
 *             {
 *                 Feature = exampleAwsEvidentlyFeature.Name,
 *                 Name = "Variation1",
 *                 Variation = "Variation1",
 *             },
 *         },
 *         ScheduledSplitsConfig = new Aws.Evidently.Inputs.LaunchScheduledSplitsConfigArgs
 *         {
 *             Steps = new[]
 *             {
 *                 new Aws.Evidently.Inputs.LaunchScheduledSplitsConfigStepArgs
 *                 {
 *                     GroupWeights =
 *                     {
 *                         { "Variation1", 0 },
 *                     },
 *                     StartTime = "2024-01-07 01:43:59+00:00",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/evidently"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := evidently.NewLaunch(ctx, "example", &evidently.LaunchArgs{
 * 			Name:    pulumi.String("example"),
 * 			Project: pulumi.Any(exampleAwsEvidentlyProject.Name),
 * 			Groups: evidently.LaunchGroupArray{
 * 				&evidently.LaunchGroupArgs{
 * 					Feature:   pulumi.Any(exampleAwsEvidentlyFeature.Name),
 * 					Name:      pulumi.String("Variation1"),
 * 					Variation: pulumi.String("Variation1"),
 * 				},
 * 			},
 * 			ScheduledSplitsConfig: &evidently.LaunchScheduledSplitsConfigArgs{
 * 				Steps: evidently.LaunchScheduledSplitsConfigStepArray{
 * 					&evidently.LaunchScheduledSplitsConfigStepArgs{
 * 						GroupWeights: pulumi.IntMap{
 * 							"Variation1": pulumi.Int(0),
 * 						},
 * 						StartTime: pulumi.String("2024-01-07 01:43:59+00:00"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Launch;
 * import com.pulumi.aws.evidently.LaunchArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchGroupArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Launch("example", LaunchArgs.builder()
 *             .name("example")
 *             .project(exampleAwsEvidentlyProject.name())
 *             .groups(LaunchGroupArgs.builder()
 *                 .feature(exampleAwsEvidentlyFeature.name())
 *                 .name("Variation1")
 *                 .variation("Variation1")
 *                 .build())
 *             .scheduledSplitsConfig(LaunchScheduledSplitsConfigArgs.builder()
 *                 .steps(LaunchScheduledSplitsConfigStepArgs.builder()
 *                     .groupWeights(Map.of("Variation1", 0))
 *                     .startTime("2024-01-07 01:43:59+00:00")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:evidently:Launch
 *     properties:
 *       name: example
 *       project: ${exampleAwsEvidentlyProject.name}
 *       groups:
 *         - feature: ${exampleAwsEvidentlyFeature.name}
 *           name: Variation1
 *           variation: Variation1
 *       scheduledSplitsConfig:
 *         steps:
 *           - groupWeights:
 *               Variation1: 0
 *             startTime: 2024-01-07 01:43:59+00:00
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With description
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.evidently.Launch("example", {
 *     name: "example",
 *     project: exampleAwsEvidentlyProject.name,
 *     description: "example description",
 *     groups: [{
 *         feature: exampleAwsEvidentlyFeature.name,
 *         name: "Variation1",
 *         variation: "Variation1",
 *     }],
 *     scheduledSplitsConfig: {
 *         steps: [{
 *             groupWeights: {
 *                 Variation1: 0,
 *             },
 *             startTime: "2024-01-07 01:43:59+00:00",
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.evidently.Launch("example",
 *     name="example",
 *     project=example_aws_evidently_project["name"],
 *     description="example description",
 *     groups=[{
 *         "feature": example_aws_evidently_feature["name"],
 *         "name": "Variation1",
 *         "variation": "Variation1",
 *     }],
 *     scheduled_splits_config={
 *         "steps": [{
 *             "group_weights": {
 *                 "variation1": 0,
 *             },
 *             "start_time": "2024-01-07 01:43:59+00:00",
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Evidently.Launch("example", new()
 *     {
 *         Name = "example",
 *         Project = exampleAwsEvidentlyProject.Name,
 *         Description = "example description",
 *         Groups = new[]
 *         {
 *             new Aws.Evidently.Inputs.LaunchGroupArgs
 *             {
 *                 Feature = exampleAwsEvidentlyFeature.Name,
 *                 Name = "Variation1",
 *                 Variation = "Variation1",
 *             },
 *         },
 *         ScheduledSplitsConfig = new Aws.Evidently.Inputs.LaunchScheduledSplitsConfigArgs
 *         {
 *             Steps = new[]
 *             {
 *                 new Aws.Evidently.Inputs.LaunchScheduledSplitsConfigStepArgs
 *                 {
 *                     GroupWeights =
 *                     {
 *                         { "Variation1", 0 },
 *                     },
 *                     StartTime = "2024-01-07 01:43:59+00:00",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/evidently"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := evidently.NewLaunch(ctx, "example", &evidently.LaunchArgs{
 * 			Name:        pulumi.String("example"),
 * 			Project:     pulumi.Any(exampleAwsEvidentlyProject.Name),
 * 			Description: pulumi.String("example description"),
 * 			Groups: evidently.LaunchGroupArray{
 * 				&evidently.LaunchGroupArgs{
 * 					Feature:   pulumi.Any(exampleAwsEvidentlyFeature.Name),
 * 					Name:      pulumi.String("Variation1"),
 * 					Variation: pulumi.String("Variation1"),
 * 				},
 * 			},
 * 			ScheduledSplitsConfig: &evidently.LaunchScheduledSplitsConfigArgs{
 * 				Steps: evidently.LaunchScheduledSplitsConfigStepArray{
 * 					&evidently.LaunchScheduledSplitsConfigStepArgs{
 * 						GroupWeights: pulumi.IntMap{
 * 							"Variation1": pulumi.Int(0),
 * 						},
 * 						StartTime: pulumi.String("2024-01-07 01:43:59+00:00"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Launch;
 * import com.pulumi.aws.evidently.LaunchArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchGroupArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Launch("example", LaunchArgs.builder()
 *             .name("example")
 *             .project(exampleAwsEvidentlyProject.name())
 *             .description("example description")
 *             .groups(LaunchGroupArgs.builder()
 *                 .feature(exampleAwsEvidentlyFeature.name())
 *                 .name("Variation1")
 *                 .variation("Variation1")
 *                 .build())
 *             .scheduledSplitsConfig(LaunchScheduledSplitsConfigArgs.builder()
 *                 .steps(LaunchScheduledSplitsConfigStepArgs.builder()
 *                     .groupWeights(Map.of("Variation1", 0))
 *                     .startTime("2024-01-07 01:43:59+00:00")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:evidently:Launch
 *     properties:
 *       name: example
 *       project: ${exampleAwsEvidentlyProject.name}
 *       description: example description
 *       groups:
 *         - feature: ${exampleAwsEvidentlyFeature.name}
 *           name: Variation1
 *           variation: Variation1
 *       scheduledSplitsConfig:
 *         steps:
 *           - groupWeights:
 *               Variation1: 0
 *             startTime: 2024-01-07 01:43:59+00:00
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With multiple groups
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.evidently.Launch("example", {
 *     name: "example",
 *     project: exampleAwsEvidentlyProject.name,
 *     groups: [
 *         {
 *             feature: exampleAwsEvidentlyFeature.name,
 *             name: "Variation1",
 *             variation: "Variation1",
 *             description: "first-group",
 *         },
 *         {
 *             feature: exampleAwsEvidentlyFeature.name,
 *             name: "Variation2",
 *             variation: "Variation2",
 *             description: "second-group",
 *         },
 *     ],
 *     scheduledSplitsConfig: {
 *         steps: [{
 *             groupWeights: {
 *                 Variation1: 0,
 *                 Variation2: 0,
 *             },
 *             startTime: "2024-01-07 01:43:59+00:00",
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.evidently.Launch("example",
 *     name="example",
 *     project=example_aws_evidently_project["name"],
 *     groups=[
 *         {
 *             "feature": example_aws_evidently_feature["name"],
 *             "name": "Variation1",
 *             "variation": "Variation1",
 *             "description": "first-group",
 *         },
 *         {
 *             "feature": example_aws_evidently_feature["name"],
 *             "name": "Variation2",
 *             "variation": "Variation2",
 *             "description": "second-group",
 *         },
 *     ],
 *     scheduled_splits_config={
 *         "steps": [{
 *             "group_weights": {
 *                 "variation1": 0,
 *                 "variation2": 0,
 *             },
 *             "start_time": "2024-01-07 01:43:59+00:00",
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Evidently.Launch("example", new()
 *     {
 *         Name = "example",
 *         Project = exampleAwsEvidentlyProject.Name,
 *         Groups = new[]
 *         {
 *             new Aws.Evidently.Inputs.LaunchGroupArgs
 *             {
 *                 Feature = exampleAwsEvidentlyFeature.Name,
 *                 Name = "Variation1",
 *                 Variation = "Variation1",
 *                 Description = "first-group",
 *             },
 *             new Aws.Evidently.Inputs.LaunchGroupArgs
 *             {
 *                 Feature = exampleAwsEvidentlyFeature.Name,
 *                 Name = "Variation2",
 *                 Variation = "Variation2",
 *                 Description = "second-group",
 *             },
 *         },
 *         ScheduledSplitsConfig = new Aws.Evidently.Inputs.LaunchScheduledSplitsConfigArgs
 *         {
 *             Steps = new[]
 *             {
 *                 new Aws.Evidently.Inputs.LaunchScheduledSplitsConfigStepArgs
 *                 {
 *                     GroupWeights =
 *                     {
 *                         { "Variation1", 0 },
 *                         { "Variation2", 0 },
 *                     },
 *                     StartTime = "2024-01-07 01:43:59+00:00",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/evidently"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := evidently.NewLaunch(ctx, "example", &evidently.LaunchArgs{
 * 			Name:    pulumi.String("example"),
 * 			Project: pulumi.Any(exampleAwsEvidentlyProject.Name),
 * 			Groups: evidently.LaunchGroupArray{
 * 				&evidently.LaunchGroupArgs{
 * 					Feature:     pulumi.Any(exampleAwsEvidentlyFeature.Name),
 * 					Name:        pulumi.String("Variation1"),
 * 					Variation:   pulumi.String("Variation1"),
 * 					Description: pulumi.String("first-group"),
 * 				},
 * 				&evidently.LaunchGroupArgs{
 * 					Feature:     pulumi.Any(exampleAwsEvidentlyFeature.Name),
 * 					Name:        pulumi.String("Variation2"),
 * 					Variation:   pulumi.String("Variation2"),
 * 					Description: pulumi.String("second-group"),
 * 				},
 * 			},
 * 			ScheduledSplitsConfig: &evidently.LaunchScheduledSplitsConfigArgs{
 * 				Steps: evidently.LaunchScheduledSplitsConfigStepArray{
 * 					&evidently.LaunchScheduledSplitsConfigStepArgs{
 * 						GroupWeights: pulumi.IntMap{
 * 							"Variation1": pulumi.Int(0),
 * 							"Variation2": pulumi.Int(0),
 * 						},
 * 						StartTime: pulumi.String("2024-01-07 01:43:59+00:00"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Launch;
 * import com.pulumi.aws.evidently.LaunchArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchGroupArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Launch("example", LaunchArgs.builder()
 *             .name("example")
 *             .project(exampleAwsEvidentlyProject.name())
 *             .groups(
 *                 LaunchGroupArgs.builder()
 *                     .feature(exampleAwsEvidentlyFeature.name())
 *                     .name("Variation1")
 *                     .variation("Variation1")
 *                     .description("first-group")
 *                     .build(),
 *                 LaunchGroupArgs.builder()
 *                     .feature(exampleAwsEvidentlyFeature.name())
 *                     .name("Variation2")
 *                     .variation("Variation2")
 *                     .description("second-group")
 *                     .build())
 *             .scheduledSplitsConfig(LaunchScheduledSplitsConfigArgs.builder()
 *                 .steps(LaunchScheduledSplitsConfigStepArgs.builder()
 *                     .groupWeights(Map.ofEntries(
 *                         Map.entry("Variation1", 0),
 *                         Map.entry("Variation2", 0)
 *                     ))
 *                     .startTime("2024-01-07 01:43:59+00:00")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:evidently:Launch
 *     properties:
 *       name: example
 *       project: ${exampleAwsEvidentlyProject.name}
 *       groups:
 *         - feature: ${exampleAwsEvidentlyFeature.name}
 *           name: Variation1
 *           variation: Variation1
 *           description: first-group
 *         - feature: ${exampleAwsEvidentlyFeature.name}
 *           name: Variation2
 *           variation: Variation2
 *           description: second-group
 *       scheduledSplitsConfig:
 *         steps:
 *           - groupWeights:
 *               Variation1: 0
 *               Variation2: 0
 *             startTime: 2024-01-07 01:43:59+00:00
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With metric_monitors
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.evidently.Launch("example", {
 *     name: "example",
 *     project: exampleAwsEvidentlyProject.name,
 *     groups: [{
 *         feature: exampleAwsEvidentlyFeature.name,
 *         name: "Variation1",
 *         variation: "Variation1",
 *     }],
 *     metricMonitors: [
 *         {
 *             metricDefinition: {
 *                 entityIdKey: "entity_id_key1",
 *                 eventPattern: "{\"Price\":[{\"numeric\":[\">\",11,\"<=\",22]}]}",
 *                 name: "name1",
 *                 unitLabel: "unit_label1",
 *                 valueKey: "value_key1",
 *             },
 *         },
 *         {
 *             metricDefinition: {
 *                 entityIdKey: "entity_id_key2",
 *                 eventPattern: "{\"Price\":[{\"numeric\":[\">\",9,\"<=\",19]}]}",
 *                 name: "name2",
 *                 unitLabel: "unit_label2",
 *                 valueKey: "value_key2",
 *             },
 *         },
 *     ],
 *     scheduledSplitsConfig: {
 *         steps: [{
 *             groupWeights: {
 *                 Variation1: 0,
 *             },
 *             startTime: "2024-01-07 01:43:59+00:00",
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.evidently.Launch("example",
 *     name="example",
 *     project=example_aws_evidently_project["name"],
 *     groups=[{
 *         "feature": example_aws_evidently_feature["name"],
 *         "name": "Variation1",
 *         "variation": "Variation1",
 *     }],
 *     metric_monitors=[
 *         {
 *             "metric_definition": {
 *                 "entity_id_key": "entity_id_key1",
 *                 "event_pattern": "{\"Price\":[{\"numeric\":[\">\",11,\"<=\",22]}]}",
 *                 "name": "name1",
 *                 "unit_label": "unit_label1",
 *                 "value_key": "value_key1",
 *             },
 *         },
 *         {
 *             "metric_definition": {
 *                 "entity_id_key": "entity_id_key2",
 *                 "event_pattern": "{\"Price\":[{\"numeric\":[\">\",9,\"<=\",19]}]}",
 *                 "name": "name2",
 *                 "unit_label": "unit_label2",
 *                 "value_key": "value_key2",
 *             },
 *         },
 *     ],
 *     scheduled_splits_config={
 *         "steps": [{
 *             "group_weights": {
 *                 "variation1": 0,
 *             },
 *             "start_time": "2024-01-07 01:43:59+00:00",
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Evidently.Launch("example", new()
 *     {
 *         Name = "example",
 *         Project = exampleAwsEvidentlyProject.Name,
 *         Groups = new[]
 *         {
 *             new Aws.Evidently.Inputs.LaunchGroupArgs
 *             {
 *                 Feature = exampleAwsEvidentlyFeature.Name,
 *                 Name = "Variation1",
 *                 Variation = "Variation1",
 *             },
 *         },
 *         MetricMonitors = new[]
 *         {
 *             new Aws.Evidently.Inputs.LaunchMetricMonitorArgs
 *             {
 *                 MetricDefinition = new Aws.Evidently.Inputs.LaunchMetricMonitorMetricDefinitionArgs
 *                 {
 *                     EntityIdKey = "entity_id_key1",
 *                     EventPattern = "{\"Price\":[{\"numeric\":[\">\",11,\"<=\",22]}]}",
 *                     Name = "name1",
 *                     UnitLabel = "unit_label1",
 *                     ValueKey = "value_key1",
 *                 },
 *             },
 *             new Aws.Evidently.Inputs.LaunchMetricMonitorArgs
 *             {
 *                 MetricDefinition = new Aws.Evidently.Inputs.LaunchMetricMonitorMetricDefinitionArgs
 *                 {
 *                     EntityIdKey = "entity_id_key2",
 *                     EventPattern = "{\"Price\":[{\"numeric\":[\">\",9,\"<=\",19]}]}",
 *                     Name = "name2",
 *                     UnitLabel = "unit_label2",
 *                     ValueKey = "value_key2",
 *                 },
 *             },
 *         },
 *         ScheduledSplitsConfig = new Aws.Evidently.Inputs.LaunchScheduledSplitsConfigArgs
 *         {
 *             Steps = new[]
 *             {
 *                 new Aws.Evidently.Inputs.LaunchScheduledSplitsConfigStepArgs
 *                 {
 *                     GroupWeights =
 *                     {
 *                         { "Variation1", 0 },
 *                     },
 *                     StartTime = "2024-01-07 01:43:59+00:00",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/evidently"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := evidently.NewLaunch(ctx, "example", &evidently.LaunchArgs{
 * 			Name:    pulumi.String("example"),
 * 			Project: pulumi.Any(exampleAwsEvidentlyProject.Name),
 * 			Groups: evidently.LaunchGroupArray{
 * 				&evidently.LaunchGroupArgs{
 * 					Feature:   pulumi.Any(exampleAwsEvidentlyFeature.Name),
 * 					Name:      pulumi.String("Variation1"),
 * 					Variation: pulumi.String("Variation1"),
 * 				},
 * 			},
 * 			MetricMonitors: evidently.LaunchMetricMonitorArray{
 * 				&evidently.LaunchMetricMonitorArgs{
 * 					MetricDefinition: &evidently.LaunchMetricMonitorMetricDefinitionArgs{
 * 						EntityIdKey:  pulumi.String("entity_id_key1"),
 * 						EventPattern: pulumi.String("{\"Price\":[{\"numeric\":[\">\",11,\"<=\",22]}]}"),
 * 						Name:         pulumi.String("name1"),
 * 						UnitLabel:    pulumi.String("unit_label1"),
 * 						ValueKey:     pulumi.String("value_key1"),
 * 					},
 * 				},
 * 				&evidently.LaunchMetricMonitorArgs{
 * 					MetricDefinition: &evidently.LaunchMetricMonitorMetricDefinitionArgs{
 * 						EntityIdKey:  pulumi.String("entity_id_key2"),
 * 						EventPattern: pulumi.String("{\"Price\":[{\"numeric\":[\">\",9,\"<=\",19]}]}"),
 * 						Name:         pulumi.String("name2"),
 * 						UnitLabel:    pulumi.String("unit_label2"),
 * 						ValueKey:     pulumi.String("value_key2"),
 * 					},
 * 				},
 * 			},
 * 			ScheduledSplitsConfig: &evidently.LaunchScheduledSplitsConfigArgs{
 * 				Steps: evidently.LaunchScheduledSplitsConfigStepArray{
 * 					&evidently.LaunchScheduledSplitsConfigStepArgs{
 * 						GroupWeights: pulumi.IntMap{
 * 							"Variation1": pulumi.Int(0),
 * 						},
 * 						StartTime: pulumi.String("2024-01-07 01:43:59+00:00"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Launch;
 * import com.pulumi.aws.evidently.LaunchArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchGroupArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchMetricMonitorArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchMetricMonitorMetricDefinitionArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Launch("example", LaunchArgs.builder()
 *             .name("example")
 *             .project(exampleAwsEvidentlyProject.name())
 *             .groups(LaunchGroupArgs.builder()
 *                 .feature(exampleAwsEvidentlyFeature.name())
 *                 .name("Variation1")
 *                 .variation("Variation1")
 *                 .build())
 *             .metricMonitors(
 *                 LaunchMetricMonitorArgs.builder()
 *                     .metricDefinition(LaunchMetricMonitorMetricDefinitionArgs.builder()
 *                         .entityIdKey("entity_id_key1")
 *                         .eventPattern("{\"Price\":[{\"numeric\":[\">\",11,\"<=\",22]}]}")
 *                         .name("name1")
 *                         .unitLabel("unit_label1")
 *                         .valueKey("value_key1")
 *                         .build())
 *                     .build(),
 *                 LaunchMetricMonitorArgs.builder()
 *                     .metricDefinition(LaunchMetricMonitorMetricDefinitionArgs.builder()
 *                         .entityIdKey("entity_id_key2")
 *                         .eventPattern("{\"Price\":[{\"numeric\":[\">\",9,\"<=\",19]}]}")
 *                         .name("name2")
 *                         .unitLabel("unit_label2")
 *                         .valueKey("value_key2")
 *                         .build())
 *                     .build())
 *             .scheduledSplitsConfig(LaunchScheduledSplitsConfigArgs.builder()
 *                 .steps(LaunchScheduledSplitsConfigStepArgs.builder()
 *                     .groupWeights(Map.of("Variation1", 0))
 *                     .startTime("2024-01-07 01:43:59+00:00")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:evidently:Launch
 *     properties:
 *       name: example
 *       project: ${exampleAwsEvidentlyProject.name}
 *       groups:
 *         - feature: ${exampleAwsEvidentlyFeature.name}
 *           name: Variation1
 *           variation: Variation1
 *       metricMonitors:
 *         - metricDefinition:
 *             entityIdKey: entity_id_key1
 *             eventPattern: '{"Price":[{"numeric":[">",11,"<=",22]}]}'
 *             name: name1
 *             unitLabel: unit_label1
 *             valueKey: value_key1
 *         - metricDefinition:
 *             entityIdKey: entity_id_key2
 *             eventPattern: '{"Price":[{"numeric":[">",9,"<=",19]}]}'
 *             name: name2
 *             unitLabel: unit_label2
 *             valueKey: value_key2
 *       scheduledSplitsConfig:
 *         steps:
 *           - groupWeights:
 *               Variation1: 0
 *             startTime: 2024-01-07 01:43:59+00:00
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With randomization_salt
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.evidently.Launch("example", {
 *     name: "example",
 *     project: exampleAwsEvidentlyProject.name,
 *     randomizationSalt: "example randomization salt",
 *     groups: [{
 *         feature: exampleAwsEvidentlyFeature.name,
 *         name: "Variation1",
 *         variation: "Variation1",
 *     }],
 *     scheduledSplitsConfig: {
 *         steps: [{
 *             groupWeights: {
 *                 Variation1: 0,
 *             },
 *             startTime: "2024-01-07 01:43:59+00:00",
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.evidently.Launch("example",
 *     name="example",
 *     project=example_aws_evidently_project["name"],
 *     randomization_salt="example randomization salt",
 *     groups=[{
 *         "feature": example_aws_evidently_feature["name"],
 *         "name": "Variation1",
 *         "variation": "Variation1",
 *     }],
 *     scheduled_splits_config={
 *         "steps": [{
 *             "group_weights": {
 *                 "variation1": 0,
 *             },
 *             "start_time": "2024-01-07 01:43:59+00:00",
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Evidently.Launch("example", new()
 *     {
 *         Name = "example",
 *         Project = exampleAwsEvidentlyProject.Name,
 *         RandomizationSalt = "example randomization salt",
 *         Groups = new[]
 *         {
 *             new Aws.Evidently.Inputs.LaunchGroupArgs
 *             {
 *                 Feature = exampleAwsEvidentlyFeature.Name,
 *                 Name = "Variation1",
 *                 Variation = "Variation1",
 *             },
 *         },
 *         ScheduledSplitsConfig = new Aws.Evidently.Inputs.LaunchScheduledSplitsConfigArgs
 *         {
 *             Steps = new[]
 *             {
 *                 new Aws.Evidently.Inputs.LaunchScheduledSplitsConfigStepArgs
 *                 {
 *                     GroupWeights =
 *                     {
 *                         { "Variation1", 0 },
 *                     },
 *                     StartTime = "2024-01-07 01:43:59+00:00",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/evidently"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := evidently.NewLaunch(ctx, "example", &evidently.LaunchArgs{
 * 			Name:              pulumi.String("example"),
 * 			Project:           pulumi.Any(exampleAwsEvidentlyProject.Name),
 * 			RandomizationSalt: pulumi.String("example randomization salt"),
 * 			Groups: evidently.LaunchGroupArray{
 * 				&evidently.LaunchGroupArgs{
 * 					Feature:   pulumi.Any(exampleAwsEvidentlyFeature.Name),
 * 					Name:      pulumi.String("Variation1"),
 * 					Variation: pulumi.String("Variation1"),
 * 				},
 * 			},
 * 			ScheduledSplitsConfig: &evidently.LaunchScheduledSplitsConfigArgs{
 * 				Steps: evidently.LaunchScheduledSplitsConfigStepArray{
 * 					&evidently.LaunchScheduledSplitsConfigStepArgs{
 * 						GroupWeights: pulumi.IntMap{
 * 							"Variation1": pulumi.Int(0),
 * 						},
 * 						StartTime: pulumi.String("2024-01-07 01:43:59+00:00"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Launch;
 * import com.pulumi.aws.evidently.LaunchArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchGroupArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Launch("example", LaunchArgs.builder()
 *             .name("example")
 *             .project(exampleAwsEvidentlyProject.name())
 *             .randomizationSalt("example randomization salt")
 *             .groups(LaunchGroupArgs.builder()
 *                 .feature(exampleAwsEvidentlyFeature.name())
 *                 .name("Variation1")
 *                 .variation("Variation1")
 *                 .build())
 *             .scheduledSplitsConfig(LaunchScheduledSplitsConfigArgs.builder()
 *                 .steps(LaunchScheduledSplitsConfigStepArgs.builder()
 *                     .groupWeights(Map.of("Variation1", 0))
 *                     .startTime("2024-01-07 01:43:59+00:00")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:evidently:Launch
 *     properties:
 *       name: example
 *       project: ${exampleAwsEvidentlyProject.name}
 *       randomizationSalt: example randomization salt
 *       groups:
 *         - feature: ${exampleAwsEvidentlyFeature.name}
 *           name: Variation1
 *           variation: Variation1
 *       scheduledSplitsConfig:
 *         steps:
 *           - groupWeights:
 *               Variation1: 0
 *             startTime: 2024-01-07 01:43:59+00:00
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With multiple steps
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.evidently.Launch("example", {
 *     name: "example",
 *     project: exampleAwsEvidentlyProject.name,
 *     groups: [
 *         {
 *             feature: exampleAwsEvidentlyFeature.name,
 *             name: "Variation1",
 *             variation: "Variation1",
 *         },
 *         {
 *             feature: exampleAwsEvidentlyFeature.name,
 *             name: "Variation2",
 *             variation: "Variation2",
 *         },
 *     ],
 *     scheduledSplitsConfig: {
 *         steps: [
 *             {
 *                 groupWeights: {
 *                     Variation1: 15,
 *                     Variation2: 10,
 *                 },
 *                 startTime: "2024-01-07 01:43:59+00:00",
 *             },
 *             {
 *                 groupWeights: {
 *                     Variation1: 20,
 *                     Variation2: 25,
 *                 },
 *                 startTime: "2024-01-08 01:43:59+00:00",
 *             },
 *         ],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.evidently.Launch("example",
 *     name="example",
 *     project=example_aws_evidently_project["name"],
 *     groups=[
 *         {
 *             "feature": example_aws_evidently_feature["name"],
 *             "name": "Variation1",
 *             "variation": "Variation1",
 *         },
 *         {
 *             "feature": example_aws_evidently_feature["name"],
 *             "name": "Variation2",
 *             "variation": "Variation2",
 *         },
 *     ],
 *     scheduled_splits_config={
 *         "steps": [
 *             {
 *                 "group_weights": {
 *                     "variation1": 15,
 *                     "variation2": 10,
 *                 },
 *                 "start_time": "2024-01-07 01:43:59+00:00",
 *             },
 *             {
 *                 "group_weights": {
 *                     "variation1": 20,
 *                     "variation2": 25,
 *                 },
 *                 "start_time": "2024-01-08 01:43:59+00:00",
 *             },
 *         ],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Evidently.Launch("example", new()
 *     {
 *         Name = "example",
 *         Project = exampleAwsEvidentlyProject.Name,
 *         Groups = new[]
 *         {
 *             new Aws.Evidently.Inputs.LaunchGroupArgs
 *             {
 *                 Feature = exampleAwsEvidentlyFeature.Name,
 *                 Name = "Variation1",
 *                 Variation = "Variation1",
 *             },
 *             new Aws.Evidently.Inputs.LaunchGroupArgs
 *             {
 *                 Feature = exampleAwsEvidentlyFeature.Name,
 *                 Name = "Variation2",
 *                 Variation = "Variation2",
 *             },
 *         },
 *         ScheduledSplitsConfig = new Aws.Evidently.Inputs.LaunchScheduledSplitsConfigArgs
 *         {
 *             Steps = new[]
 *             {
 *                 new Aws.Evidently.Inputs.LaunchScheduledSplitsConfigStepArgs
 *                 {
 *                     GroupWeights =
 *                     {
 *                         { "Variation1", 15 },
 *                         { "Variation2", 10 },
 *                     },
 *                     StartTime = "2024-01-07 01:43:59+00:00",
 *                 },
 *                 new Aws.Evidently.Inputs.LaunchScheduledSplitsConfigStepArgs
 *                 {
 *                     GroupWeights =
 *                     {
 *                         { "Variation1", 20 },
 *                         { "Variation2", 25 },
 *                     },
 *                     StartTime = "2024-01-08 01:43:59+00:00",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/evidently"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := evidently.NewLaunch(ctx, "example", &evidently.LaunchArgs{
 * 			Name:    pulumi.String("example"),
 * 			Project: pulumi.Any(exampleAwsEvidentlyProject.Name),
 * 			Groups: evidently.LaunchGroupArray{
 * 				&evidently.LaunchGroupArgs{
 * 					Feature:   pulumi.Any(exampleAwsEvidentlyFeature.Name),
 * 					Name:      pulumi.String("Variation1"),
 * 					Variation: pulumi.String("Variation1"),
 * 				},
 * 				&evidently.LaunchGroupArgs{
 * 					Feature:   pulumi.Any(exampleAwsEvidentlyFeature.Name),
 * 					Name:      pulumi.String("Variation2"),
 * 					Variation: pulumi.String("Variation2"),
 * 				},
 * 			},
 * 			ScheduledSplitsConfig: &evidently.LaunchScheduledSplitsConfigArgs{
 * 				Steps: evidently.LaunchScheduledSplitsConfigStepArray{
 * 					&evidently.LaunchScheduledSplitsConfigStepArgs{
 * 						GroupWeights: pulumi.IntMap{
 * 							"Variation1": pulumi.Int(15),
 * 							"Variation2": pulumi.Int(10),
 * 						},
 * 						StartTime: pulumi.String("2024-01-07 01:43:59+00:00"),
 * 					},
 * 					&evidently.LaunchScheduledSplitsConfigStepArgs{
 * 						GroupWeights: pulumi.IntMap{
 * 							"Variation1": pulumi.Int(20),
 * 							"Variation2": pulumi.Int(25),
 * 						},
 * 						StartTime: pulumi.String("2024-01-08 01:43:59+00:00"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Launch;
 * import com.pulumi.aws.evidently.LaunchArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchGroupArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Launch("example", LaunchArgs.builder()
 *             .name("example")
 *             .project(exampleAwsEvidentlyProject.name())
 *             .groups(
 *                 LaunchGroupArgs.builder()
 *                     .feature(exampleAwsEvidentlyFeature.name())
 *                     .name("Variation1")
 *                     .variation("Variation1")
 *                     .build(),
 *                 LaunchGroupArgs.builder()
 *                     .feature(exampleAwsEvidentlyFeature.name())
 *                     .name("Variation2")
 *                     .variation("Variation2")
 *                     .build())
 *             .scheduledSplitsConfig(LaunchScheduledSplitsConfigArgs.builder()
 *                 .steps(
 *                     LaunchScheduledSplitsConfigStepArgs.builder()
 *                         .groupWeights(Map.ofEntries(
 *                             Map.entry("Variation1", 15),
 *                             Map.entry("Variation2", 10)
 *                         ))
 *                         .startTime("2024-01-07 01:43:59+00:00")
 *                         .build(),
 *                     LaunchScheduledSplitsConfigStepArgs.builder()
 *                         .groupWeights(Map.ofEntries(
 *                             Map.entry("Variation1", 20),
 *                             Map.entry("Variation2", 25)
 *                         ))
 *                         .startTime("2024-01-08 01:43:59+00:00")
 *                         .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:evidently:Launch
 *     properties:
 *       name: example
 *       project: ${exampleAwsEvidentlyProject.name}
 *       groups:
 *         - feature: ${exampleAwsEvidentlyFeature.name}
 *           name: Variation1
 *           variation: Variation1
 *         - feature: ${exampleAwsEvidentlyFeature.name}
 *           name: Variation2
 *           variation: Variation2
 *       scheduledSplitsConfig:
 *         steps:
 *           - groupWeights:
 *               Variation1: 15
 *               Variation2: 10
 *             startTime: 2024-01-07 01:43:59+00:00
 *           - groupWeights:
 *               Variation1: 20
 *               Variation2: 25
 *             startTime: 2024-01-08 01:43:59+00:00
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With segment overrides
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.evidently.Launch("example", {
 *     name: "example",
 *     project: exampleAwsEvidentlyProject.name,
 *     groups: [
 *         {
 *             feature: exampleAwsEvidentlyFeature.name,
 *             name: "Variation1",
 *             variation: "Variation1",
 *         },
 *         {
 *             feature: exampleAwsEvidentlyFeature.name,
 *             name: "Variation2",
 *             variation: "Variation2",
 *         },
 *     ],
 *     scheduledSplitsConfig: {
 *         steps: [{
 *             groupWeights: {
 *                 Variation1: 0,
 *                 Variation2: 0,
 *             },
 *             segmentOverrides: [
 *                 {
 *                     evaluationOrder: 1,
 *                     segment: exampleAwsEvidentlySegment.name,
 *                     weights: {
 *                         Variation2: 10000,
 *                     },
 *                 },
 *                 {
 *                     evaluationOrder: 2,
 *                     segment: exampleAwsEvidentlySegment.name,
 *                     weights: {
 *                         Variation1: 40000,
 *                         Variation2: 30000,
 *                     },
 *                 },
 *             ],
 *             startTime: "2024-01-08 01:43:59+00:00",
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.evidently.Launch("example",
 *     name="example",
 *     project=example_aws_evidently_project["name"],
 *     groups=[
 *         {
 *             "feature": example_aws_evidently_feature["name"],
 *             "name": "Variation1",
 *             "variation": "Variation1",
 *         },
 *         {
 *             "feature": example_aws_evidently_feature["name"],
 *             "name": "Variation2",
 *             "variation": "Variation2",
 *         },
 *     ],
 *     scheduled_splits_config={
 *         "steps": [{
 *             "group_weights": {
 *                 "variation1": 0,
 *                 "variation2": 0,
 *             },
 *             "segment_overrides": [
 *                 {
 *                     "evaluation_order": 1,
 *                     "segment": example_aws_evidently_segment["name"],
 *                     "weights": {
 *                         "variation2": 10000,
 *                     },
 *                 },
 *                 {
 *                     "evaluation_order": 2,
 *                     "segment": example_aws_evidently_segment["name"],
 *                     "weights": {
 *                         "variation1": 40000,
 *                         "variation2": 30000,
 *                     },
 *                 },
 *             ],
 *             "start_time": "2024-01-08 01:43:59+00:00",
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Evidently.Launch("example", new()
 *     {
 *         Name = "example",
 *         Project = exampleAwsEvidentlyProject.Name,
 *         Groups = new[]
 *         {
 *             new Aws.Evidently.Inputs.LaunchGroupArgs
 *             {
 *                 Feature = exampleAwsEvidentlyFeature.Name,
 *                 Name = "Variation1",
 *                 Variation = "Variation1",
 *             },
 *             new Aws.Evidently.Inputs.LaunchGroupArgs
 *             {
 *                 Feature = exampleAwsEvidentlyFeature.Name,
 *                 Name = "Variation2",
 *                 Variation = "Variation2",
 *             },
 *         },
 *         ScheduledSplitsConfig = new Aws.Evidently.Inputs.LaunchScheduledSplitsConfigArgs
 *         {
 *             Steps = new[]
 *             {
 *                 new Aws.Evidently.Inputs.LaunchScheduledSplitsConfigStepArgs
 *                 {
 *                     GroupWeights =
 *                     {
 *                         { "Variation1", 0 },
 *                         { "Variation2", 0 },
 *                     },
 *                     SegmentOverrides = new[]
 *                     {
 *                         new Aws.Evidently.Inputs.LaunchScheduledSplitsConfigStepSegmentOverrideArgs
 *                         {
 *                             EvaluationOrder = 1,
 *                             Segment = exampleAwsEvidentlySegment.Name,
 *                             Weights =
 *                             {
 *                                 { "Variation2", 10000 },
 *                             },
 *                         },
 *                         new Aws.Evidently.Inputs.LaunchScheduledSplitsConfigStepSegmentOverrideArgs
 *                         {
 *                             EvaluationOrder = 2,
 *                             Segment = exampleAwsEvidentlySegment.Name,
 *                             Weights =
 *                             {
 *                                 { "Variation1", 40000 },
 *                                 { "Variation2", 30000 },
 *                             },
 *                         },
 *                     },
 *                     StartTime = "2024-01-08 01:43:59+00:00",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/evidently"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := evidently.NewLaunch(ctx, "example", &evidently.LaunchArgs{
 * 			Name:    pulumi.String("example"),
 * 			Project: pulumi.Any(exampleAwsEvidentlyProject.Name),
 * 			Groups: evidently.LaunchGroupArray{
 * 				&evidently.LaunchGroupArgs{
 * 					Feature:   pulumi.Any(exampleAwsEvidentlyFeature.Name),
 * 					Name:      pulumi.String("Variation1"),
 * 					Variation: pulumi.String("Variation1"),
 * 				},
 * 				&evidently.LaunchGroupArgs{
 * 					Feature:   pulumi.Any(exampleAwsEvidentlyFeature.Name),
 * 					Name:      pulumi.String("Variation2"),
 * 					Variation: pulumi.String("Variation2"),
 * 				},
 * 			},
 * 			ScheduledSplitsConfig: &evidently.LaunchScheduledSplitsConfigArgs{
 * 				Steps: evidently.LaunchScheduledSplitsConfigStepArray{
 * 					&evidently.LaunchScheduledSplitsConfigStepArgs{
 * 						GroupWeights: pulumi.IntMap{
 * 							"Variation1": pulumi.Int(0),
 * 							"Variation2": pulumi.Int(0),
 * 						},
 * 						SegmentOverrides: evidently.LaunchScheduledSplitsConfigStepSegmentOverrideArray{
 * 							&evidently.LaunchScheduledSplitsConfigStepSegmentOverrideArgs{
 * 								EvaluationOrder: pulumi.Int(1),
 * 								Segment:         pulumi.Any(exampleAwsEvidentlySegment.Name),
 * 								Weights: pulumi.IntMap{
 * 									"Variation2": pulumi.Int(10000),
 * 								},
 * 							},
 * 							&evidently.LaunchScheduledSplitsConfigStepSegmentOverrideArgs{
 * 								EvaluationOrder: pulumi.Int(2),
 * 								Segment:         pulumi.Any(exampleAwsEvidentlySegment.Name),
 * 								Weights: pulumi.IntMap{
 * 									"Variation1": pulumi.Int(40000),
 * 									"Variation2": pulumi.Int(30000),
 * 								},
 * 							},
 * 						},
 * 						StartTime: pulumi.String("2024-01-08 01:43:59+00:00"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Launch;
 * import com.pulumi.aws.evidently.LaunchArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchGroupArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Launch("example", LaunchArgs.builder()
 *             .name("example")
 *             .project(exampleAwsEvidentlyProject.name())
 *             .groups(
 *                 LaunchGroupArgs.builder()
 *                     .feature(exampleAwsEvidentlyFeature.name())
 *                     .name("Variation1")
 *                     .variation("Variation1")
 *                     .build(),
 *                 LaunchGroupArgs.builder()
 *                     .feature(exampleAwsEvidentlyFeature.name())
 *                     .name("Variation2")
 *                     .variation("Variation2")
 *                     .build())
 *             .scheduledSplitsConfig(LaunchScheduledSplitsConfigArgs.builder()
 *                 .steps(LaunchScheduledSplitsConfigStepArgs.builder()
 *                     .groupWeights(Map.ofEntries(
 *                         Map.entry("Variation1", 0),
 *                         Map.entry("Variation2", 0)
 *                     ))
 *                     .segmentOverrides(
 *                         LaunchScheduledSplitsConfigStepSegmentOverrideArgs.builder()
 *                             .evaluationOrder(1)
 *                             .segment(exampleAwsEvidentlySegment.name())
 *                             .weights(Map.of("Variation2", 10000))
 *                             .build(),
 *                         LaunchScheduledSplitsConfigStepSegmentOverrideArgs.builder()
 *                             .evaluationOrder(2)
 *                             .segment(exampleAwsEvidentlySegment.name())
 *                             .weights(Map.ofEntries(
 *                                 Map.entry("Variation1", 40000),
 *                                 Map.entry("Variation2", 30000)
 *                             ))
 *                             .build())
 *                     .startTime("2024-01-08 01:43:59+00:00")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:evidently:Launch
 *     properties:
 *       name: example
 *       project: ${exampleAwsEvidentlyProject.name}
 *       groups:
 *         - feature: ${exampleAwsEvidentlyFeature.name}
 *           name: Variation1
 *           variation: Variation1
 *         - feature: ${exampleAwsEvidentlyFeature.name}
 *           name: Variation2
 *           variation: Variation2
 *       scheduledSplitsConfig:
 *         steps:
 *           - groupWeights:
 *               Variation1: 0
 *               Variation2: 0
 *             segmentOverrides:
 *               - evaluationOrder: 1
 *                 segment: ${exampleAwsEvidentlySegment.name}
 *                 weights:
 *                   Variation2: 10000
 *               - evaluationOrder: 2
 *                 segment: ${exampleAwsEvidentlySegment.name}
 *                 weights:
 *                   Variation1: 40000
 *                   Variation2: 30000
 *             startTime: 2024-01-08 01:43:59+00:00
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Import using the `name` of the launch and `arn` of the project separated by a `:`:
 * __Using `pulumi import` to import__ CloudWatch Evidently Launch using the `name` of the launch and `name` of the project or `arn` of the hosting CloudWatch Evidently Project separated by a `:`. For example:
 * Import using the `name` of the launch and `name` of the project separated by a `:`:
 * ```sh
 * $ pulumi import aws:evidently/launch:Launch example exampleLaunchName:exampleProjectName
 * ```
 * Import using the `name` of the launch and `arn` of the project separated by a `:`:
 * ```sh
 * $ pulumi import aws:evidently/launch:Launch example exampleLaunchName:arn:aws:evidently:us-east-1:123456789012:project/exampleProjectName
 * ```
 * @property description Specifies the description of the launch.
 * @property groups One or up to five blocks that contain the feature and variations that are to be used for the launch. Detailed below.
 * @property metricMonitors One or up to three blocks that define the metrics that will be used to monitor the launch performance. Detailed below.
 * @property name The name for the new launch. Minimum length of `1`. Maximum length of `127`.
 * @property project The name or ARN of the project that is to contain the new launch.
 * @property randomizationSalt When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and randomizationSalt. If you omit randomizationSalt, Evidently uses the launch name as the randomizationSalt.
 * @property scheduledSplitsConfig A block that defines the traffic allocation percentages among the feature variations during each step of the launch. Detailed below.
 * @property tags Tags to apply to the launch. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class LaunchArgs(
    public val description: Output<String>? = null,
    public val groups: Output<List<LaunchGroupArgs>>? = null,
    public val metricMonitors: Output<List<LaunchMetricMonitorArgs>>? = null,
    public val name: Output<String>? = null,
    public val project: Output<String>? = null,
    public val randomizationSalt: Output<String>? = null,
    public val scheduledSplitsConfig: Output<LaunchScheduledSplitsConfigArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.evidently.LaunchArgs> {
    override fun toJava(): com.pulumi.aws.evidently.LaunchArgs =
        com.pulumi.aws.evidently.LaunchArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .groups(groups?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .metricMonitors(
                metricMonitors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 }))
            .randomizationSalt(randomizationSalt?.applyValue({ args0 -> args0 }))
            .scheduledSplitsConfig(
                scheduledSplitsConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [LaunchArgs].
 */
@PulumiTagMarker
public class LaunchArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var groups: Output<List<LaunchGroupArgs>>? = null

    private var metricMonitors: Output<List<LaunchMetricMonitorArgs>>? = null

    private var name: Output<String>? = null

    private var project: Output<String>? = null

    private var randomizationSalt: Output<String>? = null

    private var scheduledSplitsConfig: Output<LaunchScheduledSplitsConfigArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifies the description of the launch.
     */
    @JvmName("itlvslkbeqfhiifu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value One or up to five blocks that contain the feature and variations that are to be used for the launch. Detailed below.
     */
    @JvmName("etrdmcglqttiriib")
    public suspend fun groups(`value`: Output<List<LaunchGroupArgs>>) {
        this.groups = value
    }

    @JvmName("xdhrpjeemuierfsd")
    public suspend fun groups(vararg values: Output<LaunchGroupArgs>) {
        this.groups = Output.all(values.asList())
    }

    /**
     * @param values One or up to five blocks that contain the feature and variations that are to be used for the launch. Detailed below.
     */
    @JvmName("cliugjoflrwscvdo")
    public suspend fun groups(values: List<Output<LaunchGroupArgs>>) {
        this.groups = Output.all(values)
    }

    /**
     * @param value One or up to three blocks that define the metrics that will be used to monitor the launch performance. Detailed below.
     */
    @JvmName("bnnnixkmyposgbhu")
    public suspend fun metricMonitors(`value`: Output<List<LaunchMetricMonitorArgs>>) {
        this.metricMonitors = value
    }

    @JvmName("ngxcnjmjitheriho")
    public suspend fun metricMonitors(vararg values: Output<LaunchMetricMonitorArgs>) {
        this.metricMonitors = Output.all(values.asList())
    }

    /**
     * @param values One or up to three blocks that define the metrics that will be used to monitor the launch performance. Detailed below.
     */
    @JvmName("injdsgwdrwkhoitq")
    public suspend fun metricMonitors(values: List<Output<LaunchMetricMonitorArgs>>) {
        this.metricMonitors = Output.all(values)
    }

    /**
     * @param value The name for the new launch. Minimum length of `1`. Maximum length of `127`.
     */
    @JvmName("eperlvuomymjwqlo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name or ARN of the project that is to contain the new launch.
     */
    @JvmName("hphcdhliknpvjjjp")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and randomizationSalt. If you omit randomizationSalt, Evidently uses the launch name as the randomizationSalt.
     */
    @JvmName("uoebddjprlvxjsna")
    public suspend fun randomizationSalt(`value`: Output<String>) {
        this.randomizationSalt = value
    }

    /**
     * @param value A block that defines the traffic allocation percentages among the feature variations during each step of the launch. Detailed below.
     */
    @JvmName("fivftkwhpuraltuh")
    public suspend fun scheduledSplitsConfig(`value`: Output<LaunchScheduledSplitsConfigArgs>) {
        this.scheduledSplitsConfig = value
    }

    /**
     * @param value Tags to apply to the launch. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rrnynpcxviwxbrid")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the description of the launch.
     */
    @JvmName("ileqrtsjdwdwrsdy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value One or up to five blocks that contain the feature and variations that are to be used for the launch. Detailed below.
     */
    @JvmName("ushsxlhnguewpnhs")
    public suspend fun groups(`value`: List<LaunchGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groups = mapped
    }

    /**
     * @param argument One or up to five blocks that contain the feature and variations that are to be used for the launch. Detailed below.
     */
    @JvmName("omjomrvjaygqngus")
    public suspend fun groups(argument: List<suspend LaunchGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { LaunchGroupArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.groups = mapped
    }

    /**
     * @param argument One or up to five blocks that contain the feature and variations that are to be used for the launch. Detailed below.
     */
    @JvmName("cmjehpwkwaimfcso")
    public suspend fun groups(vararg argument: suspend LaunchGroupArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { LaunchGroupArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.groups = mapped
    }

    /**
     * @param argument One or up to five blocks that contain the feature and variations that are to be used for the launch. Detailed below.
     */
    @JvmName("aqycesijrmkdiipe")
    public suspend fun groups(argument: suspend LaunchGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LaunchGroupArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.groups = mapped
    }

    /**
     * @param values One or up to five blocks that contain the feature and variations that are to be used for the launch. Detailed below.
     */
    @JvmName("rbosjguphbkgrmxa")
    public suspend fun groups(vararg values: LaunchGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groups = mapped
    }

    /**
     * @param value One or up to three blocks that define the metrics that will be used to monitor the launch performance. Detailed below.
     */
    @JvmName("mvlygxvuqfngoluj")
    public suspend fun metricMonitors(`value`: List<LaunchMetricMonitorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricMonitors = mapped
    }

    /**
     * @param argument One or up to three blocks that define the metrics that will be used to monitor the launch performance. Detailed below.
     */
    @JvmName("kenlddiuhmigmcey")
    public suspend fun metricMonitors(argument: List<suspend LaunchMetricMonitorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LaunchMetricMonitorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.metricMonitors = mapped
    }

    /**
     * @param argument One or up to three blocks that define the metrics that will be used to monitor the launch performance. Detailed below.
     */
    @JvmName("idxnardgnhyhxxvw")
    public suspend fun metricMonitors(vararg argument: suspend LaunchMetricMonitorArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LaunchMetricMonitorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.metricMonitors = mapped
    }

    /**
     * @param argument One or up to three blocks that define the metrics that will be used to monitor the launch performance. Detailed below.
     */
    @JvmName("oivnomktackrsmxu")
    public suspend fun metricMonitors(argument: suspend LaunchMetricMonitorArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LaunchMetricMonitorArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.metricMonitors = mapped
    }

    /**
     * @param values One or up to three blocks that define the metrics that will be used to monitor the launch performance. Detailed below.
     */
    @JvmName("wfsvdyjkpeykgiod")
    public suspend fun metricMonitors(vararg values: LaunchMetricMonitorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricMonitors = mapped
    }

    /**
     * @param value The name for the new launch. Minimum length of `1`. Maximum length of `127`.
     */
    @JvmName("aaguaddjdrfexifm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name or ARN of the project that is to contain the new launch.
     */
    @JvmName("evgxfslbjlxfhehd")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and randomizationSalt. If you omit randomizationSalt, Evidently uses the launch name as the randomizationSalt.
     */
    @JvmName("rrgqhwfsfjvroxbt")
    public suspend fun randomizationSalt(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.randomizationSalt = mapped
    }

    /**
     * @param value A block that defines the traffic allocation percentages among the feature variations during each step of the launch. Detailed below.
     */
    @JvmName("hnsxajysjlbxibcg")
    public suspend fun scheduledSplitsConfig(`value`: LaunchScheduledSplitsConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduledSplitsConfig = mapped
    }

    /**
     * @param argument A block that defines the traffic allocation percentages among the feature variations during each step of the launch. Detailed below.
     */
    @JvmName("luvxtaqwrgavoppg")
    public suspend fun scheduledSplitsConfig(argument: suspend LaunchScheduledSplitsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = LaunchScheduledSplitsConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scheduledSplitsConfig = mapped
    }

    /**
     * @param value Tags to apply to the launch. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("urjvnujuuutfckvp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags to apply to the launch. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mfahtdtawpqkxbkf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): LaunchArgs = LaunchArgs(
        description = description,
        groups = groups,
        metricMonitors = metricMonitors,
        name = name,
        project = project,
        randomizationSalt = randomizationSalt,
        scheduledSplitsConfig = scheduledSplitsConfig,
        tags = tags,
    )
}
