@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.evidently.kotlin

import com.pulumi.aws.evidently.kotlin.outputs.ProjectDataDelivery
import com.pulumi.aws.evidently.kotlin.outputs.ProjectDataDelivery.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Project].
 */
@PulumiTagMarker
public class ProjectResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProjectArgs = ProjectArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProjectArgsBuilder.() -> Unit) {
        val builder = ProjectArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Project {
        val builtJavaResource = com.pulumi.aws.evidently.Project(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Project(builtJavaResource)
    }
}

/**
 * Provides a CloudWatch Evidently Project resource.
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.evidently.Project("example", {
 *     name: "Example",
 *     description: "Example Description",
 *     tags: {
 *         Key1: "example Project",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.evidently.Project("example",
 *     name="Example",
 *     description="Example Description",
 *     tags={
 *         "Key1": "example Project",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Evidently.Project("example", new()
 *     {
 *         Name = "Example",
 *         Description = "Example Description",
 *         Tags =
 *         {
 *             { "Key1", "example Project" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/evidently"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := evidently.NewProject(ctx, "example", &evidently.ProjectArgs{
 * 			Name:        pulumi.String("Example"),
 * 			Description: pulumi.String("Example Description"),
 * 			Tags: pulumi.StringMap{
 * 				"Key1": pulumi.String("example Project"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Project;
 * import com.pulumi.aws.evidently.ProjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Project("example", ProjectArgs.builder()
 *             .name("Example")
 *             .description("Example Description")
 *             .tags(Map.of("Key1", "example Project"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:evidently:Project
 *     properties:
 *       name: Example
 *       description: Example Description
 *       tags:
 *         Key1: example Project
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Store evaluation events in a CloudWatch Log Group
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.evidently.Project("example", {
 *     name: "Example",
 *     description: "Example Description",
 *     dataDelivery: {
 *         cloudwatchLogs: {
 *             logGroup: "example-log-group-name",
 *         },
 *     },
 *     tags: {
 *         Key1: "example Project",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.evidently.Project("example",
 *     name="Example",
 *     description="Example Description",
 *     data_delivery={
 *         "cloudwatch_logs": {
 *             "log_group": "example-log-group-name",
 *         },
 *     },
 *     tags={
 *         "Key1": "example Project",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Evidently.Project("example", new()
 *     {
 *         Name = "Example",
 *         Description = "Example Description",
 *         DataDelivery = new Aws.Evidently.Inputs.ProjectDataDeliveryArgs
 *         {
 *             CloudwatchLogs = new Aws.Evidently.Inputs.ProjectDataDeliveryCloudwatchLogsArgs
 *             {
 *                 LogGroup = "example-log-group-name",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Key1", "example Project" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/evidently"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := evidently.NewProject(ctx, "example", &evidently.ProjectArgs{
 * 			Name:        pulumi.String("Example"),
 * 			Description: pulumi.String("Example Description"),
 * 			DataDelivery: &evidently.ProjectDataDeliveryArgs{
 * 				CloudwatchLogs: &evidently.ProjectDataDeliveryCloudwatchLogsArgs{
 * 					LogGroup: pulumi.String("example-log-group-name"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Key1": pulumi.String("example Project"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Project;
 * import com.pulumi.aws.evidently.ProjectArgs;
 * import com.pulumi.aws.evidently.inputs.ProjectDataDeliveryArgs;
 * import com.pulumi.aws.evidently.inputs.ProjectDataDeliveryCloudwatchLogsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Project("example", ProjectArgs.builder()
 *             .name("Example")
 *             .description("Example Description")
 *             .dataDelivery(ProjectDataDeliveryArgs.builder()
 *                 .cloudwatchLogs(ProjectDataDeliveryCloudwatchLogsArgs.builder()
 *                     .logGroup("example-log-group-name")
 *                     .build())
 *                 .build())
 *             .tags(Map.of("Key1", "example Project"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:evidently:Project
 *     properties:
 *       name: Example
 *       description: Example Description
 *       dataDelivery:
 *         cloudwatchLogs:
 *           logGroup: example-log-group-name
 *       tags:
 *         Key1: example Project
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Store evaluation events in an S3 bucket
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.evidently.Project("example", {
 *     name: "Example",
 *     description: "Example Description",
 *     dataDelivery: {
 *         s3Destination: {
 *             bucket: "example-bucket-name",
 *             prefix: "example",
 *         },
 *     },
 *     tags: {
 *         Key1: "example Project",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.evidently.Project("example",
 *     name="Example",
 *     description="Example Description",
 *     data_delivery={
 *         "s3_destination": {
 *             "bucket": "example-bucket-name",
 *             "prefix": "example",
 *         },
 *     },
 *     tags={
 *         "Key1": "example Project",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Evidently.Project("example", new()
 *     {
 *         Name = "Example",
 *         Description = "Example Description",
 *         DataDelivery = new Aws.Evidently.Inputs.ProjectDataDeliveryArgs
 *         {
 *             S3Destination = new Aws.Evidently.Inputs.ProjectDataDeliveryS3DestinationArgs
 *             {
 *                 Bucket = "example-bucket-name",
 *                 Prefix = "example",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Key1", "example Project" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/evidently"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := evidently.NewProject(ctx, "example", &evidently.ProjectArgs{
 * 			Name:        pulumi.String("Example"),
 * 			Description: pulumi.String("Example Description"),
 * 			DataDelivery: &evidently.ProjectDataDeliveryArgs{
 * 				S3Destination: &evidently.ProjectDataDeliveryS3DestinationArgs{
 * 					Bucket: pulumi.String("example-bucket-name"),
 * 					Prefix: pulumi.String("example"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Key1": pulumi.String("example Project"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Project;
 * import com.pulumi.aws.evidently.ProjectArgs;
 * import com.pulumi.aws.evidently.inputs.ProjectDataDeliveryArgs;
 * import com.pulumi.aws.evidently.inputs.ProjectDataDeliveryS3DestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Project("example", ProjectArgs.builder()
 *             .name("Example")
 *             .description("Example Description")
 *             .dataDelivery(ProjectDataDeliveryArgs.builder()
 *                 .s3Destination(ProjectDataDeliveryS3DestinationArgs.builder()
 *                     .bucket("example-bucket-name")
 *                     .prefix("example")
 *                     .build())
 *                 .build())
 *             .tags(Map.of("Key1", "example Project"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:evidently:Project
 *     properties:
 *       name: Example
 *       description: Example Description
 *       dataDelivery:
 *         s3Destination:
 *           bucket: example-bucket-name
 *           prefix: example
 *       tags:
 *         Key1: example Project
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CloudWatch Evidently Project using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:evidently/project:Project example arn:aws:evidently:us-east-1:123456789012:segment/example
 * ```
 */
public class Project internal constructor(
    override val javaResource: com.pulumi.aws.evidently.Project,
) : KotlinCustomResource(javaResource, ProjectMapper) {
    /**
     * The number of ongoing experiments currently in the project.
     */
    public val activeExperimentCount: Output<Int>
        get() = javaResource.activeExperimentCount().applyValue({ args0 -> args0 })

    /**
     * The number of ongoing launches currently in the project.
     */
    public val activeLaunchCount: Output<Int>
        get() = javaResource.activeLaunchCount().applyValue({ args0 -> args0 })

    /**
     * The ARN of the project.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The date and time that the project is created.
     */
    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    /**
     * A block that contains information about where Evidently is to store evaluation events for longer term storage, if you choose to do so. If you choose not to store these events, Evidently deletes them after using them to produce metrics and other experiment results that you can view. See below.
     */
    public val dataDelivery: Output<ProjectDataDelivery>?
        get() = javaResource.dataDelivery().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Specifies the description of the project.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of experiments currently in the project. This includes all experiments that have been created and not deleted, whether they are ongoing or not.
     */
    public val experimentCount: Output<Int>
        get() = javaResource.experimentCount().applyValue({ args0 -> args0 })

    /**
     * The number of features currently in the project.
     */
    public val featureCount: Output<Int>
        get() = javaResource.featureCount().applyValue({ args0 -> args0 })

    /**
     * The date and time that the project was most recently updated.
     */
    public val lastUpdatedTime: Output<String>
        get() = javaResource.lastUpdatedTime().applyValue({ args0 -> args0 })

    /**
     * The number of launches currently in the project. This includes all launches that have been created and not deleted, whether they are ongoing or not.
     */
    public val launchCount: Output<Int>
        get() = javaResource.launchCount().applyValue({ args0 -> args0 })

    /**
     * A name for the project.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The current state of the project. Valid values are `AVAILABLE` and `UPDATING`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Tags to apply to the project. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ProjectMapper : ResourceMapper<Project> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.evidently.Project::class == javaResource::class

    override fun map(javaResource: Resource): Project = Project(
        javaResource as
            com.pulumi.aws.evidently.Project,
    )
}

/**
 * @see [Project].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Project].
 */
public suspend fun project(name: String, block: suspend ProjectResourceBuilder.() -> Unit): Project {
    val builder = ProjectResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Project].
 * @param name The _unique_ name of the resulting resource.
 */
public fun project(name: String): Project {
    val builder = ProjectResourceBuilder()
    builder.name(name)
    return builder.build()
}
