@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.evidently.kotlin

import com.pulumi.aws.evidently.SegmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CloudWatch Evidently Segment resource.
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.evidently.Segment("example", {
 *     name: "example",
 *     pattern: "{\"Price\":[{\"numeric\":[\">\",10,\"<=\",20]}]}",
 *     tags: {
 *         Key1: "example Segment",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.evidently.Segment("example",
 *     name="example",
 *     pattern="{\"Price\":[{\"numeric\":[\">\",10,\"<=\",20]}]}",
 *     tags={
 *         "Key1": "example Segment",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Evidently.Segment("example", new()
 *     {
 *         Name = "example",
 *         Pattern = "{\"Price\":[{\"numeric\":[\">\",10,\"<=\",20]}]}",
 *         Tags =
 *         {
 *             { "Key1", "example Segment" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/evidently"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := evidently.NewSegment(ctx, "example", &evidently.SegmentArgs{
 * 			Name:    pulumi.String("example"),
 * 			Pattern: pulumi.String("{\"Price\":[{\"numeric\":[\">\",10,\"<=\",20]}]}"),
 * 			Tags: pulumi.StringMap{
 * 				"Key1": pulumi.String("example Segment"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Segment;
 * import com.pulumi.aws.evidently.SegmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Segment("example", SegmentArgs.builder()
 *             .name("example")
 *             .pattern("{\"Price\":[{\"numeric\":[\">\",10,\"<=\",20]}]}")
 *             .tags(Map.of("Key1", "example Segment"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:evidently:Segment
 *     properties:
 *       name: example
 *       pattern: '{"Price":[{"numeric":[">",10,"<=",20]}]}'
 *       tags:
 *         Key1: example Segment
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With JSON object in pattern
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.evidently.Segment("example", {
 *     name: "example",
 *     pattern: `  {
 *     "Price": [
 *       {
 *         "numeric": [">",10,"<=",20]
 *       }
 *     ]
 *   }
 * `,
 *     tags: {
 *         Key1: "example Segment",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.evidently.Segment("example",
 *     name="example",
 *     pattern="""  {
 *     "Price": [
 *       {
 *         "numeric": [">",10,"<=",20]
 *       }
 *     ]
 *   }
 * """,
 *     tags={
 *         "Key1": "example Segment",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Evidently.Segment("example", new()
 *     {
 *         Name = "example",
 *         Pattern = @"  {
 *     ""Price"": [
 *       {
 *         ""numeric"": ["">"",10,""<="",20]
 *       }
 *     ]
 *   }
 * ",
 *         Tags =
 *         {
 *             { "Key1", "example Segment" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/evidently"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := evidently.NewSegment(ctx, "example", &evidently.SegmentArgs{
 * 			Name: pulumi.String("example"),
 * 			Pattern: pulumi.String(`  {
 *     "Price": [
 *       {
 *         "numeric": [">",10,"<=",20]
 *       }
 *     ]
 *   }
 * `),
 * 			Tags: pulumi.StringMap{
 * 				"Key1": pulumi.String("example Segment"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Segment;
 * import com.pulumi.aws.evidently.SegmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Segment("example", SegmentArgs.builder()
 *             .name("example")
 *             .pattern("""
 *   {
 *     "Price": [
 *       {
 *         "numeric": [">",10,"<=",20]
 *       }
 *     ]
 *   }
 *             """)
 *             .tags(Map.of("Key1", "example Segment"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:evidently:Segment
 *     properties:
 *       name: example
 *       pattern: |2
 *           {
 *             "Price": [
 *               {
 *                 "numeric": [">",10,"<=",20]
 *               }
 *             ]
 *           }
 *       tags:
 *         Key1: example Segment
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Description
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.evidently.Segment("example", {
 *     name: "example",
 *     pattern: "{\"Price\":[{\"numeric\":[\">\",10,\"<=\",20]}]}",
 *     description: "example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.evidently.Segment("example",
 *     name="example",
 *     pattern="{\"Price\":[{\"numeric\":[\">\",10,\"<=\",20]}]}",
 *     description="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Evidently.Segment("example", new()
 *     {
 *         Name = "example",
 *         Pattern = "{\"Price\":[{\"numeric\":[\">\",10,\"<=\",20]}]}",
 *         Description = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/evidently"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := evidently.NewSegment(ctx, "example", &evidently.SegmentArgs{
 * 			Name:        pulumi.String("example"),
 * 			Pattern:     pulumi.String("{\"Price\":[{\"numeric\":[\">\",10,\"<=\",20]}]}"),
 * 			Description: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Segment;
 * import com.pulumi.aws.evidently.SegmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Segment("example", SegmentArgs.builder()
 *             .name("example")
 *             .pattern("{\"Price\":[{\"numeric\":[\">\",10,\"<=\",20]}]}")
 *             .description("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:evidently:Segment
 *     properties:
 *       name: example
 *       pattern: '{"Price":[{"numeric":[">",10,"<=",20]}]}'
 *       description: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CloudWatch Evidently Segment using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:evidently/segment:Segment example arn:aws:evidently:us-west-2:123456789012:segment/example
 * ```
 * @property description Specifies the description of the segment.
 * @property name A name for the segment.
 * @property pattern The pattern to use for the segment. For more information about pattern syntax, see [Segment rule pattern syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-segments.html#CloudWatch-Evidently-segments-syntax.html).
 * @property tags Tags to apply to the segment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class SegmentArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val pattern: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.evidently.SegmentArgs> {
    override fun toJava(): com.pulumi.aws.evidently.SegmentArgs =
        com.pulumi.aws.evidently.SegmentArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .pattern(pattern?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SegmentArgs].
 */
@PulumiTagMarker
public class SegmentArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var pattern: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifies the description of the segment.
     */
    @JvmName("hyonjucqdmeqarii")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A name for the segment.
     */
    @JvmName("ojrisajtrlqbrxar")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The pattern to use for the segment. For more information about pattern syntax, see [Segment rule pattern syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-segments.html#CloudWatch-Evidently-segments-syntax.html).
     */
    @JvmName("mwaguuvpspcahgfv")
    public suspend fun pattern(`value`: Output<String>) {
        this.pattern = value
    }

    /**
     * @param value Tags to apply to the segment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qynaucdbpvllcbah")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the description of the segment.
     */
    @JvmName("hrfivwakayrcggxq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A name for the segment.
     */
    @JvmName("cjghovbtykjtusfe")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The pattern to use for the segment. For more information about pattern syntax, see [Segment rule pattern syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-segments.html#CloudWatch-Evidently-segments-syntax.html).
     */
    @JvmName("jxouoxjsprtjlkob")
    public suspend fun pattern(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pattern = mapped
    }

    /**
     * @param value Tags to apply to the segment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("eqdayanimypukiqt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags to apply to the segment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kcscbxmmjkmtxsue")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SegmentArgs = SegmentArgs(
        description = description,
        name = name,
        pattern = pattern,
        tags = tags,
    )
}
