@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.evidently.kotlin.inputs

import com.pulumi.aws.evidently.inputs.FeatureVariationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the variation. Minimum length of `1`. Maximum length of `127`.
 * @property value A block that specifies the value assigned to this variation. Detailed below
 */
public data class FeatureVariationArgs(
    public val name: Output<String>,
    public val `value`: Output<FeatureVariationValueArgs>,
) : ConvertibleToJava<com.pulumi.aws.evidently.inputs.FeatureVariationArgs> {
    override fun toJava(): com.pulumi.aws.evidently.inputs.FeatureVariationArgs =
        com.pulumi.aws.evidently.inputs.FeatureVariationArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [FeatureVariationArgs].
 */
@PulumiTagMarker
public class FeatureVariationArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<FeatureVariationValueArgs>? = null

    /**
     * @param value The name of the variation. Minimum length of `1`. Maximum length of `127`.
     */
    @JvmName("rypegfmwinkjubfk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A block that specifies the value assigned to this variation. Detailed below
     */
    @JvmName("knaannmxarksoyka")
    public suspend fun `value`(`value`: Output<FeatureVariationValueArgs>) {
        this.`value` = value
    }

    /**
     * @param value The name of the variation. Minimum length of `1`. Maximum length of `127`.
     */
    @JvmName("gmxyumktjstykjbf")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A block that specifies the value assigned to this variation. Detailed below
     */
    @JvmName("tepumiirlckcgcuk")
    public suspend fun `value`(`value`: FeatureVariationValueArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    /**
     * @param argument A block that specifies the value assigned to this variation. Detailed below
     */
    @JvmName("mkeiqhtlcnbbueyj")
    public suspend fun `value`(argument: suspend FeatureVariationValueArgsBuilder.() -> Unit) {
        val toBeMapped = FeatureVariationValueArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.`value` = mapped
    }

    internal fun build(): FeatureVariationArgs = FeatureVariationArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
