@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.evidently.kotlin.inputs

import com.pulumi.aws.evidently.inputs.FeatureVariationValueArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property boolValue If this feature uses the Boolean variation type, this field contains the Boolean value of this variation.
 * @property doubleValue If this feature uses the double integer variation type, this field contains the double integer value of this variation.
 * @property longValue If this feature uses the long variation type, this field contains the long value of this variation. Minimum value of `-9007199254740991`. Maximum value of `9007199254740991`.
 * @property stringValue If this feature uses the string variation type, this field contains the string value of this variation. Minimum length of `0`. Maximum length of `512`.
 */
public data class FeatureVariationValueArgs(
    public val boolValue: Output<String>? = null,
    public val doubleValue: Output<String>? = null,
    public val longValue: Output<String>? = null,
    public val stringValue: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.evidently.inputs.FeatureVariationValueArgs> {
    override fun toJava(): com.pulumi.aws.evidently.inputs.FeatureVariationValueArgs =
        com.pulumi.aws.evidently.inputs.FeatureVariationValueArgs.builder()
            .boolValue(boolValue?.applyValue({ args0 -> args0 }))
            .doubleValue(doubleValue?.applyValue({ args0 -> args0 }))
            .longValue(longValue?.applyValue({ args0 -> args0 }))
            .stringValue(stringValue?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FeatureVariationValueArgs].
 */
@PulumiTagMarker
public class FeatureVariationValueArgsBuilder internal constructor() {
    private var boolValue: Output<String>? = null

    private var doubleValue: Output<String>? = null

    private var longValue: Output<String>? = null

    private var stringValue: Output<String>? = null

    /**
     * @param value If this feature uses the Boolean variation type, this field contains the Boolean value of this variation.
     */
    @JvmName("sbyuhftgokhibdfa")
    public suspend fun boolValue(`value`: Output<String>) {
        this.boolValue = value
    }

    /**
     * @param value If this feature uses the double integer variation type, this field contains the double integer value of this variation.
     */
    @JvmName("dtrjhsuywxvcxayp")
    public suspend fun doubleValue(`value`: Output<String>) {
        this.doubleValue = value
    }

    /**
     * @param value If this feature uses the long variation type, this field contains the long value of this variation. Minimum value of `-9007199254740991`. Maximum value of `9007199254740991`.
     */
    @JvmName("gtqxsqavgbasgfdf")
    public suspend fun longValue(`value`: Output<String>) {
        this.longValue = value
    }

    /**
     * @param value If this feature uses the string variation type, this field contains the string value of this variation. Minimum length of `0`. Maximum length of `512`.
     */
    @JvmName("fvdvtvhdovhriwcc")
    public suspend fun stringValue(`value`: Output<String>) {
        this.stringValue = value
    }

    /**
     * @param value If this feature uses the Boolean variation type, this field contains the Boolean value of this variation.
     */
    @JvmName("ewcwxgjwplahbnbu")
    public suspend fun boolValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.boolValue = mapped
    }

    /**
     * @param value If this feature uses the double integer variation type, this field contains the double integer value of this variation.
     */
    @JvmName("jsectkkigvcnqgln")
    public suspend fun doubleValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.doubleValue = mapped
    }

    /**
     * @param value If this feature uses the long variation type, this field contains the long value of this variation. Minimum value of `-9007199254740991`. Maximum value of `9007199254740991`.
     */
    @JvmName("xuuusgytxqxakaub")
    public suspend fun longValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.longValue = mapped
    }

    /**
     * @param value If this feature uses the string variation type, this field contains the string value of this variation. Minimum length of `0`. Maximum length of `512`.
     */
    @JvmName("pfudbvimtfdqgxti")
    public suspend fun stringValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stringValue = mapped
    }

    internal fun build(): FeatureVariationValueArgs = FeatureVariationValueArgs(
        boolValue = boolValue,
        doubleValue = doubleValue,
        longValue = longValue,
        stringValue = stringValue,
    )
}
