@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.evidently.kotlin.inputs

import com.pulumi.aws.evidently.inputs.LaunchGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property description Specifies the description of the launch group.
 * @property feature Specifies the name of the feature that the launch is using.
 * @property name Specifies the name of the lahnch group.
 * @property variation Specifies the feature variation to use for this launch group.
 */
public data class LaunchGroupArgs(
    public val description: Output<String>? = null,
    public val feature: Output<String>,
    public val name: Output<String>,
    public val variation: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.evidently.inputs.LaunchGroupArgs> {
    override fun toJava(): com.pulumi.aws.evidently.inputs.LaunchGroupArgs =
        com.pulumi.aws.evidently.inputs.LaunchGroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .feature(feature.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .variation(variation.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LaunchGroupArgs].
 */
@PulumiTagMarker
public class LaunchGroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var feature: Output<String>? = null

    private var name: Output<String>? = null

    private var variation: Output<String>? = null

    /**
     * @param value Specifies the description of the launch group.
     */
    @JvmName("tvrwcaugegltrkhn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies the name of the feature that the launch is using.
     */
    @JvmName("wrykajnsgarrcpui")
    public suspend fun feature(`value`: Output<String>) {
        this.feature = value
    }

    /**
     * @param value Specifies the name of the lahnch group.
     */
    @JvmName("oaiarohoiplnjywn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies the feature variation to use for this launch group.
     */
    @JvmName("qrjkwkmurhkxyqpe")
    public suspend fun variation(`value`: Output<String>) {
        this.variation = value
    }

    /**
     * @param value Specifies the description of the launch group.
     */
    @JvmName("jpiqnyoofugafsiw")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies the name of the feature that the launch is using.
     */
    @JvmName("bviifuifmwgapwub")
    public suspend fun feature(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.feature = mapped
    }

    /**
     * @param value Specifies the name of the lahnch group.
     */
    @JvmName("rmcbauukaaeynbnj")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies the feature variation to use for this launch group.
     */
    @JvmName("nacafaykwpctrfin")
    public suspend fun variation(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.variation = mapped
    }

    internal fun build(): LaunchGroupArgs = LaunchGroupArgs(
        description = description,
        feature = feature ?: throw PulumiNullFieldException("feature"),
        name = name ?: throw PulumiNullFieldException("name"),
        variation = variation ?: throw PulumiNullFieldException("variation"),
    )
}
