@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.evidently.kotlin.inputs

import com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigStepArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property groupWeights The traffic allocation percentages among the feature variations during one step of a launch. This is a set of key-value pairs. The keys are variation names. The values represent the percentage of traffic to allocate to that variation during this step. For more information, refer to the [AWS documentation for ScheduledSplitConfig groupWeights](https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ScheduledSplitConfig.html).
 * @property segmentOverrides One or up to six blocks that specify different traffic splits for one or more audience segments. A segment is a portion of your audience that share one or more characteristics. Examples could be Chrome browser users, users in Europe, or Firefox browser users in Europe who also fit other criteria that your application collects, such as age. Detailed below.
 * @property startTime Specifies the date and time that this step of the launch starts.
 */
public data class LaunchScheduledSplitsConfigStepArgs(
    public val groupWeights: Output<Map<String, Int>>,
    public val segmentOverrides: Output<List<LaunchScheduledSplitsConfigStepSegmentOverrideArgs>>? =
        null,
    public val startTime: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigStepArgs> {
    override fun toJava(): com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigStepArgs =
        com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigStepArgs.builder()
            .groupWeights(
                groupWeights.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .segmentOverrides(
                segmentOverrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .startTime(startTime.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LaunchScheduledSplitsConfigStepArgs].
 */
@PulumiTagMarker
public class LaunchScheduledSplitsConfigStepArgsBuilder internal constructor() {
    private var groupWeights: Output<Map<String, Int>>? = null

    private var segmentOverrides: Output<List<LaunchScheduledSplitsConfigStepSegmentOverrideArgs>>? =
        null

    private var startTime: Output<String>? = null

    /**
     * @param value The traffic allocation percentages among the feature variations during one step of a launch. This is a set of key-value pairs. The keys are variation names. The values represent the percentage of traffic to allocate to that variation during this step. For more information, refer to the [AWS documentation for ScheduledSplitConfig groupWeights](https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ScheduledSplitConfig.html).
     */
    @JvmName("luvrswpvymkckaca")
    public suspend fun groupWeights(`value`: Output<Map<String, Int>>) {
        this.groupWeights = value
    }

    /**
     * @param value One or up to six blocks that specify different traffic splits for one or more audience segments. A segment is a portion of your audience that share one or more characteristics. Examples could be Chrome browser users, users in Europe, or Firefox browser users in Europe who also fit other criteria that your application collects, such as age. Detailed below.
     */
    @JvmName("mosvurpnhaujqscj")
    public suspend fun segmentOverrides(`value`: Output<List<LaunchScheduledSplitsConfigStepSegmentOverrideArgs>>) {
        this.segmentOverrides = value
    }

    @JvmName("ymiepwfksyojyave")
    public suspend fun segmentOverrides(vararg values: Output<LaunchScheduledSplitsConfigStepSegmentOverrideArgs>) {
        this.segmentOverrides = Output.all(values.asList())
    }

    /**
     * @param values One or up to six blocks that specify different traffic splits for one or more audience segments. A segment is a portion of your audience that share one or more characteristics. Examples could be Chrome browser users, users in Europe, or Firefox browser users in Europe who also fit other criteria that your application collects, such as age. Detailed below.
     */
    @JvmName("dpkrjxxfhjvnbtij")
    public suspend fun segmentOverrides(values: List<Output<LaunchScheduledSplitsConfigStepSegmentOverrideArgs>>) {
        this.segmentOverrides = Output.all(values)
    }

    /**
     * @param value Specifies the date and time that this step of the launch starts.
     */
    @JvmName("cqffnijdatcpbnfj")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value The traffic allocation percentages among the feature variations during one step of a launch. This is a set of key-value pairs. The keys are variation names. The values represent the percentage of traffic to allocate to that variation during this step. For more information, refer to the [AWS documentation for ScheduledSplitConfig groupWeights](https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ScheduledSplitConfig.html).
     */
    @JvmName("bisgbbxfgwjggtgi")
    public suspend fun groupWeights(`value`: Map<String, Int>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupWeights = mapped
    }

    /**
     * @param values The traffic allocation percentages among the feature variations during one step of a launch. This is a set of key-value pairs. The keys are variation names. The values represent the percentage of traffic to allocate to that variation during this step. For more information, refer to the [AWS documentation for ScheduledSplitConfig groupWeights](https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ScheduledSplitConfig.html).
     */
    @JvmName("ebnfvbkyvvasgvrm")
    public fun groupWeights(vararg values: Pair<String, Int>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupWeights = mapped
    }

    /**
     * @param value One or up to six blocks that specify different traffic splits for one or more audience segments. A segment is a portion of your audience that share one or more characteristics. Examples could be Chrome browser users, users in Europe, or Firefox browser users in Europe who also fit other criteria that your application collects, such as age. Detailed below.
     */
    @JvmName("fhjemjkskqbvcglo")
    public suspend fun segmentOverrides(`value`: List<LaunchScheduledSplitsConfigStepSegmentOverrideArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.segmentOverrides = mapped
    }

    /**
     * @param argument One or up to six blocks that specify different traffic splits for one or more audience segments. A segment is a portion of your audience that share one or more characteristics. Examples could be Chrome browser users, users in Europe, or Firefox browser users in Europe who also fit other criteria that your application collects, such as age. Detailed below.
     */
    @JvmName("mhjeewjjrxcmlvbe")
    public suspend fun segmentOverrides(argument: List<suspend LaunchScheduledSplitsConfigStepSegmentOverrideArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LaunchScheduledSplitsConfigStepSegmentOverrideArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.segmentOverrides = mapped
    }

    /**
     * @param argument One or up to six blocks that specify different traffic splits for one or more audience segments. A segment is a portion of your audience that share one or more characteristics. Examples could be Chrome browser users, users in Europe, or Firefox browser users in Europe who also fit other criteria that your application collects, such as age. Detailed below.
     */
    @JvmName("wijuntckskdjeqsj")
    public suspend fun segmentOverrides(vararg argument: suspend LaunchScheduledSplitsConfigStepSegmentOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LaunchScheduledSplitsConfigStepSegmentOverrideArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.segmentOverrides = mapped
    }

    /**
     * @param argument One or up to six blocks that specify different traffic splits for one or more audience segments. A segment is a portion of your audience that share one or more characteristics. Examples could be Chrome browser users, users in Europe, or Firefox browser users in Europe who also fit other criteria that your application collects, such as age. Detailed below.
     */
    @JvmName("ldwvemlcqtjtfsek")
    public suspend fun segmentOverrides(argument: suspend LaunchScheduledSplitsConfigStepSegmentOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            LaunchScheduledSplitsConfigStepSegmentOverrideArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.segmentOverrides = mapped
    }

    /**
     * @param values One or up to six blocks that specify different traffic splits for one or more audience segments. A segment is a portion of your audience that share one or more characteristics. Examples could be Chrome browser users, users in Europe, or Firefox browser users in Europe who also fit other criteria that your application collects, such as age. Detailed below.
     */
    @JvmName("hvfchmysdvnvsrag")
    public suspend fun segmentOverrides(vararg values: LaunchScheduledSplitsConfigStepSegmentOverrideArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.segmentOverrides = mapped
    }

    /**
     * @param value Specifies the date and time that this step of the launch starts.
     */
    @JvmName("svrtftfmysgcjmoy")
    public suspend fun startTime(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    internal fun build(): LaunchScheduledSplitsConfigStepArgs = LaunchScheduledSplitsConfigStepArgs(
        groupWeights = groupWeights ?: throw PulumiNullFieldException("groupWeights"),
        segmentOverrides = segmentOverrides,
        startTime = startTime ?: throw PulumiNullFieldException("startTime"),
    )
}
